/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.osgi;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.opendaylight.controller.config.facade.xml.ConfigSubsystemFacadeFactory;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreService;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.yangtools.sal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangStoreActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(YangStoreActivator.class);
    private final MBeanServer configMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private ServiceRegistration<YangStoreService> yangStoreServiceServiceRegistration;
    private ConfigRegistryLookupThread configRegistryLookup = null;
    private BundleContext context;
    private ServiceRegistration<ConfigSubsystemFacadeFactory> osgiRegistrayion;

    public void start(final BundleContext context) throws Exception {
        LOG.debug("ConfigPersister starting");
        this.context = context;
        ServiceTrackerCustomizer<SchemaContextProvider, YangStoreService> schemaServiceTrackerCustomizer = new ServiceTrackerCustomizer<SchemaContextProvider, YangStoreService>(){
            private final AtomicBoolean alreadyStarted = new AtomicBoolean(false);

            public YangStoreService addingService(ServiceReference<SchemaContextProvider> reference) {
                LOG.debug("Got addingService(SchemaContextProvider) event");
                if (reference.getProperty(SchemaSourceProvider.class.getName()) == null && reference.getProperty(BindingRuntimeContext.class.getName()) == null) {
                    LOG.debug("SchemaContextProvider not from config-manager. Ignoring");
                    return null;
                }
                if (!this.alreadyStarted.compareAndSet(false, true)) {
                    LOG.warn("Starting yang store service multiple times. Received new service {}", reference);
                    throw new RuntimeException("Starting yang store service multiple times");
                }
                SchemaContextProvider schemaContextProvider = (SchemaContextProvider)reference.getBundle().getBundleContext().getService(reference);
                Object sourceProvider = Preconditions.checkNotNull((Object)reference.getProperty(SchemaSourceProvider.class.getName()), (Object)"Source provider not found");
                Preconditions.checkArgument((boolean)(sourceProvider instanceof SchemaSourceProvider));
                YangStoreService yangStoreService = new YangStoreService(schemaContextProvider, (SchemaSourceProvider<YangTextSchemaSource>)((SchemaSourceProvider)sourceProvider));
                BindingRuntimeContext runtimeContext = (BindingRuntimeContext)reference.getProperty(BindingRuntimeContext.class.getName());
                LOG.debug("BindingRuntimeContext retrieved as {}", (Object)runtimeContext);
                if (runtimeContext != null) {
                    yangStoreService.refresh(runtimeContext);
                }
                YangStoreActivator.this.yangStoreServiceServiceRegistration = context.registerService(YangStoreService.class, (Object)yangStoreService, new Hashtable());
                YangStoreActivator.this.configRegistryLookup = new ConfigRegistryLookupThread(yangStoreService);
                YangStoreActivator.this.configRegistryLookup.start();
                return yangStoreService;
            }

            public void modifiedService(ServiceReference<SchemaContextProvider> reference, YangStoreService service) {
                if (service == null) {
                    return;
                }
                LOG.debug("Got modifiedService(SchemaContextProvider) event");
                BindingRuntimeContext runtimeContext = (BindingRuntimeContext)reference.getProperty(BindingRuntimeContext.class.getName());
                LOG.debug("BindingRuntimeContext retrieved as {}", (Object)runtimeContext);
                service.refresh(runtimeContext);
            }

            public void removedService(ServiceReference<SchemaContextProvider> reference, YangStoreService service) {
                if (service == null) {
                    return;
                }
                LOG.debug("Got removedService(SchemaContextProvider) event");
                this.alreadyStarted.set(false);
                YangStoreActivator.this.configRegistryLookup.interrupt();
                YangStoreActivator.this.yangStoreServiceServiceRegistration.unregister();
                YangStoreActivator.this.yangStoreServiceServiceRegistration = null;
            }
        };
        ServiceTracker schemaContextProviderServiceTracker = new ServiceTracker(context, SchemaContextProvider.class, (ServiceTrackerCustomizer)schemaServiceTrackerCustomizer);
        schemaContextProviderServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.configRegistryLookup != null) {
            this.configRegistryLookup.interrupt();
        }
        if (this.osgiRegistrayion != null) {
            this.osgiRegistrayion.unregister();
        }
        if (this.yangStoreServiceServiceRegistration != null) {
            this.yangStoreServiceServiceRegistration.unregister();
            this.yangStoreServiceServiceRegistration = null;
        }
    }

    private class ConfigRegistryLookupThread
    extends Thread {
        public static final int ATTEMPT_TIMEOUT_MS = 1000;
        private static final int SILENT_ATTEMPTS = 30;
        private final YangStoreService yangStoreService;

        private ConfigRegistryLookupThread(YangStoreService yangStoreService) {
            super("config-registry-lookup");
            this.yangStoreService = yangStoreService;
        }

        @Override
        public void run() {
            ConfigRegistryJMXClient configRegistryJMXClientNoNotifications;
            ConfigRegistryJMXClient configRegistryJMXClient;
            int i = 0;
            while (true) {
                try {
                    configRegistryJMXClient = new ConfigRegistryJMXClient(YangStoreActivator.this.configMBeanServer);
                    configRegistryJMXClientNoNotifications = ConfigRegistryJMXClient.createWithoutNotifications((MBeanServer)YangStoreActivator.this.configMBeanServer);
                    break;
                }
                catch (IllegalStateException e) {
                    if (++i > 30) {
                        LOG.info("JMX client not created after {} attempts, still trying", (Object)i, (Object)e);
                    } else {
                        LOG.debug("JMX client could not be created, reattempting, try {}", (Object)i, (Object)e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Interrupted while reattempting connection", e1);
                    }
                }
            }
            ConfigRegistryJMXClient jmxClient = configRegistryJMXClient;
            ConfigRegistryJMXClient jmxClientNoNotifications = configRegistryJMXClientNoNotifications;
            if (i > 30) {
                LOG.info("Created JMX client after {} attempts", (Object)i);
            } else {
                LOG.debug("Created JMX client after {} attempts", (Object)i);
            }
            ConfigSubsystemFacadeFactory configSubsystemFacade = new ConfigSubsystemFacadeFactory((ConfigRegistryClient)jmxClient, jmxClientNoNotifications, this.yangStoreService);
            YangStoreActivator.this.osgiRegistrayion = YangStoreActivator.this.context.registerService(ConfigSubsystemFacadeFactory.class, (Object)configSubsystemFacade, new Hashtable());
        }
    }
}

