/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.mapping.config.Services;
import org.opendaylight.yangtools.yang.common.QName;

public class ServiceRegistryWrapper {
    private final ServiceReferenceReadableRegistry configServiceRefRegistry;

    public ServiceRegistryWrapper(ServiceReferenceReadableRegistry configServiceRefRegistry) {
        this.configServiceRefRegistry = configServiceRefRegistry;
    }

    public ObjectName getByServiceAndRefName(String namespace, String serviceType, String refName) {
        Map<String, Map<String, Map<String, String>>> mappedServices = this.getMappedServices();
        Map<String, Map<String, String>> serviceNameToRefNameToInstance = mappedServices.get(namespace);
        Preconditions.checkArgument((serviceNameToRefNameToInstance != null ? 1 : 0) != 0, (String)"No service mapped to %s:%s:%s. Wrong namespace, available namespaces: %s", (Object[])new Object[]{namespace, serviceType, refName, mappedServices.keySet()});
        Map<String, String> refNameToInstance = serviceNameToRefNameToInstance.get(serviceType);
        Preconditions.checkArgument((refNameToInstance != null ? 1 : 0) != 0, (String)"No service mapped to %s:%s:%s. Wrong service type, available service types: %s", (Object[])new Object[]{namespace, serviceType, refName, serviceNameToRefNameToInstance.keySet()});
        String instanceId = refNameToInstance.get(refName);
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (String)"No service mapped to %s:%s:%s. Wrong ref name, available ref names: %s", (Object[])new Object[]{namespace, serviceType, refName, refNameToInstance.keySet()});
        Services.ServiceInstance serviceInstance = Services.ServiceInstance.fromString(instanceId);
        Preconditions.checkArgument((serviceInstance != null ? 1 : 0) != 0, (String)"No service mapped to %s:%s:%s. Wrong ref name, available ref names: %s", (Object[])new Object[]{namespace, serviceType, refName, refNameToInstance.keySet()});
        String qNameOfService = this.configServiceRefRegistry.getServiceInterfaceName(namespace, serviceType);
        try {
            return ObjectNameUtil.withoutTransactionName((ObjectName)this.configServiceRefRegistry.getServiceReference(qNameOfService, refName));
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("No serviceInstance mapped to " + refName + " under service name " + serviceType + " , " + refNameToInstance.keySet(), e);
        }
    }

    public Map<String, Map<String, Map<String, String>>> getMappedServices() {
        HashMap retVal = Maps.newHashMap();
        Map serviceMapping = this.configServiceRefRegistry.getServiceMapping();
        for (Map.Entry qNameToRefNameEntry : serviceMapping.entrySet()) {
            for (String refName : ((Map)qNameToRefNameEntry.getValue()).keySet()) {
                String localName;
                Map refsToSis;
                ObjectName on = (ObjectName)((Map)qNameToRefNameEntry.getValue()).get(refName);
                Services.ServiceInstance si = Services.ServiceInstance.fromObjectName(on);
                QName qname = QName.create((String)((String)qNameToRefNameEntry.getKey()));
                String namespace = qname.getNamespace().toString();
                Map serviceToRefs = (Map)retVal.get(namespace);
                if (serviceToRefs == null) {
                    serviceToRefs = Maps.newHashMap();
                    retVal.put(namespace, serviceToRefs);
                }
                if ((refsToSis = (Map)serviceToRefs.get(localName = qname.getLocalName())) == null) {
                    refsToSis = Maps.newHashMap();
                    serviceToRefs.put(localName, refsToSis);
                }
                Preconditions.checkState((!refsToSis.containsKey(refName) ? 1 : 0) != 0, (String)"Duplicate reference name %s for service %s:%s, now for instance %s", (Object[])new Object[]{refName, namespace, localName, on});
                refsToSis.put(refName, si.toString());
            }
        }
        return retVal;
    }
}

