/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.config;

import com.google.common.base.Optional;
import java.util.Date;
import java.util.Map;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfig;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleConfig {
    private final String moduleName;
    private final InstanceConfig instanceConfig;

    public ModuleConfig(String moduleName, InstanceConfig mbeanMapping) {
        this.moduleName = moduleName;
        this.instanceConfig = mbeanMapping;
    }

    public Element toXml(ObjectName instanceON, Document document, String namespace, EnumResolver enumResolver) {
        Element root = XmlUtil.createElement((Document)document, (String)"module", (Optional)Optional.absent());
        Element typeElement = XmlUtil.createTextElementWithNamespacedContent((Document)document, (String)"type", (String)"prefix", (String)namespace, (String)this.moduleName);
        root.appendChild(typeElement);
        String instanceName = ObjectNameUtil.getInstanceName((ObjectName)instanceON);
        Element nameElement = XmlUtil.createTextElement((Document)document, (String)"name", (String)instanceName, (Optional)Optional.absent());
        root.appendChild(nameElement);
        root = this.instanceConfig.toXml(instanceON, namespace, document, root, enumResolver);
        return root;
    }

    public ModuleElementResolved fromXml(XmlElement moduleElement, ServiceRegistryWrapper depTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy, Map<String, Map<Date, IdentityMapping>> identityMap, EnumResolver enumResolver) throws DocumentedException {
        InstanceConfigElementResolved ice = this.instanceConfig.fromXml(moduleElement, depTracker, moduleNamespace, defaultStrategy, identityMap, enumResolver);
        return new ModuleElementResolved(instanceName, ice);
    }
}

