/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.config;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.ObjectXmlReader;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ObjectMapper;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.ObjectResolver;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.ObjectXmlWriter;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.BeanReader;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class InstanceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceConfig.class);
    private final Map<String, AttributeIfc> yangToAttrConfig;
    private final String nullableDummyContainerName;
    private final Map<String, AttributeIfc> jmxToAttrConfig;
    private final BeanReader configRegistryClient;

    public InstanceConfig(BeanReader configRegistryClient, Map<String, AttributeIfc> yangNamesToAttributes, String nullableDummyContainerName) {
        this.yangToAttrConfig = yangNamesToAttributes;
        this.nullableDummyContainerName = nullableDummyContainerName;
        this.jmxToAttrConfig = InstanceConfig.reverseMap(yangNamesToAttributes);
        this.configRegistryClient = configRegistryClient;
    }

    private Map<String, Object> getMappedConfiguration(ObjectName on, EnumResolver enumResolver) {
        Map<String, AttributeMappingStrategy<?, OpenType<?>>> mappingStrategies = new ObjectMapper().prepareMapping(this.jmxToAttrConfig, enumResolver);
        HashMap toXml = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> configDefEntry : this.jmxToAttrConfig.entrySet()) {
            if (configDefEntry.getValue() instanceof RuntimeBeanEntry) continue;
            Object value = this.configRegistryClient.getAttributeCurrentValue(on, configDefEntry.getKey());
            try {
                AttributeMappingStrategy<?, OpenType<?>> attributeMappingStrategy = mappingStrategies.get(configDefEntry.getKey());
                Optional<?> a = attributeMappingStrategy.mapAttribute(value);
                if (!a.isPresent()) continue;
                toXml.put(configDefEntry.getValue().getAttributeYangName(), a.get());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to map value " + value + " to attribute " + configDefEntry.getKey(), e);
            }
        }
        return toXml;
    }

    public Element toXml(ObjectName on, String namespace, Document document, Element rootElement, EnumResolver enumResolver) {
        Element parentElement;
        Map<String, AttributeWritingStrategy> strats = new ObjectXmlWriter().prepareWriting(this.yangToAttrConfig, document);
        Map<String, Object> mappedConfig = this.getMappedConfiguration(on, enumResolver);
        if (this.nullableDummyContainerName != null) {
            Element dummyElement = XmlUtil.createElement((Document)document, (String)this.nullableDummyContainerName, (Optional)Optional.of((Object)namespace));
            rootElement.appendChild(dummyElement);
            parentElement = dummyElement;
        } else {
            parentElement = rootElement;
        }
        for (Map.Entry<String, Object> mappingEntry : mappedConfig.entrySet()) {
            try {
                strats.get(mappingEntry.getKey()).writeElement(parentElement, namespace, mappingEntry.getValue());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to write value " + mappingEntry.getValue() + " for attribute " + mappingEntry.getValue(), e);
            }
        }
        return rootElement;
    }

    private void resolveConfiguration(InstanceConfigElementResolved mappedConfig, ServiceRegistryWrapper depTracker, EnumResolver enumResolver) {
        Map<String, AttributeResolvingStrategy<?, OpenType<?>>> resolvingStrategies = new ObjectResolver(depTracker).prepareResolving(this.yangToAttrConfig, enumResolver);
        for (Map.Entry<String, AttributeConfigElement> configDefEntry : mappedConfig.getConfiguration().entrySet()) {
            AttributeConfigElement value = configDefEntry.getValue();
            String attributeName = configDefEntry.getKey();
            try {
                AttributeResolvingStrategy<?, ? extends OpenType<?>> attributeResolvingStrategy = resolvingStrategies.get(attributeName);
                LOG.trace("Trying to set value {} of attribute {} with {}", new Object[]{value, attributeName, attributeResolvingStrategy});
                value.resolveValue(attributeResolvingStrategy, attributeName);
                value.setJmxName(this.yangToAttrConfig.get(attributeName).getUpperCaseCammelCase());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to resolve value " + value + " to attribute " + attributeName, e);
            }
        }
    }

    public InstanceConfigElementResolved fromXml(XmlElement moduleElement, ServiceRegistryWrapper services, String moduleNamespace, EditStrategyType defaultStrategy, Map<String, Map<Date, IdentityMapping>> identityMap, EnumResolver enumResolver) throws DocumentedException {
        HashMap retVal = Maps.newHashMap();
        Map<String, AttributeReadingStrategy> strats = new ObjectXmlReader().prepareReading(this.yangToAttrConfig, identityMap);
        ArrayList recognisedChildren = Lists.newArrayList();
        XmlElement typeElement = moduleElement.getOnlyChildElementWithSameNamespace("type");
        XmlElement nameElement = moduleElement.getOnlyChildElementWithSameNamespace("name");
        ArrayList typeAndNameElements = Lists.newArrayList((Object[])new XmlElement[]{typeElement, nameElement});
        if (this.nullableDummyContainerName != null) {
            int expectedChildNodes;
            int size = moduleElement.getChildElements().size();
            if (size > (expectedChildNodes = 1 + typeAndNameElements.size())) {
                throw new DocumentedException("Error reading module " + typeElement.getTextContent() + " : " + nameElement.getTextContent() + " - Expected " + expectedChildNodes + " child nodes, " + "one of them with name " + this.nullableDummyContainerName + ", got " + size + " elements.");
            }
            if (size == expectedChildNodes) {
                try {
                    moduleElement = moduleElement.getOnlyChildElement(this.nullableDummyContainerName, moduleNamespace);
                }
                catch (DocumentedException e) {
                    throw new DocumentedException("Error reading module " + typeElement.getTextContent() + " : " + nameElement.getTextContent() + " - Expected child node with name " + this.nullableDummyContainerName + "." + e.getMessage());
                }
            }
        }
        for (Map.Entry<String, AttributeReadingStrategy> readStratEntry : strats.entrySet()) {
            List<XmlElement> configNodes = this.getConfigNodes(moduleElement, moduleNamespace, readStratEntry.getKey(), recognisedChildren, typeAndNameElements);
            AttributeConfigElement readElement = readStratEntry.getValue().readElement(configNodes);
            retVal.put(readStratEntry.getKey(), readElement);
        }
        recognisedChildren.addAll(typeAndNameElements);
        try {
            moduleElement.checkUnrecognisedElements((List)recognisedChildren, new XmlElement[0]);
        }
        catch (DocumentedException e) {
            throw new DocumentedException("Error reading module " + typeElement.getTextContent() + " : " + nameElement.getTextContent() + " - " + e.getMessage(), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
        }
        String perInstanceEditStrategy = moduleElement.getAttribute("operation", "urn:ietf:params:xml:ns:netconf:base:1.0");
        InstanceConfigElementResolved instanceConfigElementResolved = perInstanceEditStrategy.equals("") ? new InstanceConfigElementResolved(retVal, defaultStrategy) : new InstanceConfigElementResolved(perInstanceEditStrategy, retVal, defaultStrategy);
        this.resolveConfiguration(instanceConfigElementResolved, services, enumResolver);
        return instanceConfigElementResolved;
    }

    private List<XmlElement> getConfigNodes(XmlElement moduleElement, String moduleNamespace, String name, List<XmlElement> recognisedChildren, List<XmlElement> typeAndName) throws DocumentedException {
        List foundConfigNodes = moduleElement.getChildElementsWithinNamespace(name, moduleNamespace);
        if (foundConfigNodes.isEmpty()) {
            LOG.debug("No config nodes {}:{} found in {}", new Object[]{moduleNamespace, name, moduleElement});
            LOG.debug("Trying lookup of config nodes without specified namespace");
            foundConfigNodes = moduleElement.getChildElementsWithinNamespace(name, "urn:opendaylight:params:xml:ns:yang:controller:config");
            foundConfigNodes.removeAll(typeAndName);
            LOG.debug("Found {} config nodes {} without specified namespace in {}", new Object[]{foundConfigNodes.size(), name, moduleElement});
        } else {
            List foundWithoutNamespaceNodes = moduleElement.getChildElementsWithinNamespace(name, "urn:opendaylight:params:xml:ns:yang:controller:config");
            foundWithoutNamespaceNodes.removeAll(typeAndName);
            if (!foundWithoutNamespaceNodes.isEmpty()) {
                throw new DocumentedException(String.format("Element %s present multiple times with different namespaces: %s, %s", name, foundConfigNodes, foundWithoutNamespaceNodes), DocumentedException.ErrorType.application, DocumentedException.ErrorTag.invalid_value, DocumentedException.ErrorSeverity.error);
            }
        }
        recognisedChildren.addAll(foundConfigNodes);
        return foundConfigNodes;
    }

    private static Map<String, AttributeIfc> reverseMap(Map<String, AttributeIfc> yangNameToAttr) {
        HashMap reversednameToAtr = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> entry : yangNameToAttr.entrySet()) {
            reversednameToAtr.put(entry.getValue().getUpperCaseCammelCase(), entry.getValue());
        }
        return reversednameToAtr;
    }
}

