/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleConfig;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.mapping.config.Services;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Config {
    private final Map<String, Map<String, ModuleConfig>> moduleConfigs;
    private final Map<String, Map<Date, IdentityMapping>> identityMap;
    private final EnumResolver enumResolver;

    public Config(Map<String, Map<String, ModuleConfig>> moduleConfigs, EnumResolver enumResolver) {
        this(moduleConfigs, Collections.emptyMap(), enumResolver);
    }

    public Config(Map<String, Map<String, ModuleConfig>> moduleConfigs, Map<String, Map<Date, IdentityMapping>> identityMap, EnumResolver enumResolver) {
        this.moduleConfigs = moduleConfigs;
        this.identityMap = identityMap;
        this.enumResolver = enumResolver;
    }

    public static Map<String, Map<String, Collection<ObjectName>>> getMappedInstances(Set<ObjectName> instancesToMap, Map<String, Map<String, ModuleConfig>> configs) {
        Multimap<String, ObjectName> moduleToInstances = Config.mapInstancesToModules(instancesToMap);
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (Map.Entry<String, Map<String, ModuleConfig>> namespaceToModuleToConfigEntry : configs.entrySet()) {
            HashMap innerRetVal = Maps.newHashMap();
            for (Map.Entry<String, ModuleConfig> mbeEntry : namespaceToModuleToConfigEntry.getValue().entrySet()) {
                String moduleName = mbeEntry.getKey();
                Collection instances = moduleToInstances.get((Object)moduleName);
                if (instances == null) continue;
                innerRetVal.put(moduleName, instances);
            }
            retVal.put(namespaceToModuleToConfigEntry.getKey(), innerRetVal);
        }
        return retVal;
    }

    private static Multimap<String, ObjectName> mapInstancesToModules(Set<ObjectName> instancesToMap) {
        HashMultimap retVal = HashMultimap.create();
        for (ObjectName objectName : instancesToMap) {
            String factoryName = ObjectNameUtil.getFactoryName((ObjectName)objectName);
            retVal.put((Object)factoryName, (Object)objectName);
        }
        return retVal;
    }

    public Element toXml(Set<ObjectName> instancesToMap, Optional<String> maybeNamespace, Document document, Element dataElement, ServiceRegistryWrapper serviceTracker) {
        Map<String, Map<String, Collection<ObjectName>>> moduleToInstances = Config.getMappedInstances(instancesToMap, this.moduleConfigs);
        if (maybeNamespace.isPresent()) {
            dataElement.setAttributeNS((String)maybeNamespace.get(), dataElement.getNodeName(), "xmlns");
        }
        Element modulesElement = XmlUtil.createElement((Document)document, (String)"modules", (Optional)Optional.of((Object)"urn:opendaylight:params:xml:ns:yang:controller:config"));
        dataElement.appendChild(modulesElement);
        for (Map.Entry<String, Map<String, Collection<ObjectName>>> moduleToInstanceEntry : moduleToInstances.entrySet()) {
            for (Map.Entry<String, Collection<ObjectName>> moduleMappingEntry : moduleToInstanceEntry.getValue().entrySet()) {
                ModuleConfig mapping = this.moduleConfigs.get(moduleToInstanceEntry.getKey()).get(moduleMappingEntry.getKey());
                if (moduleMappingEntry.getValue().isEmpty()) continue;
                for (ObjectName objectName : moduleMappingEntry.getValue()) {
                    modulesElement.appendChild(mapping.toXml(objectName, document, moduleToInstanceEntry.getKey(), this.enumResolver));
                }
            }
        }
        dataElement.appendChild(Services.toXml(serviceTracker, document));
        return dataElement;
    }

    public Map<String, Multimap<String, ModuleElementResolved>> fromXmlModulesResolved(XmlElement xml, EditStrategyType defaultEditStrategyType, ServiceRegistryWrapper serviceTracker) throws DocumentedException {
        Optional<XmlElement> modulesElement = Config.getModulesElement(xml);
        List<XmlElement> moduleElements = this.getModulesElementList(modulesElement);
        HashMap retVal = Maps.newHashMap();
        for (XmlElement moduleElement : moduleElements) {
            ResolvingStrategy<ModuleElementResolved> resolvingStrategy = new ResolvingStrategy<ModuleElementResolved>(){

                @Override
                public ModuleElementResolved resolveElement(ModuleConfig moduleMapping, XmlElement moduleElement, ServiceRegistryWrapper serviceTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy) throws DocumentedException {
                    return moduleMapping.fromXml(moduleElement, serviceTracker, instanceName, moduleNamespace, defaultStrategy, Config.this.identityMap, Config.this.enumResolver);
                }
            };
            this.resolveModule(retVal, serviceTracker, moduleElement, defaultEditStrategyType, resolvingStrategy);
        }
        return retVal;
    }

    public Map<String, Multimap<String, ModuleElementDefinition>> fromXmlModulesMap(XmlElement xml, EditStrategyType defaultEditStrategyType, ServiceRegistryWrapper serviceTracker) throws DocumentedException {
        Optional<XmlElement> modulesElement = Config.getModulesElement(xml);
        List<XmlElement> moduleElements = this.getModulesElementList(modulesElement);
        HashMap retVal = Maps.newHashMap();
        for (XmlElement moduleElement : moduleElements) {
            ResolvingStrategy<ModuleElementDefinition> resolvingStrategy = new ResolvingStrategy<ModuleElementDefinition>(){

                @Override
                public ModuleElementDefinition resolveElement(ModuleConfig moduleMapping, XmlElement moduleElement, ServiceRegistryWrapper serviceTracker, String instanceName, String moduleNamespace, EditStrategyType defaultStrategy) {
                    String perInstanceEditStrategy = moduleElement.getAttribute("operation", "urn:ietf:params:xml:ns:netconf:base:1.0");
                    return new ModuleElementDefinition(instanceName, perInstanceEditStrategy, defaultStrategy);
                }
            };
            this.resolveModule(retVal, serviceTracker, moduleElement, defaultEditStrategyType, resolvingStrategy);
        }
        return retVal;
    }

    private static Optional<XmlElement> getModulesElement(XmlElement xml) {
        return xml.getOnlyChildElementOptionally("modules", "urn:opendaylight:params:xml:ns:yang:controller:config");
    }

    private List<XmlElement> getModulesElementList(Optional<XmlElement> modulesElement) throws DocumentedException {
        List moduleElements;
        if (modulesElement.isPresent()) {
            moduleElements = ((XmlElement)modulesElement.get()).getChildElementsWithSameNamespace("module");
            ((XmlElement)modulesElement.get()).checkUnrecognisedElements(moduleElements, new XmlElement[0]);
        } else {
            moduleElements = Lists.newArrayList();
        }
        return moduleElements;
    }

    private <T> void resolveModule(Map<String, Multimap<String, T>> retVal, ServiceRegistryWrapper serviceTracker, XmlElement moduleElement, EditStrategyType defaultStrategy, ResolvingStrategy<T> resolvingStrategy) throws DocumentedException {
        XmlElement typeElement = null;
        typeElement = moduleElement.getOnlyChildElementWithSameNamespace("type");
        Map.Entry prefixToNamespace = typeElement.findNamespaceOfTextContent();
        String moduleNamespace = (String)prefixToNamespace.getValue();
        XmlElement nameElement = null;
        nameElement = moduleElement.getOnlyChildElementWithSameNamespace("name");
        String instanceName = nameElement.getTextContent();
        String factoryNameWithPrefix = typeElement.getTextContent();
        String prefixOrEmptyString = (String)prefixToNamespace.getKey();
        String factoryName = this.getFactoryName(factoryNameWithPrefix, prefixOrEmptyString);
        ModuleConfig moduleMapping = this.getModuleMapping(moduleNamespace, instanceName, factoryName);
        HashMultimap innerMap = retVal.get(moduleNamespace);
        if (innerMap == null) {
            innerMap = HashMultimap.create();
            retVal.put(moduleNamespace, (Multimap<String, T>)innerMap);
        }
        T resolvedElement = resolvingStrategy.resolveElement(moduleMapping, moduleElement, serviceTracker, instanceName, moduleNamespace, defaultStrategy);
        innerMap.put((Object)factoryName, resolvedElement);
    }

    public Services fromXmlServices(XmlElement xml) throws DocumentedException {
        Optional<XmlElement> servicesElement = Config.getServicesElement(xml);
        Services services = servicesElement.isPresent() ? Services.fromXml((XmlElement)servicesElement.get()) : new Services();
        return services;
    }

    private static Optional<XmlElement> getServicesElement(XmlElement xml) {
        return xml.getOnlyChildElementOptionally("services", "urn:opendaylight:params:xml:ns:yang:controller:config");
    }

    public static void checkUnrecognisedChildren(XmlElement parent) throws DocumentedException {
        Optional<XmlElement> servicesOpt = Config.getServicesElement(parent);
        Optional<XmlElement> modulesOpt = Config.getModulesElement(parent);
        ArrayList recognised = Lists.newArrayList();
        if (servicesOpt.isPresent()) {
            recognised.add(servicesOpt.get());
        }
        if (modulesOpt.isPresent()) {
            recognised.add(modulesOpt.get());
        }
        parent.checkUnrecognisedElements((List)recognised, new XmlElement[0]);
    }

    private String getFactoryName(String factoryNameWithPrefix, String prefixOrEmptyString) {
        Preconditions.checkState((boolean)factoryNameWithPrefix.startsWith(prefixOrEmptyString), (Object)String.format("Internal error: text content '%s' of type node does not start with prefix '%s'", factoryNameWithPrefix, prefixOrEmptyString));
        int factoryNameAfterPrefixIndex = prefixOrEmptyString.isEmpty() ? 0 : prefixOrEmptyString.length() + 1;
        return factoryNameWithPrefix.substring(factoryNameAfterPrefixIndex);
    }

    private ModuleConfig getModuleMapping(String moduleNamespace, String instanceName, String factoryName) {
        Map<String, ModuleConfig> mappingsFromNamespace = this.moduleConfigs.get(moduleNamespace);
        Preconditions.checkNotNull(mappingsFromNamespace, (String)"Namespace %s, defined in: module %s of type %s not found, available namespaces: %s", (Object[])new Object[]{moduleNamespace, instanceName, factoryName, this.moduleConfigs.keySet()});
        ModuleConfig moduleMapping = mappingsFromNamespace.get(factoryName);
        Preconditions.checkState((moduleMapping != null ? 1 : 0) != 0, (Object)("Cannot find mapping for module type " + factoryName));
        return moduleMapping;
    }

    private static interface ResolvingStrategy<T> {
        public T resolveElement(ModuleConfig var1, XmlElement var2, ServiceRegistryWrapper var3, String var4, String var5, EditStrategyType var6) throws DocumentedException;
    }
}

