/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.SimpleAttributeWritingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleIdentityRefAttributeWritingStrategy
extends SimpleAttributeWritingStrategy {
    private static final String PREFIX = "prefix";

    public SimpleIdentityRefAttributeWritingStrategy(Document document, String key) {
        super(document, key);
    }

    @Override
    protected Object preprocess(Object value) {
        Util.checkType(value, Map.class);
        Preconditions.checkArgument((((Map)value).size() == 1 ? 1 : 0) != 0, (String)"Unexpected number of values in %s, expected 1", (Object[])new Object[]{value});
        Object stringValue = ((Map)value).values().iterator().next();
        Util.checkType(stringValue, String.class);
        return stringValue;
    }

    @Override
    protected Element createElement(Document doc, String key, String value, Optional<String> namespace) {
        QName qName = QName.create((String)value);
        String identityValue = qName.getLocalName();
        String identityNamespace = qName.getNamespace().toString();
        return XmlUtil.createTextElementWithNamespacedContent((Document)doc, (String)key, (String)PREFIX, (String)identityNamespace, (String)identityValue, namespace);
    }
}

