/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml;

import com.google.common.base.Optional;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleAttributeWritingStrategy
implements AttributeWritingStrategy {
    private final Document document;
    private final String key;

    public SimpleAttributeWritingStrategy(Document document, String key) {
        this.document = document;
        this.key = key;
    }

    @Override
    public void writeElement(Element parentElement, String namespace, Object value) {
        value = this.preprocess(value);
        Util.checkType(value, String.class);
        Element innerNode = this.createElement(this.document, this.key, (String)value, (Optional<String>)Optional.of((Object)namespace));
        parentElement.appendChild(innerNode);
    }

    protected Element createElement(Document document, String key, String value, Optional<String> namespace) {
        Element typeElement = XmlUtil.createElement((Document)document, (String)key, namespace);
        typeElement.appendChild(document.createTextNode(value));
        return typeElement;
    }

    protected Object preprocess(Object value) {
        return value;
    }
}

