/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml;

import com.google.common.base.Optional;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ObjectNameAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectNameAttributeWritingStrategy
implements AttributeWritingStrategy {
    private final Document document;
    private final String key;

    public ObjectNameAttributeWritingStrategy(Document document, String key) {
        this.document = document;
        this.key = key;
    }

    @Override
    public void writeElement(Element parentElement, String namespace, Object value) {
        Util.checkType(value, ObjectNameAttributeMappingStrategy.MappedDependency.class);
        Element innerNode = XmlUtil.createElement((Document)this.document, (String)this.key, (Optional)Optional.of((Object)namespace));
        String moduleName = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getServiceName();
        String refName = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getRefName();
        String namespaceForType = ((ObjectNameAttributeMappingStrategy.MappedDependency)value).getNamespace();
        Element typeElement = XmlUtil.createTextElementWithNamespacedContent((Document)this.document, (String)"type", (String)"prefix", (String)namespaceForType, (String)moduleName);
        innerNode.appendChild(typeElement);
        Element nameElement = XmlUtil.createTextElement((Document)this.document, (String)"name", (String)refName, (Optional)Optional.absent());
        innerNode.appendChild(nameElement);
        parentElement.appendChild(innerNode);
    }
}

