/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml;

import com.google.common.base.Optional;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.AttributeWritingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompositeAttributeWritingStrategy
implements AttributeWritingStrategy {
    private final String key;
    private final Document document;
    private final Map<String, AttributeWritingStrategy> innerStrats;

    public CompositeAttributeWritingStrategy(Document document, String key, Map<String, AttributeWritingStrategy> innerStrats) {
        this.document = document;
        this.key = key;
        this.innerStrats = innerStrats;
    }

    @Override
    public void writeElement(Element parentElement, String namespace, Object value) {
        Util.checkType(value, Map.class);
        Element innerNode = XmlUtil.createElement((Document)this.document, (String)this.key, (Optional)Optional.of((Object)namespace));
        Map map = (Map)value;
        for (Map.Entry innerObjectEntry : map.entrySet()) {
            Util.checkType(innerObjectEntry.getKey(), String.class);
            String innerKey = (String)innerObjectEntry.getKey();
            Object innerValue = innerObjectEntry.getValue();
            this.innerStrats.get(innerKey).writeElement(innerNode, namespace, innerValue);
        }
        parentElement.appendChild(innerNode);
    }

    public String getKey() {
        return this.key;
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, AttributeWritingStrategy> getInnerStrats() {
        return this.innerStrats;
    }
}

