/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AbstractAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleAttributeResolvingStrategy
extends AbstractAttributeResolvingStrategy<Object, SimpleType<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAttributeResolvingStrategy.class);
    private static final String DEFAULT_RESOLVERS = "default";
    private static final Map<String, Resolver> resolverPlugins = Maps.newHashMap();

    SimpleAttributeResolvingStrategy(SimpleType<?> simpleType) {
        super(simpleType);
    }

    public String toString() {
        return "ResolvedSimpleAttribute [" + ((SimpleType)this.getOpenType()).getClassName() + "]";
    }

    @Override
    public Optional<Object> parseAttribute(String attrName, Object value) throws DocumentedException {
        Class<?> cls;
        if (value == null) {
            return Optional.absent();
        }
        try {
            cls = Class.forName(((SimpleType)this.getOpenType()).getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate class for " + ((SimpleType)this.getOpenType()).getClassName(), e);
        }
        Util.checkType(value, String.class);
        Resolver prefferedPlugin = resolverPlugins.get(cls.getCanonicalName());
        prefferedPlugin = prefferedPlugin == null ? resolverPlugins.get(DEFAULT_RESOLVERS) : prefferedPlugin;
        Object parsedValue = prefferedPlugin.resolveObject(cls, attrName, (String)value);
        LOG.debug("Attribute {} : {} parsed to type {} with value {}", new Object[]{attrName, value, this.getOpenType(), parsedValue});
        return Optional.of((Object)parsedValue);
    }

    static {
        resolverPlugins.put(DEFAULT_RESOLVERS, new DefaultResolver());
        resolverPlugins.put(String.class.getCanonicalName(), new StringResolver());
        resolverPlugins.put(Date.class.getCanonicalName(), new DateResolver());
        resolverPlugins.put(Character.class.getCanonicalName(), new CharResolver());
        resolverPlugins.put(BigInteger.class.getCanonicalName(), new BigIntegerResolver());
        resolverPlugins.put(BigDecimal.class.getCanonicalName(), new BigDecimalResolver());
    }

    static class DateResolver
    extends DefaultResolver {
        DateResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) throws DocumentedException {
            try {
                return Util.readDate(value);
            }
            catch (ParseException e) {
                LOG.trace("Unable parse value {} due to ", (Object)value, (Object)e);
                throw new DocumentedException("Unable to parse value " + value + " as date.", DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
            }
        }
    }

    static class CharResolver
    extends DefaultResolver {
        CharResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) {
            return Character.valueOf(value.charAt(0));
        }
    }

    static class BigDecimalResolver
    extends DefaultResolver {
        BigDecimalResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) {
            return new BigDecimal(value);
        }
    }

    static class BigIntegerResolver
    extends DefaultResolver {
        BigIntegerResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) {
            return new BigInteger(value);
        }
    }

    static class StringResolver
    extends DefaultResolver {
        StringResolver() {
        }

        @Override
        protected Object parseObject(Class<?> type, String value) {
            return value;
        }
    }

    static class DefaultResolver
    implements Resolver {
        DefaultResolver() {
        }

        @Override
        public Object resolveObject(Class<?> type, String attrName, String value) throws DocumentedException {
            try {
                return this.parseObject(type, value);
            }
            catch (Exception e) {
                throw new DocumentedException("Unable to resolve attribute " + attrName + " from " + value, DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
            }
        }

        protected Object parseObject(Class<?> type, String value) throws DocumentedException {
            Method method = null;
            try {
                method = type.getMethod("valueOf", String.class);
                return method.invoke(null, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.trace("Error parsing object ", (Throwable)e);
                throw new DocumentedException("Error parsing object.", DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
            }
        }
    }

    static interface Resolver {
        public Object resolveObject(Class<?> var1, String var2, String var3) throws DocumentedException;
    }
}

