/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.AttributeIfcSwitchStatement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.ArrayAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.CompositeAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.EnumAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.ObjectNameAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.SimpleAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.UnionCompositeAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;

public class ObjectResolver
extends AttributeIfcSwitchStatement<AttributeResolvingStrategy<?, ? extends OpenType<?>>> {
    private final ServiceRegistryWrapper serviceTracker;
    private EnumResolver enumResolver;

    public ObjectResolver(ServiceRegistryWrapper serviceTracker) {
        this.serviceTracker = serviceTracker;
    }

    public Map<String, AttributeResolvingStrategy<?, ? extends OpenType<?>>> prepareResolving(Map<String, AttributeIfc> configDefinition, EnumResolver enumResolver) {
        this.enumResolver = enumResolver;
        HashMap strategies = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> attrEntry : configDefinition.entrySet()) {
            strategies.put(attrEntry.getKey(), this.prepareStrategy(attrEntry.getValue()));
        }
        return strategies;
    }

    private AttributeResolvingStrategy<?, ? extends OpenType<?>> prepareStrategy(AttributeIfc attributeIfc) {
        return (AttributeResolvingStrategy)this.switchAttribute(attributeIfc);
    }

    private Map<String, String> createYangToJmxMapping(TOAttribute attributeIfc) {
        HashMap retVal = Maps.newHashMap();
        for (Map.Entry entry : attributeIfc.getYangPropertiesToTypesMap().entrySet()) {
            retVal.put(entry.getKey(), ((AttributeIfc)entry.getValue()).getLowerCaseCammelCase());
        }
        return retVal;
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseJavaEnumAttribute(OpenType<?> openType) {
        return new EnumAttributeResolvingStrategy((CompositeType)openType, this.enumResolver);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseJavaSimpleAttribute(SimpleType<?> openType) {
        return new SimpleAttributeResolvingStrategy(openType);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseJavaArrayAttribute(ArrayType<?> openType) {
        SimpleType innerType = (SimpleType)openType.getElementOpenType();
        SimpleAttributeResolvingStrategy strat = new SimpleAttributeResolvingStrategy(innerType);
        return new ArrayAttributeResolvingStrategy(strat, openType);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseJavaCompositeAttribute(CompositeType openType) {
        HashMap innerMap = Maps.newHashMap();
        HashMap yangToJmxMapping = Maps.newHashMap();
        this.fillMappingForComposite(openType, innerMap, yangToJmxMapping);
        return new CompositeAttributeResolvingStrategy(innerMap, openType, yangToJmxMapping);
    }

    private void fillMappingForComposite(CompositeType openType, Map<String, AttributeResolvingStrategy<?, ? extends OpenType<?>>> innerMap, Map<String, String> yangToJmxMapping) {
        for (String innerAttributeKey : openType.keySet()) {
            innerMap.put(innerAttributeKey, (AttributeResolvingStrategy<?, OpenType<?>>)this.caseJavaAttribute(openType.getType(innerAttributeKey)));
            yangToJmxMapping.put(innerAttributeKey, innerAttributeKey);
        }
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseJavaUnionAttribute(OpenType<?> openType) {
        Preconditions.checkState((boolean)(openType instanceof CompositeType), (Object)"Unexpected open type, expected %s but was %s");
        CompositeType compositeType = (CompositeType)openType;
        HashMap innerMap = Maps.newHashMap();
        HashMap yangToJmxMapping = Maps.newHashMap();
        this.fillMappingForComposite(compositeType, innerMap, yangToJmxMapping);
        return new UnionCompositeAttributeResolvingStrategy(innerMap, compositeType, yangToJmxMapping);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseDependencyAttribute(SimpleType<?> openType) {
        return new ObjectNameAttributeResolvingStrategy(this.serviceTracker);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseTOAttribute(CompositeType openType) {
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof TOAttribute));
        TOAttribute toAttribute = (TOAttribute)this.getLastAttribute();
        HashMap innerMap = Maps.newHashMap();
        for (String innerName : openType.keySet()) {
            AttributeIfc innerAttributeIfc = (AttributeIfc)toAttribute.getJmxPropertiesToTypesMap().get(innerName);
            innerMap.put(innerAttributeIfc.getAttributeYangName(), this.prepareStrategy(innerAttributeIfc));
        }
        return new CompositeAttributeResolvingStrategy(innerMap, openType, this.createYangToJmxMapping(toAttribute));
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseListAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof ListAttribute));
        AttributeIfc innerAttribute = ((ListAttribute)this.getLastAttribute()).getInnerAttribute();
        return new ArrayAttributeResolvingStrategy(this.prepareStrategy(innerAttribute), openType);
    }

    @Override
    protected AttributeResolvingStrategy<?, ? extends OpenType<?>> caseListDependeciesAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof ListDependenciesAttribute));
        return new ArrayAttributeResolvingStrategy((AttributeResolvingStrategy<?, ? extends OpenType<?>>)this.caseDependencyAttribute((SimpleType)SimpleType.OBJECTNAME), openType);
    }
}

