/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.management.openmbean.CompositeType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AbstractAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EnumAttributeResolvingStrategy
extends AbstractAttributeResolvingStrategy<Object, CompositeType> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumAttributeResolvingStrategy.class);
    private final EnumResolver enumResolver;

    EnumAttributeResolvingStrategy(CompositeType simpleType, EnumResolver enumResolver) {
        super(simpleType);
        this.enumResolver = enumResolver;
    }

    public String toString() {
        return "ResolvedEnumAttribute [" + ((CompositeType)this.getOpenType()).getClassName() + "]";
    }

    @Override
    public Optional<Object> parseAttribute(String attrName, Object value) throws DocumentedException {
        if (value == null) {
            return Optional.absent();
        }
        Util.checkType(value, Map.class);
        Map valueMap = (Map)value;
        Preconditions.checkArgument((valueMap.size() == 1 ? 1 : 0) != 0, (Object)("Unexpected value size " + value + " should be just 1 foe enum"));
        Object innerValue = valueMap.values().iterator().next();
        Util.checkType(innerValue, String.class);
        String className = ((CompositeType)this.getOpenType()).getTypeName();
        String parsedValue = this.enumResolver.fromYang(className, (String)innerValue);
        LOG.debug("Attribute {} : {} parsed to enum type {} with value {}", new Object[]{attrName, innerValue, this.getOpenType(), parsedValue});
        return Optional.of((Object)parsedValue);
    }
}

