/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AbstractAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.EnumAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompositeAttributeResolvingStrategy
extends AbstractAttributeResolvingStrategy<CompositeDataSupport, CompositeType> {
    private final Map<String, AttributeResolvingStrategy<?, ? extends OpenType<?>>> innerTypes;
    private final Map<String, String> yangToJavaAttrMapping;
    private static final Logger LOG = LoggerFactory.getLogger(CompositeAttributeResolvingStrategy.class);

    CompositeAttributeResolvingStrategy(Map<String, AttributeResolvingStrategy<?, ? extends OpenType<?>>> innerTypes, CompositeType openType, Map<String, String> yangToJavaAttrMapping) {
        super(openType);
        this.innerTypes = innerTypes;
        this.yangToJavaAttrMapping = yangToJavaAttrMapping;
    }

    public String toString() {
        return "ResolvedCompositeAttribute [" + this.innerTypes + "]";
    }

    @Override
    public Optional<CompositeDataSupport> parseAttribute(String attrName, Object value) throws DocumentedException {
        CompositeDataSupport parsedValue;
        if (value == null) {
            return Optional.absent();
        }
        Util.checkType(value, Map.class);
        Map<?, ?> valueMap = (Map<?, ?>)value;
        valueMap = this.preprocessValueMap(valueMap);
        HashMap items = Maps.newHashMap();
        HashMap openTypes = Maps.newHashMap();
        String[] names = new String[((CompositeType)this.getOpenType()).keySet().size()];
        String[] descriptions = new String[((CompositeType)this.getOpenType()).keySet().size()];
        OpenType[] itemTypes = new OpenType[names.length];
        int i = 0;
        for (String innerAttrName : this.innerTypes.keySet()) {
            Preconditions.checkState((boolean)(innerAttrName instanceof String), (Object)"Attribute name must be string");
            String innerAttrNameStr = innerAttrName;
            AttributeResolvingStrategy<?, OpenType<?>> attributeResolvingStrategy = this.innerTypes.get(innerAttrName);
            Object valueToParse = valueMap.get(innerAttrName);
            Optional<?> parsedInnerValue = attributeResolvingStrategy.parseAttribute(innerAttrNameStr, valueToParse);
            if (attributeResolvingStrategy instanceof EnumAttributeResolvingStrategy) {
                openTypes.put(innerAttrNameStr, SimpleType.STRING);
            } else {
                openTypes.put(innerAttrNameStr, attributeResolvingStrategy.getOpenType());
            }
            items.put(this.yangToJavaAttrMapping.get(innerAttrNameStr), parsedInnerValue.isPresent() ? parsedInnerValue.get() : null);
            names[i] = this.yangToJavaAttrMapping.get(innerAttrNameStr);
            descriptions[i] = ((CompositeType)this.getOpenType()).getDescription(names[i]);
            itemTypes[i] = (OpenType)openTypes.get(innerAttrNameStr);
            ++i;
        }
        try {
            LOG.trace("Attribute {} with open type {}. Reconstructing open type.", (Object)attrName, this.getOpenType());
            this.setOpenType(new CompositeType(((CompositeType)this.getOpenType()).getTypeName(), ((CompositeType)this.getOpenType()).getDescription(), names, descriptions, itemTypes));
            LOG.debug("Attribute {}. Open type reconstructed to {}", new Object[]{attrName, this.getOpenType(), this.getOpenType()});
            parsedValue = new CompositeDataSupport((CompositeType)this.getOpenType(), items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("An error occurred during restoration of composite type " + this + " for attribute " + attrName + " from value " + value, e);
        }
        LOG.debug("Attribute {} : {} parsed to type {} as {}", new Object[]{attrName, value, this.getOpenType(), parsedValue});
        return Optional.of((Object)parsedValue);
    }

    protected Map<?, ?> preprocessValueMap(Map<?, ?> valueMap) {
        return valueMap;
    }
}

