/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving;

import com.google.common.base.Optional;
import java.lang.reflect.Array;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AbstractAttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArrayAttributeResolvingStrategy
extends AbstractAttributeResolvingStrategy<Object, ArrayType<?>> {
    private final AttributeResolvingStrategy<?, ? extends OpenType<?>> innerTypeResolvingStrategy;
    private static final Logger LOG = LoggerFactory.getLogger(ArrayAttributeResolvingStrategy.class);

    public ArrayAttributeResolvingStrategy(AttributeResolvingStrategy<?, ? extends OpenType<?>> innerTypeResolved, ArrayType<?> openType) {
        super(openType);
        this.innerTypeResolvingStrategy = innerTypeResolved;
    }

    @Override
    public Optional<Object> parseAttribute(String attrName, Object value) throws DocumentedException {
        if (value == null) {
            return Optional.absent();
        }
        Util.checkType(value, List.class);
        List valueList = (List)value;
        Class innerTypeClass = null;
        if (this.innerTypeResolvingStrategy.getOpenType() instanceof CompositeType) {
            innerTypeClass = CompositeDataSupport.class;
        } else {
            try {
                innerTypeClass = Class.forName(((ArrayType)this.getOpenType()).getElementOpenType().getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to locate class for " + ((ArrayType)this.getOpenType()).getElementOpenType().getClassName(), e);
            }
        }
        Object parsedArray = null;
        if (((ArrayType)this.getOpenType()).isPrimitiveArray()) {
            Class<?> primitiveType = ArrayAttributeResolvingStrategy.getPrimitiveType(innerTypeClass);
            parsedArray = Array.newInstance(primitiveType, valueList.size());
        } else {
            parsedArray = Array.newInstance(innerTypeClass, valueList.size());
        }
        int i = 0;
        for (Object innerValue : valueList) {
            Optional<?> parsedElement = this.innerTypeResolvingStrategy.parseAttribute(attrName + "_" + i, innerValue);
            if (!parsedElement.isPresent()) continue;
            Array.set(parsedArray, i, parsedElement.get());
            ++i;
        }
        if (this.innerTypeResolvingStrategy.getOpenType() instanceof CompositeType) {
            try {
                ArrayType openType = new ArrayType(((ArrayType)this.getOpenType()).getDimension(), this.innerTypeResolvingStrategy.getOpenType());
                this.setOpenType(openType);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException("An error occurred during restoration of array type " + this + " for attribute " + attrName + " from value " + value, e);
            }
        }
        LOG.debug("Attribute {} : {} parsed to type {} as {}", new Object[]{attrName, value, this.getOpenType(), ArrayAttributeResolvingStrategy.toStringArray(parsedArray)});
        return Optional.of((Object)parsedArray);
    }

    private static String toStringArray(Object array) {
        StringBuilder build = new StringBuilder(array.toString());
        build.append(" [");
        for (int i = 0; i < Array.getLength(array); ++i) {
            build.append(Array.get(array, i).toString());
            build.append(",");
        }
        build.append("]]");
        return build.toString();
    }

    private static Class<?> getPrimitiveType(Class<?> innerTypeClass) {
        try {
            return (Class)innerTypeClass.getField("TYPE").get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to determine primitive type to " + innerTypeClass);
        }
    }

    public String toString() {
        return "ResolvedArrayTypeAttributeType [innerTypeResolved=" + this.innerTypeResolvingStrategy + "]";
    }
}

