/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.management.ObjectName;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AbstractAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;
import org.opendaylight.yangtools.yang.common.QName;

public class ObjectNameAttributeMappingStrategy
extends AbstractAttributeMappingStrategy<MappedDependency, SimpleType<?>> {
    private final String namespace;

    public ObjectNameAttributeMappingStrategy(SimpleType<?> openType, String namespace) {
        super(openType);
        this.namespace = namespace;
    }

    @Override
    public Optional<MappedDependency> mapAttribute(Object value) {
        if (value == null) {
            return Optional.absent();
        }
        String expectedClass = ((SimpleType)this.getOpenType()).getClassName();
        String realClass = value.getClass().getName();
        Preconditions.checkArgument((boolean)realClass.equals(expectedClass), (Object)("Type mismatch, expected " + expectedClass + " but was " + realClass));
        Util.checkType(value, ObjectName.class);
        ObjectName on = (ObjectName)value;
        String refName = ObjectNameUtil.getReferenceName((ObjectName)on);
        return Optional.of((Object)new MappedDependency(this.namespace, QName.create((String)ObjectNameUtil.getServiceQName((ObjectName)on)).getLocalName(), refName));
    }

    public static class MappedDependency {
        private final String namespace;
        private final String serviceName;
        private final String refName;

        public MappedDependency(String namespace, String serviceName, String refName) {
            this.serviceName = serviceName;
            this.refName = refName;
            this.namespace = namespace;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getRefName() {
            return this.refName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("MappedDependency{");
            sb.append("namespace='").append(this.namespace).append('\'');
            sb.append(", serviceName='").append(this.serviceName).append('\'');
            sb.append(", refName='").append(this.refName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

