/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.AttributeIfcSwitchStatement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ArrayAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.CompositeAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.EnumAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ObjectNameAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.SimpleAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.UnionCompositeAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.DependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;

public class ObjectMapper
extends AttributeIfcSwitchStatement<AttributeMappingStrategy<?, ? extends OpenType<?>>> {
    private EnumResolver enumResolver;
    private String namespaceOfDepAttr;

    public Map<String, AttributeMappingStrategy<?, ? extends OpenType<?>>> prepareMapping(Map<String, AttributeIfc> configDefinition, EnumResolver enumResolver) {
        this.enumResolver = (EnumResolver)Preconditions.checkNotNull((Object)enumResolver);
        HashMap strategies = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> attrEntry : configDefinition.entrySet()) {
            strategies.put(attrEntry.getKey(), this.prepareStrategy(attrEntry.getValue()));
        }
        return strategies;
    }

    public AttributeMappingStrategy<?, ? extends OpenType<?>> prepareStrategy(AttributeIfc attributeIfc) {
        if (attributeIfc instanceof DependencyAttribute) {
            this.namespaceOfDepAttr = ((DependencyAttribute)attributeIfc).getDependency().getSie().getQName().getNamespace().toString();
        } else if (attributeIfc instanceof ListDependenciesAttribute) {
            this.namespaceOfDepAttr = ((ListDependenciesAttribute)attributeIfc).getDependency().getSie().getQName().getNamespace().toString();
        }
        return (AttributeMappingStrategy)this.switchAttribute(attributeIfc);
    }

    private Map<String, String> createJmxToYangMapping(TOAttribute attributeIfc) {
        HashMap retVal = Maps.newHashMap();
        for (Map.Entry entry : attributeIfc.getJmxPropertiesToTypesMap().entrySet()) {
            retVal.put(entry.getKey(), ((AttributeIfc)entry.getValue()).getAttributeYangName());
        }
        return retVal;
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseJavaSimpleAttribute(SimpleType<?> openType) {
        return new SimpleAttributeMappingStrategy(openType);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseJavaEnumAttribute(OpenType<?> openType) {
        return new EnumAttributeMappingStrategy((CompositeType)openType, this.enumResolver);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseJavaArrayAttribute(ArrayType<?> openType) {
        SimpleAttributeMappingStrategy innerStrategy = new SimpleAttributeMappingStrategy((SimpleType)openType.getElementOpenType());
        return new ArrayAttributeMappingStrategy(openType, innerStrategy);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseJavaCompositeAttribute(CompositeType openType) {
        HashMap innerStrategies = Maps.newHashMap();
        HashMap attributeMapping = Maps.newHashMap();
        for (String innerAttributeKey : openType.keySet()) {
            innerStrategies.put(innerAttributeKey, this.caseJavaAttribute(openType.getType(innerAttributeKey)));
            attributeMapping.put(innerAttributeKey, innerAttributeKey);
        }
        return new CompositeAttributeMappingStrategy(openType, innerStrategies, attributeMapping);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseJavaUnionAttribute(OpenType<?> openType) {
        HashMap innerStrategies = Maps.newHashMap();
        HashMap attributeMapping = Maps.newHashMap();
        CompositeType compositeType = (CompositeType)openType;
        for (String innerAttributeKey : compositeType.keySet()) {
            innerStrategies.put(innerAttributeKey, this.caseJavaAttribute(compositeType.getType(innerAttributeKey)));
            attributeMapping.put(innerAttributeKey, innerAttributeKey);
        }
        return new UnionCompositeAttributeMappingStrategy(compositeType, innerStrategies, attributeMapping);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseDependencyAttribute(SimpleType<?> openType) {
        return new ObjectNameAttributeMappingStrategy(openType, this.namespaceOfDepAttr);
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseTOAttribute(CompositeType openType) {
        HashMap innerStrategies = Maps.newHashMap();
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof TOAttribute));
        TOAttribute lastTO = (TOAttribute)this.getLastAttribute();
        for (Map.Entry innerAttrEntry : ((TOAttribute)this.getLastAttribute()).getJmxPropertiesToTypesMap().entrySet()) {
            innerStrategies.put(innerAttrEntry.getKey(), this.prepareStrategy((AttributeIfc)innerAttrEntry.getValue()));
        }
        return new CompositeAttributeMappingStrategy(openType, innerStrategies, this.createJmxToYangMapping(lastTO));
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseListAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof ListAttribute));
        return new ArrayAttributeMappingStrategy(openType, this.prepareStrategy(((ListAttribute)this.getLastAttribute()).getInnerAttribute()));
    }

    @Override
    protected AttributeMappingStrategy<?, ? extends OpenType<?>> caseListDependeciesAttribute(ArrayType<?> openType) {
        Preconditions.checkState((boolean)(this.getLastAttribute() instanceof ListDependenciesAttribute));
        return new ArrayAttributeMappingStrategy(openType, (AttributeMappingStrategy<?, ? extends OpenType<?>>)this.caseDependencyAttribute((SimpleType)SimpleType.OBJECTNAME));
    }
}

