/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AbstractAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.util.Util;

public class CompositeAttributeMappingStrategy
extends AbstractAttributeMappingStrategy<Map<String, Object>, CompositeType> {
    private final Map<String, AttributeMappingStrategy<?, ? extends OpenType<?>>> innerStrategies;
    private final Map<String, String> jmxToJavaNameMapping;

    public CompositeAttributeMappingStrategy(CompositeType compositeType, Map<String, AttributeMappingStrategy<?, ? extends OpenType<?>>> innerStrategies, Map<String, String> jmxToJavaNameMapping) {
        super(compositeType);
        this.innerStrategies = innerStrategies;
        this.jmxToJavaNameMapping = jmxToJavaNameMapping;
    }

    @Override
    public Optional<Map<String, Object>> mapAttribute(Object value) {
        if (value == null) {
            return Optional.absent();
        }
        Util.checkType(value, CompositeDataSupport.class);
        CompositeDataSupport compositeData = (CompositeDataSupport)value;
        CompositeType currentType = compositeData.getCompositeType();
        CompositeType expectedType = (CompositeType)this.getOpenType();
        Set<String> expectedCompositeTypeKeys = expectedType.keySet();
        Set<String> currentCompositeTypeKeys = currentType.keySet();
        Preconditions.checkArgument((boolean)expectedCompositeTypeKeys.equals(currentCompositeTypeKeys), (Object)("Composite type mismatch, expected composite type with attributes " + expectedCompositeTypeKeys + " but was " + currentCompositeTypeKeys));
        HashMap retVal = Maps.newHashMap();
        for (String jmxName : this.jmxToJavaNameMapping.keySet()) {
            Optional<?> mapped = this.mapInnerAttribute(compositeData, jmxName, expectedType.getDescription(jmxName));
            if (!mapped.isPresent()) continue;
            retVal.put(this.jmxToJavaNameMapping.get(jmxName), mapped.get());
        }
        return Optional.of((Object)retVal);
    }

    protected Optional<?> mapInnerAttribute(CompositeDataSupport compositeData, String jmxName, String description) {
        Object innerValue = compositeData.get(jmxName);
        AttributeMappingStrategy<?, OpenType<?>> attributeMappingStrategy = this.innerStrategies.get(jmxName);
        return attributeMappingStrategy.mapAttribute(innerValue);
    }
}

