/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AbstractAttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AttributeMappingStrategy;

public class ArrayAttributeMappingStrategy
extends AbstractAttributeMappingStrategy<List<Object>, ArrayType<?>> {
    private final AttributeMappingStrategy<?, ? extends OpenType<?>> innerElementStrategy;

    public ArrayAttributeMappingStrategy(ArrayType<?> arrayType, AttributeMappingStrategy<?, ? extends OpenType<?>> innerElementStrategy) {
        super(arrayType);
        this.innerElementStrategy = innerElementStrategy;
    }

    @Override
    public Optional<List<Object>> mapAttribute(Object value) {
        if (value == null) {
            return Optional.absent();
        }
        Preconditions.checkArgument((boolean)value.getClass().isArray(), (Object)"Value has to be instanceof Array ");
        ArrayList retVal = Lists.newArrayList();
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object innerValue = Array.get(value, i);
            Optional<?> mapAttribute = this.innerElementStrategy.mapAttribute(innerValue);
            if (!mapAttribute.isPresent()) continue;
            retVal.add(mapAttribute.get());
        }
        return Optional.of((Object)retVal);
    }
}

