/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleAttributeReadingStrategy;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.yangtools.yang.common.QName;

public class SimpleIdentityRefAttributeReadingStrategy
extends SimpleAttributeReadingStrategy {
    private final String key;
    private final Map<String, Map<Date, IdentityMapping>> identityMap;

    public SimpleIdentityRefAttributeReadingStrategy(String nullableDefault, String key, Map<String, Map<Date, IdentityMapping>> identityMap) {
        super(nullableDefault);
        this.key = key;
        this.identityMap = identityMap;
    }

    @Override
    protected String readElementContent(XmlElement xmlElement) throws DocumentedException {
        String namespace;
        String localName;
        Map.Entry namespaceOfTextContent = xmlElement.findNamespaceOfTextContent();
        String content = xmlElement.getTextContent();
        if (((String)namespaceOfTextContent.getKey()).isEmpty()) {
            localName = content;
            namespace = xmlElement.getNamespace();
        } else {
            String prefix = (String)namespaceOfTextContent.getKey() + ":";
            Preconditions.checkArgument((boolean)content.startsWith(prefix), (String)"Identity ref should be prefixed with \"%s\"", (Object[])new Object[]{prefix});
            localName = content.substring(prefix.length());
            namespace = (String)namespaceOfTextContent.getValue();
        }
        Date revision = null;
        Map<Date, IdentityMapping> revisions = this.identityMap.get(namespace);
        if (revisions.keySet().size() > 1) {
            for (Map.Entry<Date, IdentityMapping> revisionToIdentityEntry : revisions.entrySet()) {
                if (!revisionToIdentityEntry.getValue().containsIdName(localName)) continue;
                Preconditions.checkState((revision == null ? 1 : 0) != 0, (String)"Duplicate identity %s, in namespace %s, with revisions: %s, %s detected. Cannot map attribute", (Object[])new Object[]{localName, namespace, revision, revisionToIdentityEntry.getKey()});
                revision = revisionToIdentityEntry.getKey();
            }
        } else {
            revision = revisions.keySet().iterator().next();
        }
        return QName.create((URI)URI.create(namespace), (Date)revision, (String)localName).toString();
    }

    @Override
    protected Object postprocessParsedValue(String textContent) {
        HashMap map = Maps.newHashMap();
        map.put(this.key, textContent);
        return map;
    }

    @Override
    protected Object postprocessNullableDefault(String nullableDefault) {
        return nullableDefault == null ? null : this.postprocessParsedValue(nullableDefault);
    }
}

