/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.AttributeIfcSwitchStatement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.ArrayAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.CompositeAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.ObjectNameAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleBinaryAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleCompositeAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleIdentityRefAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.SimpleUnionAttributeReadingStrategy;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;

public class ObjectXmlReader
extends AttributeIfcSwitchStatement<AttributeReadingStrategy> {
    private String key;
    private Map<String, Map<Date, IdentityMapping>> identityMap;

    public Map<String, AttributeReadingStrategy> prepareReading(Map<String, AttributeIfc> yangToAttrConfig, Map<String, Map<Date, IdentityMapping>> identityMap) {
        HashMap strategies = Maps.newHashMap();
        this.identityMap = identityMap;
        for (Map.Entry<String, AttributeIfc> attributeEntry : yangToAttrConfig.entrySet()) {
            AttributeReadingStrategy strat = this.prepareReadingStrategy(attributeEntry.getKey(), attributeEntry.getValue());
            strategies.put(attributeEntry.getKey(), strat);
        }
        return strategies;
    }

    private AttributeReadingStrategy prepareReadingStrategy(String key, AttributeIfc attributeIfc) {
        this.key = key;
        return (AttributeReadingStrategy)this.switchAttribute(attributeIfc);
    }

    @Override
    protected AttributeReadingStrategy caseJavaBinaryAttribute(OpenType<?> openType) {
        return new SimpleBinaryAttributeReadingStrategy(this.getLastAttribute().getNullableDefault());
    }

    @Override
    protected AttributeReadingStrategy caseJavaUnionAttribute(OpenType<?> openType) {
        String mappingKey = "valueOfArtificialUnionProperty";
        return new SimpleUnionAttributeReadingStrategy(this.getLastAttribute().getNullableDefault(), mappingKey);
    }

    @Override
    public AttributeReadingStrategy caseJavaSimpleAttribute(SimpleType<?> openType) {
        return new SimpleAttributeReadingStrategy(this.getLastAttribute().getNullableDefault());
    }

    @Override
    public AttributeReadingStrategy caseJavaArrayAttribute(ArrayType<?> openType) {
        SimpleAttributeReadingStrategy innerStrategy = new SimpleAttributeReadingStrategy(this.getLastAttribute().getNullableDefault());
        return new ArrayAttributeReadingStrategy(this.getLastAttribute().getNullableDefault(), innerStrategy);
    }

    @Override
    public AttributeReadingStrategy caseJavaCompositeAttribute(CompositeType openType) {
        Preconditions.checkState((openType.keySet().size() == 1 ? 1 : 0) != 0, (String)"Unexpected number of elements for open type %s, should be 1", (Object[])new Object[]{openType});
        String mappingKey = openType.keySet().iterator().next();
        return new SimpleCompositeAttributeReadingStrategy(this.getLastAttribute().getNullableDefault(), mappingKey);
    }

    @Override
    protected AttributeReadingStrategy caseJavaIdentityRefAttribute(OpenType<?> openType) {
        Preconditions.checkState((boolean)(openType instanceof CompositeType));
        Set<String> keys = ((CompositeType)openType).keySet();
        Preconditions.checkState((keys.size() == 1 ? 1 : 0) != 0, (String)"Unexpected number of elements for open type %s, should be 1", (Object[])new Object[]{openType});
        String mappingKey = keys.iterator().next();
        return new SimpleIdentityRefAttributeReadingStrategy(this.getLastAttribute().getNullableDefault(), mappingKey, this.identityMap);
    }

    @Override
    protected AttributeReadingStrategy caseDependencyAttribute(SimpleType<?> openType) {
        return new ObjectNameAttributeReadingStrategy(this.getLastAttribute().getNullableDefault());
    }

    @Override
    protected AttributeReadingStrategy caseTOAttribute(CompositeType openType) {
        AttributeIfc lastAttribute = this.getLastAttribute();
        Preconditions.checkState((boolean)(lastAttribute instanceof TOAttribute));
        Map inner = ((TOAttribute)lastAttribute).getYangPropertiesToTypesMap();
        HashMap innerStrategies = Maps.newHashMap();
        for (Map.Entry innerAttrEntry : inner.entrySet()) {
            AttributeReadingStrategy innerStrat = this.prepareReadingStrategy((String)innerAttrEntry.getKey(), (AttributeIfc)innerAttrEntry.getValue());
            innerStrategies.put(innerAttrEntry.getKey(), innerStrat);
        }
        return new CompositeAttributeReadingStrategy(lastAttribute.getNullableDefault(), innerStrategies);
    }

    @Override
    protected AttributeReadingStrategy caseListAttribute(ArrayType<?> openType) {
        AttributeIfc lastAttribute = this.getLastAttribute();
        Preconditions.checkState((boolean)(lastAttribute instanceof ListAttribute));
        AttributeReadingStrategy innerStrategy = this.prepareReadingStrategy(this.key, ((ListAttribute)lastAttribute).getInnerAttribute());
        return new ArrayAttributeReadingStrategy(lastAttribute.getNullableDefault(), innerStrategy);
    }

    @Override
    protected AttributeReadingStrategy caseListDependeciesAttribute(ArrayType<?> openType) {
        AttributeIfc lastAttribute = this.getLastAttribute();
        Preconditions.checkState((boolean)(lastAttribute instanceof ListDependenciesAttribute));
        Object innerStrategy = this.caseDependencyAttribute((SimpleType)SimpleType.OBJECTNAME);
        return new ArrayAttributeReadingStrategy(lastAttribute.getNullableDefault(), (AttributeReadingStrategy)innerStrategy);
    }
}

