/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AbstractAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ObjectNameAttributeMappingStrategy;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;

public class ObjectNameAttributeReadingStrategy
extends AbstractAttributeReadingStrategy {
    private static final Object PREFIX_SEPARATOR = ":";

    public ObjectNameAttributeReadingStrategy(String nullableDefault) {
        super(nullableDefault);
    }

    @Override
    AttributeConfigElement readElementHook(List<XmlElement> configNodes) throws DocumentedException {
        XmlElement firstChild = configNodes.get(0);
        Preconditions.checkState((configNodes.size() == 1 ? 1 : 0) != 0, (Object)("This element should be present only once " + firstChild + " but was " + configNodes.size()));
        Preconditions.checkNotNull((Object)firstChild, (String)"Element %s should be present", (Object[])new Object[]{firstChild});
        return AttributeConfigElement.create(this.getNullableDefault(), this.resolve(firstChild));
    }

    private ObjectNameAttributeMappingStrategy.MappedDependency resolve(XmlElement firstChild) throws DocumentedException {
        XmlElement typeElement = firstChild.getOnlyChildElementWithSameNamespace("type");
        Map.Entry prefixNamespace = typeElement.findNamespaceOfTextContent();
        String serviceName = ObjectNameAttributeReadingStrategy.checkPrefixAndExtractServiceName(typeElement, prefixNamespace);
        XmlElement nameElement = firstChild.getOnlyChildElementWithSameNamespace("name");
        String dependencyName = nameElement.getTextContent();
        return new ObjectNameAttributeMappingStrategy.MappedDependency((String)prefixNamespace.getValue(), serviceName, dependencyName);
    }

    public static String checkPrefixAndExtractServiceName(XmlElement typeElement, Map.Entry<String, String> prefixNamespace) throws DocumentedException {
        String serviceName = typeElement.getTextContent();
        Preconditions.checkNotNull((Object)prefixNamespace.getKey(), (String)"Service %s value cannot be linked to namespace", (Object[])new Object[]{"type"});
        if (prefixNamespace.getKey().isEmpty()) {
            return serviceName;
        }
        String prefix = prefixNamespace.getKey() + PREFIX_SEPARATOR;
        Preconditions.checkState((boolean)serviceName.startsWith(prefix), (String)"Service %s not correctly prefixed, expected %s, but was %s", (Object[])new Object[]{"type", prefix, serviceName});
        serviceName = serviceName.substring(prefix.length());
        return serviceName;
    }
}

