/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AbstractAttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeReadingStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;

public class CompositeAttributeReadingStrategy
extends AbstractAttributeReadingStrategy {
    private final Map<String, AttributeReadingStrategy> innerStrategies;

    public CompositeAttributeReadingStrategy(String nullableDefault, Map<String, AttributeReadingStrategy> innerStrategies) {
        super(nullableDefault);
        this.innerStrategies = innerStrategies;
    }

    @Override
    AttributeConfigElement readElementHook(List<XmlElement> configNodes) throws DocumentedException {
        Preconditions.checkState((configNodes.size() == 1 ? 1 : 0) != 0, (String)"This element should be present only once %s", (Object[])new Object[]{configNodes});
        XmlElement complexElement = configNodes.get(0);
        HashMap innerMap = Maps.newHashMap();
        ArrayList recognisedChildren = Lists.newArrayList();
        for (Map.Entry<String, AttributeReadingStrategy> innerAttrEntry : this.innerStrategies.entrySet()) {
            List childItem = complexElement.getChildElementsWithSameNamespace(innerAttrEntry.getKey());
            recognisedChildren.addAll(childItem);
            AttributeConfigElement resolvedInner = innerAttrEntry.getValue().readElement(childItem);
            Object value = resolvedInner.getValue();
            if (value == null) {
                value = resolvedInner.getDefaultValue();
            }
            innerMap.put(innerAttrEntry.getKey(), value);
        }
        complexElement.checkUnrecognisedElements((List)recognisedChildren, new XmlElement[0]);
        String perInstanceEditStrategy = complexElement.getAttribute("operation", "urn:ietf:params:xml:ns:netconf:base:1.0");
        return Strings.isNullOrEmpty((String)perInstanceEditStrategy) ? AttributeConfigElement.create(this.getNullableDefault(), innerMap) : AttributeConfigElement.create(this.getNullableDefault(), innerMap, EditStrategyType.valueOf(perInstanceEditStrategy));
    }
}

