/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml;

import com.google.common.base.Optional;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.resolving.AttributeResolvingStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.xml.DocumentedException;

public class AttributeConfigElement {
    private final Object defaultValue;
    private final Object value;
    private final Optional<EditStrategyType> editStrategy;
    private Optional<?> resolvedValue;
    private Object resolvedDefaultValue;
    private String jmxName;

    public AttributeConfigElement(Object defaultValue, Object value, EditStrategyType editStrategyType) {
        this.defaultValue = defaultValue;
        this.value = value;
        this.editStrategy = Optional.fromNullable((Object)((Object)editStrategyType));
    }

    public void setJmxName(String jmxName) {
        this.jmxName = jmxName;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public void resolveValue(AttributeResolvingStrategy<?, ? extends OpenType<?>> attributeResolvingStrategy, String attrName) throws DocumentedException {
        this.resolvedValue = attributeResolvingStrategy.parseAttribute(attrName, this.value);
        Optional<?> resolvedDefault = attributeResolvingStrategy.parseAttribute(attrName, this.defaultValue);
        this.resolvedDefaultValue = resolvedDefault.isPresent() ? resolvedDefault.get() : null;
    }

    public Optional<EditStrategyType> getEditStrategy() {
        return this.editStrategy;
    }

    public static AttributeConfigElement create(Object nullableDefault, Object value) {
        return new AttributeConfigElement(nullableDefault, value, null);
    }

    public static AttributeConfigElement createNullValue(Object nullableDefault) {
        return new AttributeConfigElement(nullableDefault, null, null);
    }

    public static AttributeConfigElement create(String nullableDefault, Object value, EditStrategyType editStrategyType) {
        return new AttributeConfigElement(nullableDefault, value, editStrategyType);
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Optional<?> getResolvedValue() {
        return this.resolvedValue;
    }

    public Object getResolvedDefaultValue() {
        return this.resolvedDefaultValue;
    }

    public String toString() {
        return "AttributeConfigElement [defaultValue=" + this.defaultValue + ", value=" + this.value + "]";
    }
}

