/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping.attributes;

import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.DependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;

public abstract class AttributeIfcSwitchStatement<T> {
    private AttributeIfc lastAttribute;

    public T switchAttribute(AttributeIfc attributeIfc) {
        this.lastAttribute = attributeIfc;
        OpenType openType = attributeIfc.getOpenType();
        if (attributeIfc instanceof JavaAttribute) {
            try {
                if (((JavaAttribute)attributeIfc).getTypeDefinition() instanceof BinaryTypeDefinition) {
                    return this.caseJavaBinaryAttribute(openType);
                }
                if (((JavaAttribute)attributeIfc).isUnion()) {
                    return this.caseJavaUnionAttribute(openType);
                }
                if (((JavaAttribute)attributeIfc).isIdentityRef()) {
                    return this.caseJavaIdentityRefAttribute(openType);
                }
                if (((JavaAttribute)attributeIfc).isEnum()) {
                    return this.caseJavaEnumAttribute(openType);
                }
                return this.caseJavaAttribute(openType);
            }
            catch (UnknownOpenTypeException e) {
                throw this.getIllegalArgumentException(attributeIfc);
            }
        }
        if (attributeIfc instanceof DependencyAttribute) {
            return this.caseDependencyAttribute(((DependencyAttribute)attributeIfc).getOpenType());
        }
        if (attributeIfc instanceof ListAttribute) {
            return this.caseListAttribute((ArrayType)openType);
        }
        if (attributeIfc instanceof ListDependenciesAttribute) {
            return this.caseListDependeciesAttribute((ArrayType)openType);
        }
        if (attributeIfc instanceof TOAttribute) {
            return this.caseTOAttribute(((TOAttribute)attributeIfc).getOpenType());
        }
        throw this.getIllegalArgumentException(attributeIfc);
    }

    public AttributeIfc getLastAttribute() {
        return this.lastAttribute;
    }

    protected T caseJavaIdentityRefAttribute(OpenType<?> openType) {
        return this.caseJavaAttribute(openType);
    }

    protected T caseJavaUnionAttribute(OpenType<?> openType) {
        return this.caseJavaAttribute(openType);
    }

    protected T caseJavaEnumAttribute(OpenType<?> openType) {
        return this.caseJavaAttribute(openType);
    }

    protected T caseJavaBinaryAttribute(OpenType<?> openType) {
        return this.caseJavaAttribute(openType);
    }

    private IllegalArgumentException getIllegalArgumentException(AttributeIfc attributeIfc) {
        return new IllegalArgumentException("Unknown attribute type " + attributeIfc.getClass() + ", " + attributeIfc + " with open type:" + attributeIfc.getOpenType());
    }

    public final T caseJavaAttribute(OpenType<?> openType) {
        if (openType instanceof SimpleType) {
            return this.caseJavaSimpleAttribute((SimpleType)openType);
        }
        if (openType instanceof ArrayType) {
            return this.caseJavaArrayAttribute((ArrayType)openType);
        }
        if (openType instanceof CompositeType) {
            return this.caseJavaCompositeAttribute((CompositeType)openType);
        }
        throw new UnknownOpenTypeException("Unknown attribute open type " + openType);
    }

    protected abstract T caseJavaSimpleAttribute(SimpleType<?> var1);

    protected abstract T caseJavaArrayAttribute(ArrayType<?> var1);

    protected abstract T caseJavaCompositeAttribute(CompositeType var1);

    protected abstract T caseDependencyAttribute(SimpleType<?> var1);

    protected abstract T caseTOAttribute(CompositeType var1);

    protected abstract T caseListAttribute(ArrayType<?> var1);

    protected abstract T caseListDependeciesAttribute(ArrayType<?> var1);

    private static class UnknownOpenTypeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnknownOpenTypeException(String message) {
            super(message);
        }
    }
}

