/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.mapping;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;

public class IdentityMapping {
    private final Map<String, IdentitySchemaNode> identityNameToSchemaNode = Maps.newHashMap();

    public void addIdSchemaNode(IdentitySchemaNode node) {
        String name = node.getQName().getLocalName();
        Preconditions.checkState((!this.identityNameToSchemaNode.containsKey(name) ? 1 : 0) != 0);
        this.identityNameToSchemaNode.put(name, node);
    }

    public boolean containsIdName(String idName) {
        return this.identityNameToSchemaNode.containsKey(idName);
    }
}

