/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.AttributeMappingStrategy;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.mapping.ObjectMapper;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.toxml.ObjectXmlWriter;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreService;
import org.opendaylight.controller.config.facade.xml.rpc.InstanceRuntimeRpc;
import org.opendaylight.controller.config.facade.xml.rpc.ModuleRpcs;
import org.opendaylight.controller.config.facade.xml.rpc.Rpcs;
import org.opendaylight.controller.config.facade.xml.rpc.RuntimeRpcElementResolved;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.VoidAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RpcFacade {
    public static final String CONTEXT_INSTANCE = "context-instance";
    private YangStoreService yangStoreService;
    private ConfigRegistryClient configRegistryClient;

    public RpcFacade(YangStoreService yangStoreService, ConfigRegistryClient configRegistryClient) {
        this.yangStoreService = yangStoreService;
        this.configRegistryClient = configRegistryClient;
    }

    public Rpcs mapRpcs() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, Map<String, ModuleMXBeanEntry>> namespaceToModuleEntry : this.yangStoreService.getModuleMXBeanEntryMap().entrySet()) {
            Map namespaceToModules = (Map)map.get(namespaceToModuleEntry.getKey());
            if (namespaceToModules == null) {
                namespaceToModules = Maps.newHashMap();
                map.put(namespaceToModuleEntry.getKey(), namespaceToModules);
            }
            for (Map.Entry<String, ModuleMXBeanEntry> moduleEntry : namespaceToModuleEntry.getValue().entrySet()) {
                ModuleRpcs rpcMapping = (ModuleRpcs)namespaceToModules.get(moduleEntry.getKey());
                if (rpcMapping == null) {
                    rpcMapping = new ModuleRpcs(this.yangStoreService.getEnumResolver());
                    namespaceToModules.put(moduleEntry.getKey(), rpcMapping);
                }
                ModuleMXBeanEntry entry = moduleEntry.getValue();
                for (RuntimeBeanEntry runtimeEntry : entry.getRuntimeBeans()) {
                    rpcMapping.addNameMapping(runtimeEntry);
                    for (RuntimeBeanEntry.Rpc rpc : runtimeEntry.getRpcs()) {
                        rpcMapping.addRpc(runtimeEntry, rpc);
                    }
                }
            }
        }
        return new Rpcs(map);
    }

    public OperationExecution fromXml(XmlElement xml) throws DocumentedException {
        String namespace = xml.getNamespace();
        XmlElement contextInstanceElement = xml.getOnlyChildElement(CONTEXT_INSTANCE);
        String operationName = xml.getName();
        RuntimeRpcElementResolved id = RuntimeRpcElementResolved.fromXpath(contextInstanceElement.getTextContent(), operationName, namespace);
        Rpcs rpcs = this.mapRpcs();
        ModuleRpcs rpcMapping = rpcs.getRpcMapping(id);
        InstanceRuntimeRpc instanceRuntimeRpc = rpcMapping.getRpc(id.getRuntimeBeanName(), operationName);
        ObjectName on = id.getObjectName(rpcMapping);
        Map<String, AttributeConfigElement> attributes = instanceRuntimeRpc.fromXml(xml);
        attributes = this.sortAttributes(attributes, xml);
        return new OperationExecution(on, instanceRuntimeRpc.getName(), attributes, instanceRuntimeRpc.getReturnType(), namespace);
    }

    private Map<String, AttributeConfigElement> sortAttributes(Map<String, AttributeConfigElement> attributes, XmlElement xml) {
        LinkedHashMap sorted = Maps.newLinkedHashMap();
        for (XmlElement xmlElement : xml.getChildElements()) {
            String name = xmlElement.getName();
            if (CONTEXT_INSTANCE.equals(name)) continue;
            AttributeConfigElement value = attributes.get(name);
            if (value == null) {
                throw new IllegalArgumentException("Cannot find yang mapping for node " + xmlElement);
            }
            sorted.put(name, value);
        }
        return sorted;
    }

    public Object executeOperation(OperationExecution execution) {
        Object[] params = new Object[execution.attributes.size()];
        String[] signature = new String[execution.attributes.size()];
        int i = 0;
        for (AttributeConfigElement attribute : execution.attributes.values()) {
            Optional<?> resolvedValueOpt = attribute.getResolvedValue();
            params[i] = resolvedValueOpt.isPresent() ? resolvedValueOpt.get() : attribute.getResolvedDefaultValue();
            signature[i] = resolvedValueOpt.isPresent() ? resolvedValueOpt.get().getClass().getName() : attribute.getResolvedDefaultValue().getClass().getName();
            ++i;
        }
        return this.configRegistryClient.invokeMethod(execution.on, execution.operationName, params, signature);
    }

    public Element toXml(Document doc, Object result, OperationExecution execution) throws DocumentedException {
        AttributeMappingStrategy<?, OpenType<?>> mappingStrategy = new ObjectMapper().prepareStrategy(execution.getReturnType());
        Optional<?> mappedAttributeOpt = mappingStrategy.mapAttribute(result);
        Preconditions.checkState((boolean)mappedAttributeOpt.isPresent(), (String)"Unable to map return value %s as %s", (Object[])new Object[]{result, execution.getReturnType().getOpenType()});
        Element tempParent = XmlUtil.createElement((Document)doc, (String)"output", (Optional)Optional.of((Object)"urn:ietf:params:xml:ns:netconf:base:1.0"));
        new ObjectXmlWriter().prepareWritingStrategy(execution.getReturnType().getAttributeYangName(), execution.getReturnType(), doc).writeElement(tempParent, execution.getNamespace(), mappedAttributeOpt.get());
        XmlElement xmlElement = XmlElement.fromDomElement((Element)tempParent);
        return xmlElement.getChildElements().size() > 1 ? tempParent : xmlElement.getOnlyChildElement().getDomElement();
    }

    public class OperationExecution {
        private final ObjectName on;
        private final String operationName;
        private final Map<String, AttributeConfigElement> attributes;
        private final AttributeIfc returnType;
        private final String namespace;

        public OperationExecution(ObjectName on, String name, Map<String, AttributeConfigElement> attributes, AttributeIfc returnType, String namespace) {
            this.on = on;
            this.operationName = name;
            this.attributes = attributes;
            this.returnType = returnType;
            this.namespace = namespace;
        }

        public boolean isVoid() {
            return this.returnType == VoidAttribute.getInstance();
        }

        public ObjectName getOn() {
            return this.on;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public Map<String, AttributeConfigElement> getAttributes() {
            return this.attributes;
        }

        public AttributeIfc getReturnType() {
            return this.returnType;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

