/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.facade.xml.ConfigSubsystemFacade;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreService;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.util.capability.Capability;
import org.opendaylight.controller.config.util.capability.YangModuleCapability;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;

public class ConfigSubsystemFacadeFactory {
    private ConfigRegistryClient cfgRegClient;
    private ConfigRegistryJMXClient cfgRegClientNoNotifications;
    private YangStoreService yangStoreService;

    public ConfigSubsystemFacadeFactory(ConfigRegistryClient cfgRegClient, ConfigRegistryJMXClient jmxClientNoNotifications, YangStoreService yangStoreService) {
        this.cfgRegClient = cfgRegClient;
        this.cfgRegClientNoNotifications = jmxClientNoNotifications;
        this.yangStoreService = yangStoreService;
    }

    public ConfigSubsystemFacade createFacade(String id) {
        return new ConfigSubsystemFacade(this.cfgRegClient, (ConfigRegistryClient)this.cfgRegClientNoNotifications, this.yangStoreService, id);
    }

    public YangStoreService getYangStoreService() {
        return this.yangStoreService;
    }

    public Set<Capability> getCurrentCapabilities() {
        Set<Module> modules = this.yangStoreService.getModules();
        HashSet capabilities = Sets.newHashSet();
        for (Module module : modules) {
            capabilities.add(new YangModuleCapability(module, this.yangStoreService.getModuleSource((ModuleIdentifier)module)));
        }
        return capabilities;
    }
}

