/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.facade.xml.ConfigExecution;
import org.opendaylight.controller.config.facade.xml.Datastore;
import org.opendaylight.controller.config.facade.xml.RpcFacade;
import org.opendaylight.controller.config.facade.xml.TestOption;
import org.opendaylight.controller.config.facade.xml.mapping.IdentityMapping;
import org.opendaylight.controller.config.facade.xml.mapping.config.Config;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfig;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfigElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleConfig;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.mapping.config.Services;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreContext;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreService;
import org.opendaylight.controller.config.facade.xml.runtime.InstanceRuntime;
import org.opendaylight.controller.config.facade.xml.runtime.ModuleRuntime;
import org.opendaylight.controller.config.facade.xml.runtime.Runtime;
import org.opendaylight.controller.config.facade.xml.strategy.EditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.facade.xml.transactions.TransactionProvider;
import org.opendaylight.controller.config.util.BeanReader;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigSubsystemFacade
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigSubsystemFacade.class);
    private final YangStoreService yangStoreService;
    private final TransactionProvider transactionProvider;
    private final ConfigRegistryClient configRegistryClient;
    private final ConfigRegistryClient configRegistryClientNoNotifications;
    private final RpcFacade rpcFacade;

    public ConfigSubsystemFacade(ConfigRegistryClient configRegistryClient, ConfigRegistryClient configRegistryClientNoNotifications, YangStoreService yangStoreService, String id) {
        this.configRegistryClient = configRegistryClient;
        this.configRegistryClientNoNotifications = configRegistryClientNoNotifications;
        this.yangStoreService = yangStoreService;
        this.transactionProvider = new TransactionProvider(configRegistryClient, id);
        this.rpcFacade = new RpcFacade(yangStoreService, configRegistryClient);
    }

    public ConfigSubsystemFacade(ConfigRegistryClient configRegistryClient, ConfigRegistryClient configRegistryClientNoNotifications, YangStoreService yangStoreService, TransactionProvider txProvider) {
        this.configRegistryClient = configRegistryClient;
        this.configRegistryClientNoNotifications = configRegistryClientNoNotifications;
        this.yangStoreService = yangStoreService;
        this.transactionProvider = txProvider;
        this.rpcFacade = new RpcFacade(yangStoreService, configRegistryClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getConfiguration(Document document, Datastore source, Optional<String> maybeNamespace) {
        ConfigTransactionClient registryClient;
        if (source == Datastore.running) {
            ObjectName readTx = this.transactionProvider.getOrCreateReadTransaction();
            registryClient = this.configRegistryClient.getConfigTransactionClient(readTx);
        } else {
            registryClient = this.configRegistryClient.getConfigTransactionClient(this.transactionProvider.getOrCreateTransaction());
        }
        try {
            Element dataElement = XmlUtil.createElement((Document)document, (String)"data", (Optional)Optional.absent());
            Set<ObjectName> instances = Datastore.getInstanceQueryStrategy(source, this.transactionProvider).queryInstances(this.configRegistryClient);
            Config configMapping = new Config(this.transformMbeToModuleConfigs(this.yangStoreService.getModuleMXBeanEntryMap()), this.yangStoreService.getEnumResolver());
            ServiceRegistryWrapper serviceTracker = new ServiceRegistryWrapper((ServiceReferenceReadableRegistry)registryClient);
            Element element = dataElement = configMapping.toXml(instances, maybeNamespace, document, dataElement, serviceTracker);
            return element;
        }
        finally {
            if (source == Datastore.running) {
                this.transactionProvider.closeReadTransaction();
            }
        }
    }

    public void executeConfigExecution(ConfigExecution configExecution) throws DocumentedException, ValidationException {
        if (configExecution.shouldTest()) {
            this.executeTests(configExecution);
        }
        if (configExecution.shouldSet()) {
            this.executeSet(configExecution);
        }
    }

    public CommitStatus commitTransaction() throws DocumentedException, ValidationException, ConflictingVersionException {
        CommitStatus status = this.transactionProvider.commitTransaction();
        LOG.trace("Transaction committed successfully: {}", (Object)status);
        return status;
    }

    public CommitStatus commitSilentTransaction() throws DocumentedException, ValidationException, ConflictingVersionException {
        CommitStatus status = this.transactionProvider.commitTransaction(this.configRegistryClientNoNotifications);
        LOG.trace("Transaction committed successfully: {}", (Object)status);
        return status;
    }

    private void executeSet(ConfigExecution configExecution) throws DocumentedException {
        this.set(configExecution);
        LOG.debug("Set phase for {} operation successful, element: ", (Object)configExecution.getDefaultStrategy(), (Object)configExecution.getConfigElement());
    }

    private void executeTests(ConfigExecution configExecution) throws DocumentedException, ValidationException {
        this.test(configExecution, configExecution.getDefaultStrategy());
        LOG.debug("Test phase for {} operation successful, element: ", (Object)configExecution.getDefaultStrategy(), (Object)configExecution.getConfigElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(ConfigExecution execution, EditStrategyType editStrategyType) throws ValidationException, DocumentedException {
        ObjectName taON = this.transactionProvider.getTestTransaction();
        try {
            if (editStrategyType == EditStrategyType.replace) {
                this.transactionProvider.wipeTestTransaction(taON);
            }
            ConfigTransactionClient ta = this.configRegistryClient.getConfigTransactionClient(taON);
            this.handleMisssingInstancesOnTransaction(ta, execution);
            this.setServicesOnTransaction(ta, execution);
            this.setOnTransaction(ta, execution);
            this.transactionProvider.validateTestTransaction(taON);
        }
        finally {
            this.transactionProvider.abortTestTransaction(taON);
        }
    }

    private void set(ConfigExecution ConfigExecution2) throws DocumentedException {
        ObjectName taON = this.transactionProvider.getOrCreateTransaction();
        if (ConfigExecution2.getDefaultStrategy() == EditStrategyType.replace) {
            this.transactionProvider.wipeTransaction();
        }
        ConfigTransactionClient ta = this.configRegistryClient.getConfigTransactionClient(taON);
        this.handleMisssingInstancesOnTransaction(ta, ConfigExecution2);
        this.setServicesOnTransaction(ta, ConfigExecution2);
        this.setOnTransaction(ta, ConfigExecution2);
    }

    private void setServicesOnTransaction(ConfigTransactionClient ta, ConfigExecution execution) throws DocumentedException {
        Services services = execution.getServices();
        Map<String, Map<String, Map<String, Services.ServiceInstance>>> namespaceToServiceNameToRefNameToInstance = services.getNamespaceToServiceNameToRefNameToInstance();
        for (Map.Entry<String, Map<String, Map<String, Services.ServiceInstance>>> namespaceToServiceToRefEntry : namespaceToServiceNameToRefNameToInstance.entrySet()) {
            for (Map.Entry<String, Map<String, Services.ServiceInstance>> serviceToRefEntry : namespaceToServiceToRefEntry.getValue().entrySet()) {
                String qnameOfService = this.getQname(ta, namespaceToServiceToRefEntry.getKey(), serviceToRefEntry.getKey());
                Map<String, Services.ServiceInstance> refNameToInstance = serviceToRefEntry.getValue();
                for (Map.Entry<String, Services.ServiceInstance> refNameToServiceEntry : refNameToInstance.entrySet()) {
                    ObjectName on = refNameToServiceEntry.getValue().getObjectName(ta.getTransactionName());
                    try {
                        if (Services.ServiceInstance.EMPTY_SERVICE_INSTANCE == refNameToServiceEntry.getValue()) {
                            ta.removeServiceReference(qnameOfService, refNameToServiceEntry.getKey());
                            LOG.debug("Removing service {} with name {}", (Object)qnameOfService, (Object)refNameToServiceEntry.getKey());
                            continue;
                        }
                        ObjectName saved = ta.saveServiceReference(qnameOfService, refNameToServiceEntry.getKey(), on);
                        LOG.debug("Saving service {} with on {} under name {} with service on {}", new Object[]{qnameOfService, on, refNameToServiceEntry.getKey(), saved});
                    }
                    catch (InstanceNotFoundException e) {
                        throw new DocumentedException(String.format("Unable to edit ref name " + refNameToServiceEntry.getKey() + " for instance " + on, e), DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
                    }
                }
            }
        }
    }

    private String getQname(ConfigTransactionClient ta, String namespace, String serviceName) {
        return ta.getServiceInterfaceName(namespace, serviceName);
    }

    private void setOnTransaction(ConfigTransactionClient ta, ConfigExecution execution) throws DocumentedException {
        for (Multimap<String, ModuleElementResolved> modulesToResolved : execution.getResolvedXmlElements((ServiceReferenceReadableRegistry)ta).values()) {
            for (Map.Entry moduleToResolved : modulesToResolved.entries()) {
                String moduleName = (String)moduleToResolved.getKey();
                ModuleElementResolved moduleElementResolved = (ModuleElementResolved)moduleToResolved.getValue();
                String instanceName = moduleElementResolved.getInstanceName();
                InstanceConfigElementResolved ice = moduleElementResolved.getInstanceConfigElementResolved();
                EditConfigStrategy strategy = ice.getEditStrategy();
                strategy.executeConfiguration(moduleName, instanceName, ice.getConfiguration(), ta, execution.getServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta));
            }
        }
    }

    private void handleMisssingInstancesOnTransaction(ConfigTransactionClient ta, ConfigExecution execution) throws DocumentedException {
        for (Multimap<String, ModuleElementDefinition> modulesToResolved : execution.getModulesDefinition((ServiceReferenceReadableRegistry)ta).values()) {
            for (Map.Entry moduleToResolved : modulesToResolved.entries()) {
                String moduleName = (String)moduleToResolved.getKey();
                ModuleElementDefinition moduleElementDefinition = (ModuleElementDefinition)moduleToResolved.getValue();
                EditConfigStrategy strategy = moduleElementDefinition.getEditStrategy();
                strategy.executeConfiguration(moduleName, moduleElementDefinition.getInstanceName(), null, ta, execution.getServiceRegistryWrapper((ServiceReferenceReadableRegistry)ta));
            }
        }
    }

    public Config getConfigMapping() {
        YangStoreContext snapshot = this.yangStoreService.getCurrentSnapshot();
        Map<String, Map<String, ModuleConfig>> factories = this.transformMbeToModuleConfigs(snapshot.getModuleMXBeanEntryMap());
        Map<String, Map<Date, IdentityMapping>> identitiesMap = ConfigSubsystemFacade.transformIdentities(snapshot.getModules());
        return new Config(factories, identitiesMap, snapshot.getEnumResolver());
    }

    private static Map<String, Map<Date, IdentityMapping>> transformIdentities(Set<Module> modules) {
        HashMap mappedIds = Maps.newHashMap();
        for (Module module : modules) {
            Date revision;
            IdentityMapping identityMapping;
            String namespace = module.getNamespace().toString();
            Map revisionsByNamespace = (Map)mappedIds.get(namespace);
            if (revisionsByNamespace == null) {
                revisionsByNamespace = Maps.newHashMap();
                mappedIds.put(namespace, revisionsByNamespace);
            }
            if ((identityMapping = (IdentityMapping)revisionsByNamespace.get(revision = module.getRevision())) == null) {
                identityMapping = new IdentityMapping();
                revisionsByNamespace.put(revision, identityMapping);
            }
            for (IdentitySchemaNode identitySchemaNode : module.getIdentities()) {
                identityMapping.addIdSchemaNode(identitySchemaNode);
            }
        }
        return mappedIds;
    }

    public Map<String, Map<String, ModuleConfig>> transformMbeToModuleConfigs(Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        return this.transformMbeToModuleConfigs((BeanReader)this.configRegistryClient, mBeanEntries);
    }

    public Map<String, Map<String, ModuleConfig>> transformMbeToModuleConfigs(BeanReader reader, Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        HashMap namespaceToModuleNameToModuleConfig = Maps.newHashMap();
        for (Map.Entry<String, Map<String, ModuleMXBeanEntry>> namespaceToModuleToMbe : mBeanEntries.entrySet()) {
            for (Map.Entry<String, ModuleMXBeanEntry> moduleNameToMbe : namespaceToModuleToMbe.getValue().entrySet()) {
                String moduleName = moduleNameToMbe.getKey();
                ModuleMXBeanEntry moduleMXBeanEntry = moduleNameToMbe.getValue();
                ModuleConfig moduleConfig = new ModuleConfig(moduleName, new InstanceConfig(reader, moduleMXBeanEntry.getAttributes(), moduleMXBeanEntry.getNullableDummyContainerName()));
                Map moduleNameToModuleConfig = (Map)namespaceToModuleNameToModuleConfig.get(namespaceToModuleToMbe.getKey());
                if (moduleNameToModuleConfig == null) {
                    moduleNameToModuleConfig = Maps.newHashMap();
                    namespaceToModuleNameToModuleConfig.put(namespaceToModuleToMbe.getKey(), moduleNameToModuleConfig);
                }
                moduleNameToModuleConfig.put(moduleName, moduleConfig);
            }
        }
        return namespaceToModuleNameToModuleConfig;
    }

    public ConfigExecution getConfigExecution(Config configMapping, Element xmlToBePersisted) throws DocumentedException {
        return new ConfigExecution(configMapping, XmlElement.fromDomElement((Element)xmlToBePersisted), TestOption.testThenSet, EditStrategyType.getDefaultStrategy());
    }

    private Map<String, Map<String, ModuleRuntime>> createModuleRuntimes(ConfigRegistryClient configRegistryClient, Map<String, Map<String, ModuleMXBeanEntry>> mBeanEntries) {
        HashMap retVal = Maps.newHashMap();
        for (Map.Entry<String, Map<String, ModuleMXBeanEntry>> namespaceToModuleEntry : mBeanEntries.entrySet()) {
            HashMap innerMap = Maps.newHashMap();
            Map<String, ModuleMXBeanEntry> entriesFromNamespace = namespaceToModuleEntry.getValue();
            for (Map.Entry<String, ModuleMXBeanEntry> moduleToMXEntry : entriesFromNamespace.entrySet()) {
                ModuleMXBeanEntry mbe = moduleToMXEntry.getValue();
                HashMap cache = Maps.newHashMap();
                RuntimeBeanEntry root = null;
                for (RuntimeBeanEntry rbe : mbe.getRuntimeBeans()) {
                    cache.put(rbe, new InstanceConfig((BeanReader)configRegistryClient, rbe.getYangPropertiesToTypesMap(), mbe.getNullableDummyContainerName()));
                    if (!rbe.isRoot()) continue;
                    root = rbe;
                }
                if (root == null) continue;
                InstanceRuntime rootInstanceRuntime = this.createInstanceRuntime(root, cache);
                ModuleRuntime moduleRuntime = new ModuleRuntime(rootInstanceRuntime);
                innerMap.put(moduleToMXEntry.getKey(), moduleRuntime);
            }
            retVal.put(namespaceToModuleEntry.getKey(), innerMap);
        }
        return retVal;
    }

    private InstanceRuntime createInstanceRuntime(RuntimeBeanEntry root, Map<RuntimeBeanEntry, InstanceConfig> cache) {
        HashMap children = Maps.newHashMap();
        for (RuntimeBeanEntry child : root.getChildren()) {
            children.put(child.getJavaNamePrefix(), this.createInstanceRuntime(child, cache));
        }
        return new InstanceRuntime(cache.get(root), children, this.createJmxToYangMap(root.getChildren()));
    }

    private Map<String, String> createJmxToYangMap(List<RuntimeBeanEntry> children) {
        HashMap jmxToYangNamesForChildRbe = Maps.newHashMap();
        for (RuntimeBeanEntry rbe : children) {
            jmxToYangNamesForChildRbe.put(rbe.getJavaNamePrefix(), rbe.getYangName());
        }
        return jmxToYangNamesForChildRbe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Document document) throws DocumentedException {
        ObjectName testTransaction = this.transactionProvider.getOrCreateReadTransaction();
        ConfigTransactionClient txClient = this.configRegistryClient.getConfigTransactionClient(testTransaction);
        try {
            Set runtimeBeans = this.configRegistryClient.lookupRuntimeBeans();
            Set<ObjectName> configBeans = Datastore.getInstanceQueryStrategy(Datastore.running, this.transactionProvider).queryInstances(this.configRegistryClient);
            Map<String, Map<String, ModuleRuntime>> moduleRuntimes = this.createModuleRuntimes(this.configRegistryClient, this.yangStoreService.getModuleMXBeanEntryMap());
            YangStoreContext yangStoreSnapshot = this.yangStoreService.getCurrentSnapshot();
            Map<String, Map<String, ModuleConfig>> moduleConfigs = this.transformMbeToModuleConfigs((BeanReader)txClient, yangStoreSnapshot.getModuleMXBeanEntryMap());
            Runtime runtime = new Runtime(moduleRuntimes, moduleConfigs);
            Element element = runtime.toXml(runtimeBeans, configBeans, document, yangStoreSnapshot.getEnumResolver());
            return element;
        }
        finally {
            this.transactionProvider.closeReadTransaction();
        }
    }

    public void abortConfiguration() {
        if (this.transactionProvider.getTransaction().isPresent()) {
            this.transactionProvider.abortTransaction();
        }
    }

    public void validateConfiguration() throws ValidationException {
        this.transactionProvider.validateTransaction();
    }

    @Override
    public void close() {
        this.transactionProvider.close();
    }

    public RpcFacade getRpcFacade() {
        return this.rpcFacade;
    }
}

