/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml;

import com.google.common.collect.Multimap;
import java.util.Map;
import org.opendaylight.controller.config.api.ServiceReferenceReadableRegistry;
import org.opendaylight.controller.config.facade.xml.TestOption;
import org.opendaylight.controller.config.facade.xml.mapping.config.Config;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementDefinition;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleElementResolved;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.mapping.config.Services;
import org.opendaylight.controller.config.facade.xml.strategy.EditStrategyType;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.opendaylight.controller.config.util.xml.XmlElement;

public class ConfigExecution {
    private final TestOption testOption;
    private final EditStrategyType defaultEditStrategyType;
    private final Services services;
    private final Config configResolver;
    private final XmlElement configElement;

    public ConfigExecution(Config configResolver, XmlElement configElement, TestOption testOption, EditStrategyType defaultStrategy) throws DocumentedException {
        Config.checkUnrecognisedChildren(configElement);
        this.configResolver = configResolver;
        this.configElement = configElement;
        this.services = configResolver.fromXmlServices(configElement);
        this.testOption = testOption;
        this.defaultEditStrategyType = defaultStrategy;
    }

    public boolean shouldTest() {
        return this.testOption == TestOption.testOnly || this.testOption == TestOption.testThenSet;
    }

    public boolean shouldSet() {
        return this.testOption == TestOption.set || this.testOption == TestOption.testThenSet;
    }

    public Map<String, Multimap<String, ModuleElementResolved>> getResolvedXmlElements(ServiceReferenceReadableRegistry serviceRegistry) throws DocumentedException {
        return this.configResolver.fromXmlModulesResolved(this.configElement, this.defaultEditStrategyType, this.getServiceRegistryWrapper(serviceRegistry));
    }

    public ServiceRegistryWrapper getServiceRegistryWrapper(ServiceReferenceReadableRegistry serviceRegistry) {
        return new ServiceRegistryWrapper(serviceRegistry);
    }

    public Map<String, Multimap<String, ModuleElementDefinition>> getModulesDefinition(ServiceReferenceReadableRegistry serviceRegistry) throws DocumentedException {
        return this.configResolver.fromXmlModulesMap(this.configElement, this.defaultEditStrategyType, this.getServiceRegistryWrapper(serviceRegistry));
    }

    public EditStrategyType getDefaultStrategy() {
        return this.defaultEditStrategyType;
    }

    public Services getServices() {
        return this.services;
    }

    public XmlElement getConfigElement() {
        return this.configElement;
    }
}

