/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.admin1.jmi1.Segment;
import org.opencrx.kernel.base.cci2.PropertySetContainsProperty;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.id.cci.UUIDGenerator;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.security.realm1.cci2.SegmentContainsRealm;
import org.openmdx.security.realm1.jmi1.Realm;

public class WorkflowControllerServlet
extends HttpServlet {
    private static final long serialVersionUID = -2397456308895573603L;
    private static final String COMPONENT_CONFIGURATION_ID = "WorkflowController";
    private static final String COMMAND_START = "/start";
    private static final String COMMAND_STOP = "/stop";
    private static final String COMMAND_PAUSE = "/pause";
    private static final String COMMAND_RESUME = "/resume";
    private static final String MONITORED_WORKFLOW_INDEXER = "IndexerServlet";
    private static final String MONITORED_WORKFLOW_WORKFLOWHANDLER = "WorkflowHandler";
    private static final String MONITORED_WORKFLOW_SUBSCRIPTIONHANDLER = "SubscriptionHandler";
    public static final String OPTION_SERVER_URL = "serverURL";
    public static final String OPTION_AUTOSTART = "autostart";
    public static final String OPTION_PINGRATE = "pingrate";
    public static final String OPTION_EXECUTION_PERIOD = "executionPeriod";
    protected String providerName = null;
    protected ConcurrentMap<String, WorkflowServletConfig> workflowServletConfigs = null;
    protected ConcurrentMap<String, WorkflowServletConfig> monitoredWorkflowServletConfigs = null;
    protected Thread workflowMonitor = null;
    protected boolean isStopped = false;
    protected ComponentConfiguration componentConfiguration = null;

    protected void assertAndStartWorkflowMonitor() {
        if (this.workflowMonitor == null || !this.workflowMonitor.isAlive()) {
            this.workflowMonitor = new Thread(new WorkflowMonitor());
            this.workflowMonitor.start();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String providerName = new Path(this.getInitParameter("realmSegment")).get(2);
        PersistenceManager pm = null;
        try {
            pm = Utils.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to provider", (Throwable)e);
        }
        try {
            Segment adminSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.admin1").getDescendant(new String[]{"provider", providerName, "segment", "Root"}));
            try {
                this.componentConfiguration = adminSegment.getConfiguration(COMPONENT_CONFIGURATION_ID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.componentConfiguration == null) {
                ComponentConfiguration componentConfiguration = (ComponentConfiguration)pm.newInstance(ComponentConfiguration.class);
                componentConfiguration.setName(COMPONENT_CONFIGURATION_ID);
                pm.currentTransaction().begin();
                adminSegment.addConfiguration(false, COMPONENT_CONFIGURATION_ID, componentConfiguration);
                UUIDGenerator uuids = UUIDs.getGenerator();
                StringProperty sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName(OPTION_SERVER_URL);
                sp.setDescription("Server URL");
                sp.setStringValue("http://127.0.0.1:8080/opencrx-core-" + providerName);
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("SubscriptionHandler." + providerName + ".Standard." + OPTION_AUTOSTART);
                sp.setDescription("SubscriptionHandler autostart");
                sp.setStringValue("false");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("SubscriptionHandler." + providerName + ".Standard." + OPTION_PINGRATE);
                sp.setDescription("SubscriptionHandler pingrate");
                sp.setStringValue("2");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("IndexerServlet." + providerName + ".Standard." + OPTION_AUTOSTART);
                sp.setDescription("IndexerServlet autostart");
                sp.setStringValue("false");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("IndexerServlet." + providerName + ".Standard." + OPTION_PINGRATE);
                sp.setDescription("IndexerServlet pingrate");
                sp.setStringValue("2");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("WorkflowHandler." + providerName + ".Standard." + OPTION_AUTOSTART);
                sp.setDescription("WorkflowHandler autostart");
                sp.setStringValue("false");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                sp = (StringProperty)pm.newInstance(StringProperty.class);
                sp.setName("WorkflowHandler." + providerName + ".Standard." + OPTION_PINGRATE);
                sp.setDescription("WorkflowHandler pingrate");
                sp.setStringValue("2");
                componentConfiguration.addProperty(UUIDConversion.toUID((UUID)uuids.next()), sp);
                pm.currentTransaction().commit();
                this.componentConfiguration = adminSegment.getConfiguration(COMPONENT_CONFIGURATION_ID);
            }
        }
        catch (Exception e) {
            throw new ServletException("Can not get component configuration", (Throwable)e);
        }
        HashSet<String> segmentNames = new HashSet<String>();
        try {
            HashSet<String> excludeRealms = new HashSet<String>();
            for (int ii = 0; ii < 100; ++ii) {
                if (this.getInitParameter("excludeRealm[" + ii + "]") == null) continue;
                excludeRealms.add(this.getInitParameter("excludeRealm[" + ii + "]"));
            }
            org.openmdx.security.realm1.jmi1.Segment realmSegment = (org.openmdx.security.realm1.jmi1.Segment)pm.getObjectById((Object)new Path(this.getInitParameter("realmSegment")));
            SegmentContainsRealm.Realm realms = realmSegment.getRealm();
            for (Realm realm : realms) {
                if (excludeRealms.contains(realm.getName())) continue;
                segmentNames.add(realm.getName());
            }
        }
        catch (Exception e) {
            throw new ServletException("Error occured while retrieving realms", (Throwable)e);
        }
        try {
            ConcurrentHashMap<String, WorkflowServletConfig> workflowServletConfigs = new ConcurrentHashMap<String, WorkflowServletConfig>();
            ConcurrentHashMap<String, WorkflowServletConfig> monitoredWorkflowServletConfigs = new ConcurrentHashMap<String, WorkflowServletConfig>();
            for (String segmentName : segmentNames) {
                int ii = 0;
                while (this.getInitParameter("path[" + ii + "]") != null) {
                    String path = this.getInitParameter("path[" + ii + "]");
                    String autostart = this.getComponentConfigProperty(path.substring(1) + "." + providerName + "." + segmentName + "." + OPTION_AUTOSTART);
                    String pingrate = this.getComponentConfigProperty(path.substring(1) + "." + providerName + "." + segmentName + "." + OPTION_PINGRATE);
                    WorkflowServletConfig workflowServletConfig = new WorkflowServletConfig(path + "/execute?provider=" + providerName + "&segment=" + segmentName, autostart != null ? Boolean.valueOf(autostart) : false, pingrate != null ? new PingRate(Long.valueOf(pingrate)) : new PingRate(1L));
                    workflowServletConfigs.put(workflowServletConfig.getPath(), workflowServletConfig);
                    if (workflowServletConfig.isAutostart()) {
                        monitoredWorkflowServletConfigs.put(workflowServletConfig.getPath(), workflowServletConfig);
                    }
                    ++ii;
                }
            }
            this.workflowServletConfigs = workflowServletConfigs;
            this.monitoredWorkflowServletConfigs = monitoredWorkflowServletConfigs;
            this.providerName = providerName;
            this.assertAndStartWorkflowMonitor();
            String autostartConnectors = System.getProperty("org.openmdx.catalina.core.ExtendedService.autostartConnectors");
            this.isStopped = autostartConnectors != null && Boolean.valueOf(autostartConnectors) == false;
        }
        catch (Exception e) {
            throw new ServletException("Can not start workflow monitor", (Throwable)e);
        }
    }

    private String getComponentConfigProperty(String name) {
        String value = null;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)this.componentConfiguration);
        for (int i = 0; i < 1; ++i) {
            PropertySetContainsProperty.Property properties = this.componentConfiguration.getProperty();
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                Property p = (Property)iterator.next();
                if (!p.getName().equals(name) || !(p instanceof StringProperty)) continue;
                value = ((StringProperty)p).getStringValue();
                break;
            }
            if (value != null) break;
            pm.refresh((Object)this.componentConfiguration);
        }
        return value;
    }

    public URL getWorkflowServletURL(String path) throws MalformedURLException {
        String servlerURL = this.getComponentConfigProperty(OPTION_SERVER_URL);
        return servlerURL == null ? null : new URL(servlerURL + path);
    }

    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean active;
        WorkflowServletConfig workflowServletConfig;
        this.assertAndStartWorkflowMonitor();
        if (COMMAND_START.equals(req.getPathInfo())) {
            for (WorkflowServletConfig workflowServletConfig2 : this.workflowServletConfigs.values()) {
                if (!URLEncoder.encode(workflowServletConfig2.getPath(), "UTF-8").equals(req.getQueryString())) continue;
                this.monitoredWorkflowServletConfigs.putIfAbsent(workflowServletConfig2.getPath(), workflowServletConfig2);
                System.out.println(new Date().toString() + "  " + COMPONENT_CONFIGURATION_ID + ": started " + workflowServletConfig2.getPath());
                break;
            }
        } else if (COMMAND_STOP.equals(req.getPathInfo())) {
            URL monitoredURL = this.getWorkflowServletURL(URLDecoder.decode(req.getQueryString(), "UTF-8"));
            Iterator i = this.monitoredWorkflowServletConfigs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                WorkflowServletConfig workflowServletConfig3 = (WorkflowServletConfig)e.getValue();
                URL url = this.getWorkflowServletURL(workflowServletConfig3.getPath());
                if (!url.equals(monitoredURL)) continue;
                i.remove();
                System.out.println(new Date().toString() + "  " + COMPONENT_CONFIGURATION_ID + ": stopped " + workflowServletConfig3.getPath());
                break;
            }
        } else if (COMMAND_PAUSE.equals(req.getPathInfo())) {
            this.isStopped = true;
            System.out.println(new Date().toString() + "  " + COMPONENT_CONFIGURATION_ID + ": paused " + this.providerName);
        } else if (COMMAND_RESUME.equals(req.getPathInfo())) {
            this.isStopped = false;
            System.out.println(new Date().toString() + "  " + COMPONENT_CONFIGURATION_ID + ": resumed " + this.providerName);
        }
        res.setContentType("text/html");
        res.setStatus(200);
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        out.println("  <link rel=\"stylesheet\" href=\"../js/bootstrap/css/bootstrap.min.css\">");
        out.println("  <link rel=\"stylesheet\" href=\"../_style/colors.css\">");
        out.println("  <link rel=\"stylesheet\" href=\"../_style/n2default.css\">");
        out.println("  <link rel=\"stylesheet\" href=\"../_style/ssf.css\">");
        out.println("  <script type=\"text/javascript\" src=\"../js/prototype.js\"></script>");
        out.println("  <link rel='shortcut icon' href='../images/favicon.ico' />");
        out.println("</head>");
        out.println("<body>");
        out.println("  <div id=\"container\">");
        out.println("    <div id=\"wrap\">");
        out.println("      <div id=\"header\" style=\"height:90px;\">");
        out.println("        <div id=\"logoTable\">");
        out.println("          <table id=\"headerlayout\">");
        out.println("            <tr id=\"headRow\">");
        out.println("              <td id=\"head\" colspan=\"2\">");
        out.println("                <table id=\"info\">");
        out.println("                  <tr>");
        out.println("                    <td id=\"headerCellLeft\"><img id=\"logoLeft\" src=\"../images/logoLeft.gif\" alt=\"openCRX\" title=\"\" /></td>");
        out.println("                    <td id=\"headerCellSpacerLeft\"></td>");
        out.println("                    <td id=\"headerCellMiddle\">&nbsp;</td>");
        out.println("                    <td id=\"headerCellRight\"><img id=\"logoRight\" src=\"../images/logoRight.gif\" alt=\"\" title=\"\" /></td>");
        out.println("                  </tr>");
        out.println("                </table>");
        out.println("              </td>");
        out.println("            </tr>");
        out.println("          </table>");
        out.println("        </div>");
        out.println("      </div>");
        out.println("      <div id=\"content-wrap\">");
        out.println("         <div id=\"content\" style=\"padding:0px 0.5em 0px 0.5em;\">");
        out.println("           <h2>Workflow Controller " + this.providerName + "</h2>");
        out.println("           <table class=\"table table-condensed table-striped\" style=\"width:80%\">");
        out.println("             <tr>");
        out.println("               <td><a href=\"" + req.getContextPath() + req.getServletPath() + (this.isStopped ? COMMAND_RESUME : COMMAND_PAUSE) + "\">" + (this.isStopped ? "Resume" : "Pause") + "</a></td><td />");
        out.println("             </tr>");
        out.println("             <tr><td colspan=\"2\"><br /><h3>Active</h3></td></tr>");
        TreeSet sortedPaths = new TreeSet(this.workflowServletConfigs.keySet());
        for (String path : sortedPaths) {
            workflowServletConfig = (WorkflowServletConfig)this.workflowServletConfigs.get(path);
            active = this.monitoredWorkflowServletConfigs.keySet().contains(workflowServletConfig.getPath());
            if (!active) continue;
            out.println("<tr>");
            out.println("  <td style=\"padding:0px;vertical-align:middle;\">" + workflowServletConfig.getPath() + "</td>");
            out.println("  <td style=\"padding:0px;\"><a class=\"btn btn-light\" href=\"" + req.getContextPath() + req.getServletPath() + COMMAND_STOP + "?" + URLEncoder.encode(workflowServletConfig.getPath(), "UTF-8") + "\">" + (active ? "Turn Off" : "Turn On") + "</a></td>");
            out.println("</tr>");
        }
        out.println("<tr><td colspan=\"2\"><br /><h3>Inactive</h3></td></tr>");
        for (String path : sortedPaths) {
            workflowServletConfig = (WorkflowServletConfig)this.workflowServletConfigs.get(path);
            active = this.monitoredWorkflowServletConfigs.keySet().contains(workflowServletConfig.getPath());
            if (active) continue;
            out.println("<tr>");
            out.println("  <td style=\"padding:0px;vertical-align:middle;\">" + workflowServletConfig.getPath() + "</td>");
            out.println("  <td style=\"padding:0px;\"><a class=\"btn btn-light\" href=\"" + req.getContextPath() + req.getServletPath() + COMMAND_START + "?" + URLEncoder.encode(workflowServletConfig.getPath(), "UTF-8") + "\">" + (active ? "Turn Off" : "Turn On") + "</a></td>");
            out.println("</tr>");
        }
        out.println("          </table>");
        out.println("        </div> <!-- content -->");
        out.println("      </div> <!-- content-wrap -->");
        out.println("    </div> <!-- wrap -->");
        out.println("  </div> <!-- container -->");
        out.println("</body>");
        out.println("</html>");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleRequest(req, res);
    }

    public class WorkflowServletConfig {
        private final String path;
        private final boolean isAutostart;
        private final PingRate pingRate;
        private GregorianCalendar nextExecutionAt;

        public WorkflowServletConfig(String path, boolean autostart, PingRate pingRate) {
            this.path = path;
            this.isAutostart = autostart;
            this.pingRate = pingRate;
            this.nextExecutionAt = new GregorianCalendar();
            this.nextExecutionAt.setTimeInMillis(System.currentTimeMillis() + 60000L);
            this.scheduleNextExecution();
        }

        public String getPath() {
            return this.path;
        }

        public boolean isAutostart() {
            return this.isAutostart;
        }

        public Date getNextExecutionAt() {
            return this.nextExecutionAt.getTime();
        }

        public void scheduleNextExecution() {
            GregorianCalendar nextExecutionAt = new GregorianCalendar();
            nextExecutionAt.setTime(this.nextExecutionAt.getTime());
            while (nextExecutionAt.getTime().compareTo(new Date()) < 0) {
                nextExecutionAt.setTimeInMillis(nextExecutionAt.getTimeInMillis() + this.pingRate.getRate() * 60000L);
            }
            this.nextExecutionAt.setTime(nextExecutionAt.getTime());
        }
    }

    public class WorkflowMonitor
    implements Runnable {
        @Override
        public void run() {
            ArrayList<String> paths = new ArrayList<String>();
            for (WorkflowServletConfig workflowServletConfig : WorkflowControllerServlet.this.monitoredWorkflowServletConfigs.values()) {
                paths.add(workflowServletConfig.getPath());
            }
            System.out.println(new Date().toString() + "  " + WorkflowControllerServlet.COMPONENT_CONFIGURATION_ID + ": monitoring " + paths);
            while (true) {
                try {
                    while (true) {
                        if (WorkflowControllerServlet.this.isStopped) {
                            SysLog.detail((String)"Monitor is paused. Waiting for resume.");
                        } else {
                            for (WorkflowServletConfig workflowServletConfig : WorkflowControllerServlet.this.monitoredWorkflowServletConfigs.values()) {
                                URL monitoredURL = WorkflowControllerServlet.this.getWorkflowServletURL(workflowServletConfig.getPath());
                                SysLog.detail((String)"Next execution", Arrays.asList(monitoredURL, workflowServletConfig.getNextExecutionAt()));
                                if (new Date().compareTo(workflowServletConfig.getNextExecutionAt()) <= 0 || monitoredURL == null) continue;
                                try {
                                    HttpURLConnection connection = (HttpURLConnection)monitoredURL.openConnection();
                                    connection.setInstanceFollowRedirects(false);
                                    connection.setDoInput(true);
                                    connection.setDoOutput(true);
                                    connection.setRequestMethod("POST");
                                    int rc = connection.getResponseCode();
                                    if (rc != 200) {
                                        System.out.println(new Date().toString() + "  " + WorkflowControllerServlet.COMPONENT_CONFIGURATION_ID + ": response code for " + monitoredURL + " " + rc);
                                    }
                                    workflowServletConfig.scheduleNextExecution();
                                }
                                catch (IOException e0) {
                                    new ServiceException((Exception)e0).log();
                                }
                            }
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (Exception e) {
                    System.out.println(new Date().toString() + "  " + WorkflowControllerServlet.COMPONENT_CONFIGURATION_ID + ": catched exception (for more information see log) " + e.getMessage());
                    ServiceException e0 = new ServiceException(e);
                    SysLog.error((String)e0.getMessage(), (Throwable)e0.getCause());
                    continue;
                }
                catch (Error e) {
                    System.out.println(new Date().toString() + "  " + WorkflowControllerServlet.COMPONENT_CONFIGURATION_ID + ": catched error (for more information see log) " + e.getMessage());
                    SysLog.error((String)e.getMessage(), (Throwable)e.getCause());
                    continue;
                }
                break;
            }
        }
    }

    public static class PingRate {
        private long rate = 1L;

        public PingRate(long initial) {
            this.rate = initial;
        }

        public void setRate(long newValue) {
            this.rate = newValue;
        }

        public long getRate() {
            return this.rate;
        }

        public void increment() {
            ++this.rate;
        }

        public void decrement() {
            if (this.rate > 1L) {
                --this.rate;
            }
        }
    }
}

