/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils.rtf;

import org.opencrx.kernel.utils.rtf.RtfUtil;

public class Bookmark {
    public static final int TYPE_NIL = -1;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_CHECKBOX = 1;
    public static final int TYPE_LISTBOX = 2;
    private String name;
    private int begin;
    private int end;
    private int contentbegin;
    private int contentend;
    private boolean field;
    private String rawcontent;

    public Bookmark(String name, int begin, int end, int contentBegin, int contentEnd, String rawcontent) {
        this.name = name;
        this.begin = begin;
        this.end = end;
        this.contentbegin = contentBegin;
        this.contentend = contentEnd;
        this.rawcontent = rawcontent;
        this.field = rawcontent != null && rawcontent.indexOf("\\formfield") >= 0;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public int getContentBegin() {
        return this.contentbegin;
    }

    public int getContentEnd() {
        return this.contentend;
    }

    public boolean isField() {
        return this.field;
    }

    public boolean isFieldReadOnly() {
        boolean result = false;
        if (this.isField()) {
            result = this.rawcontent != null && this.rawcontent.indexOf("\\fldlock") >= 0 ? true : this.rawcontent != null && this.rawcontent.indexOf("\\ffprot1") >= 0;
        }
        return result;
    }

    public int getFieldMaxLength() {
        int pos;
        int result = -1;
        if (this.isField() && this.rawcontent != null && (pos = this.rawcontent.indexOf("\\ffmaxlen")) >= 0) {
            result = RtfUtil.getIntegerFromText(this.rawcontent, pos + 9);
        }
        return result;
    }

    public int getFieldtype() {
        int posfd;
        int result = -1;
        if (this.field && (posfd = this.rawcontent.indexOf("\\fftype")) >= 0) {
            switch (this.rawcontent.charAt(posfd + 7)) {
                case '0': {
                    result = 0;
                    break;
                }
                case '1': {
                    result = 1;
                    break;
                }
                case '2': {
                    result = 2;
                    break;
                }
                default: {
                    result = -1;
                }
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getRawContent() {
        return this.rawcontent;
    }
}

