/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TinyUrlUtils {
    public static final String PREFIX = "http://tinyurl.com/";
    private static ConcurrentMap<String, String> tinyUrls = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTinyUrl(String fullUrl) {
        String tinyUrl = (String)tinyUrls.get(fullUrl);
        if (tinyUrl == null) {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)new URL("http://tinyurl.com/api-create.php?url=" + fullUrl).openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("GET");
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    StringBuffer response = new StringBuffer();
                    while (null != (line = reader.readLine())) {
                        response.append(line).append("\n");
                    }
                    tinyUrl = response.toString();
                    if (tinyUrl != null && tinyUrl.indexOf("\n") > 0) {
                        tinyUrl = tinyUrl.substring(0, tinyUrl.indexOf("\n"));
                    }
                    if (tinyUrl != null) {
                        tinyUrls.putIfAbsent(fullUrl, tinyUrl);
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return tinyUrl;
    }
}

