/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.opencrx.kernel.tools.FastResultSet;
import org.opencrx.kernel.utils.DbSchemaUtils;
import org.openmdx.application.configuration.LegacyConfiguration;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2;
import org.openmdx.base.dataprovider.layer.persistence.jdbc.Database_2Configuration;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;

public class CopyDb {
    static final List<String> DBOBJECTS = new ArrayList<String>();
    static final Set<String> BOOLEAN_COLUMNS = new HashSet<String>(Arrays.asList("DISABLED", "USER_BOOLEAN0", "USER_BOOLEAN1", "USER_BOOLEAN2", "USER_BOOLEAN3", "USER_BOOLEAN4", "DO_NOT_BULK_POSTAL_MAIL", "DO_NOT_E_MAIL", "DO_NOT_FAX", "DO_NOT_PHONE", "DO_NOT_POSTAL_MAIL", "EXT_BOOLEAN0", "EXT_BOOLEAN1", "EXT_BOOLEAN2", "EXT_BOOLEAN3", "EXT_BOOLEAN4", "EXT_BOOLEAN5", "EXT_BOOLEAN6", "EXT_BOOLEAN7", "EXT_BOOLEAN8", "EXT_BOOLEAN9", "DISABLED", "DISCOUNT_IS_PERCENTAGE", "USER_BOOLEAN4", "IS_ALL_DAY_EVENT", "DELIVERY_RECEIPT_REQUESTED", "READ_RECEIPT_REQUESTED", "IS_MAIN", "RESET_TO_NULL", "IS_MAIN", "AUTOMATIC_PARSING", "IS_CLOSED", "IS_FINAL", "CREDIT_FIRST", "IS_DEFAULT", "IS_WORKING_DAY", "IS_LOCKED", "IS_GIFT", "IS_TEMPLATE", "DISCOUNT_IS_PERCENTAGE", "IS_GIFT", "SALES_COMMISSION_IS_PERCENTAGE", "IS_CREDIT_ON_HOLD", "ALLOW_POSITION_AUTO_CREATE", "IS_DEFAULT", "IS_LOCKED", "IS_TEMPLATE", "IS_LOCKED", "HOLDER_QUALIFIES_POSITION", "IS_DRAFT", "ALLOW_CREDIT_BOOKINGS", "ALLOW_DEBIT_BOOKINGS", "IS_DEFAULT", "IS_ACTIVE", "BOOLEAN_PARAM", "IS_CHANGEABLE", "IS_QUERY", "IS_DERIVED", "IS_ABSTRACT", "IS_SINGLETON", "IS_CLUSTERED", "IS_NAVIGABLE", "WEIGHT_IS_PERCENTAGE", "IS_FINAL", "DISCOUNT_IS_PERCENTAGE", "IS_DEFAULT", "ALLOW_MODIFICATION", "ALLOW_REMOVAL", "DISCOUNT_IS_PERCENTAGE", "OVERRIDE_PRICE", "IS_STOCK_ITEM", "DISCOUNT_IS_PERCENTAGE", "IS_DEFAULT", "BOOLEAN_VALUE", "IS_ACTIVE", "NEW_BOOLEAN", "OLD_BOOLEAN", "SELECTOR", "IS_SCHEDULE_BASE_UOM", "STORE_SETTINGS_ON_LOGOFF", "IS_SYNCHRONOUS", "FAILED", "IS_BILLABLE", "IS_REIMBURSABLE", "LOCKED", "ALLOW_ADD_DELETE", "ALLOW_CHANGE"));

    private static String getStringFromClob(Clob clob) throws IOException, SQLException {
        int c;
        Reader reader = clob.getCharacterStream();
        StringBuilder s = new StringBuilder();
        while ((c = reader.read()) != -1) {
            s.append((char)c);
        }
        return s.toString();
    }

    private static byte[] getBytesFromBlob(Blob blob) throws IOException, SQLException {
        int b;
        InputStream is = blob.getBinaryStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((b = is.read()) != -1) {
            os.write(b);
        }
        os.close();
        return os.toByteArray();
    }

    private static String mapColumnName(Connection conn, String dbObject, String columnName) throws SQLException {
        String databaseProductName = conn.getMetaData().getDatabaseProductName();
        if ("HSQL Database Engine".equals(databaseProductName)) {
            String mappedColumnName = columnName.toUpperCase();
            if ("POSITION".equals(mappedColumnName) || mappedColumnName.indexOf("$") > 0) {
                return "\"" + mappedColumnName + "\"";
            }
            return mappedColumnName;
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            String mappedColumnName = columnName.toLowerCase();
            if ("offset".equals(mappedColumnName) || "end".equals(mappedColumnName) || mappedColumnName.indexOf("-") > 0) {
                return "\"" + mappedColumnName + "\"";
            }
            return mappedColumnName;
        }
        return columnName.toUpperCase();
    }

    private static Object mapColumnValue(Connection conn, String dbObject, String columnName, Object columnValue, List<String> valuePatterns, List<String> valueReplacements) throws ServiceException, SQLException {
        String databaseProductName = conn.getMetaData().getDatabaseProductName();
        if (BOOLEAN_COLUMNS.contains(columnName.toUpperCase())) {
            if ("PostgreSQL".equals(databaseProductName)) {
                return columnValue;
            }
            if ("MySQL".equals(databaseProductName)) {
                return columnValue;
            }
            if ("Microsoft SQL Server".equals(databaseProductName)) {
                return columnValue;
            }
            if (databaseProductName.startsWith("DB2/")) {
                return "Y".equals(columnValue);
            }
            if ("HSQL Database Engine".equals(databaseProductName)) {
                return columnValue;
            }
            if ("Oracle".equals(databaseProductName)) {
                return ((Number)columnValue).intValue() == 1;
            }
            throw new ServiceException("DefaultDomain", -36, "Database not supported", new BasicException.Parameter[]{new BasicException.Parameter("database product name", (Object)databaseProductName)});
        }
        if (columnValue instanceof String) {
            String targetValue = (String)columnValue;
            for (int i = 0; i < valuePatterns.size(); ++i) {
                String valuePattern = valuePatterns.get(i);
                String valueReplacment = valueReplacements.get(i);
                if (!(valuePattern != null & valuePattern.length() > 0)) continue;
                targetValue = targetValue.replaceAll(valuePattern, valueReplacment);
            }
            return targetValue;
        }
        return columnValue;
    }

    public static void copyDbObject(String dbObject, boolean useSuffix, Connection connSource, Connection connTarget, List<String> valuePatterns, List<String> valueReplacements, PrintStream out) throws SQLException {
        String currentStatement = null;
        Database_2 db = new Database_2();
        try {
            LegacyConfiguration configuration = new LegacyConfiguration();
            configuration.values("booleanType").put((Object)0, (Object)"STANDARD");
            configuration.values("datasource");
            Database_2Configuration.activate((Database_2)db, (LegacyConfiguration)configuration);
        }
        catch (Exception e) {
            out.println("Can not activate database plugin: " + e.getMessage());
        }
        try {
            currentStatement = "DELETE FROM " + dbObject + (useSuffix ? "_" : "");
            PreparedStatement s = connTarget.prepareStatement(currentStatement);
            s.executeUpdate();
            s.close();
            currentStatement = "SELECT * FROM " + dbObject + (useSuffix ? "_" : "");
            s = connSource.prepareStatement(currentStatement);
            ResultSet rs = s.executeQuery();
            if (rs != null) {
                ResultSetMetaData rsm = rs.getMetaData();
                FastResultSet frs = new FastResultSet(rs);
                int nRows = 0;
                while (frs.next()) {
                    int j;
                    String statement = "INSERT INTO " + dbObject + (useSuffix ? "_" : "") + " ";
                    ArrayList<Object> statementParameters = new ArrayList<Object>();
                    ArrayList<String> processTargetColumnNames = new ArrayList<String>();
                    for (j = 0; j < rsm.getColumnCount(); ++j) {
                        String mappedColumnName;
                        String columnName = rsm.getColumnName(j + 1);
                        if (frs.getObject(columnName) == null || (mappedColumnName = CopyDb.mapColumnName(connTarget, dbObject, columnName)) == null) continue;
                        statement = statement + (statementParameters.size() == 0 ? " (" : ", ") + mappedColumnName;
                        processTargetColumnNames.add(mappedColumnName);
                        if (frs.getObject(columnName) instanceof Clob) {
                            try {
                                statementParameters.add(CopyDb.getStringFromClob((Clob)frs.getObject(columnName)));
                            }
                            catch (Exception e) {
                                out.println("Reading Clob failed. Reason: " + e.getMessage());
                                out.println("statement=" + statement);
                                out.println("parameters=" + statementParameters);
                            }
                            continue;
                        }
                        if (frs.getObject(columnName) instanceof Blob) {
                            try {
                                statementParameters.add(CopyDb.getBytesFromBlob((Blob)frs.getObject(columnName)));
                            }
                            catch (Exception e) {
                                out.println("Reading Blob failed. Reason: " + e.getMessage());
                                out.println("statement=" + statement);
                                out.println("parameters=" + statementParameters);
                            }
                            continue;
                        }
                        statementParameters.add(CopyDb.mapColumnValue(connSource, dbObject, columnName, frs.getObject(columnName), valuePatterns, valueReplacements));
                    }
                    statement = statement + ") VALUES (";
                    for (j = 0; j < statementParameters.size(); ++j) {
                        statement = statement + (j == 0 ? "?" : ", ?");
                    }
                    statement = statement + ")";
                    try {
                        currentStatement = statement;
                        PreparedStatement t = connTarget.prepareStatement(currentStatement);
                        for (int j2 = 0; j2 < statementParameters.size(); ++j2) {
                            Method timestampValueMethod;
                            Object parameter = statementParameters.get(j2);
                            if ("oracle.sql.TIMESTAMP".equals(parameter.getClass().getName())) {
                                timestampValueMethod = parameter.getClass().getMethod("timestampValue", new Class[0]);
                                parameter = timestampValueMethod.invoke(parameter, new Object[0]);
                            } else if ("microsoft.sql.DateTimeOffset".equals(parameter.getClass().getName())) {
                                timestampValueMethod = parameter.getClass().getMethod("getTimestamp", new Class[0]);
                                parameter = timestampValueMethod.invoke(parameter, new Object[0]);
                            }
                            if (parameter instanceof Timestamp) {
                                t.setTimestamp(j2 + 1, (Timestamp)parameter);
                                continue;
                            }
                            if (parameter instanceof Date) {
                                t.setDate(j2 + 1, (Date)parameter);
                                continue;
                            }
                            if (parameter instanceof Double) {
                                t.setBigDecimal(j2 + 1, new BigDecimal((Double)parameter));
                                continue;
                            }
                            if (parameter instanceof Float) {
                                t.setBigDecimal(j2 + 1, new BigDecimal(((Float)parameter).floatValue()));
                                continue;
                            }
                            db.setPreparedStatementValue(connTarget, t, j2 + 1, parameter);
                        }
                        t.executeUpdate();
                        t.close();
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        out.println("Insert failed. Reason: " + e.getMessage());
                        out.println("statement=" + statement);
                        out.println("parameters=" + statementParameters);
                    }
                    if (++nRows % 1000 != 0) continue;
                    out.println(nRows + " rows copied");
                }
                rs.close();
            } else {
                out.println("Did not copy table (result set is null). Statement: " + currentStatement);
            }
            s.close();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            out.println("Can not copy table (see log for more info). Statement: " + currentStatement);
        }
    }

    private static void copyNamespace(Connection connSource, Connection connTarget, List<String> dbObjects, List<String> valuePatterns, List<String> valueReplacements, PrintStream out) {
        String currentStatement = null;
        try {
            out.println("Processing tables:");
            int ii = 0;
            for (String dbObject : dbObjects) {
                out.println(ii + ": " + dbObject);
                ++ii;
            }
            HashSet<String> processedDbObjects = new HashSet<String>();
            for (String dbObject : dbObjects) {
                if (dbObject == null || dbObject.isEmpty() || processedDbObjects.contains(dbObject)) continue;
                out.println("Copying table: " + dbObject);
                CopyDb.copyDbObject(dbObject, false, connSource, connTarget, valuePatterns, valueReplacements, out);
                out.println("Copying table: " + dbObject + "_");
                CopyDb.copyDbObject(dbObject, true, connSource, connTarget, valuePatterns, valueReplacements, out);
                processedDbObjects.add(dbObject);
            }
        }
        catch (SQLException e) {
            ServiceException e0 = new ServiceException((Exception)e);
            e0.log();
            out.println("statement: " + currentStatement + " (message=" + e0.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            Properties env = System.getProperties();
            String includeDbObjects = env.getProperty("includeDbObjects");
            String excludeDbObjects = env.getProperty("excludeDbObjects");
            String valuePatterns = env.getProperty("valuePatterns");
            String valueReplacements = env.getProperty("valueReplacements");
            CopyDb.copyDb(env.getProperty("jdbcDriverSource"), env.getProperty("usernameSource"), env.getProperty("passwordSource"), env.getProperty("jdbcUrlSource"), env.getProperty("jdbcDriverTarget"), env.getProperty("usernameTarget"), env.getProperty("passwordTarget"), env.getProperty("jdbcUrlTarget"), includeDbObjects == null ? Collections.emptyList() : Arrays.asList(includeDbObjects.split(",")), excludeDbObjects == null ? Collections.emptyList() : Arrays.asList(excludeDbObjects.split(",")), valuePatterns == null ? Collections.emptyList() : Arrays.asList(valuePatterns.split(",")), valueReplacements == null ? Collections.emptyList() : Arrays.asList(valueReplacements.split(",")), System.out);
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    private static List<String> filterDbObjects(List<String> dbObjects, List<String> includeDbObjects, List<String> excludeDbObjects) throws ServiceException {
        ArrayList<String> filteredDbObjects = new ArrayList<String>();
        for (String dbObject : dbObjects) {
            if (dbObject == null || (dbObject = dbObject.trim()).isEmpty()) continue;
            for (String includeDbObject : includeDbObjects) {
                if (!dbObject.matches(includeDbObject)) continue;
                filteredDbObjects.add(dbObject);
            }
        }
        for (String dbObject : dbObjects) {
            if (dbObject == null) continue;
            dbObject = dbObject.trim();
            for (String excludeDbObject : excludeDbObjects) {
                if (!dbObject.matches(excludeDbObject)) continue;
                filteredDbObjects.remove(dbObject);
            }
        }
        return filteredDbObjects;
    }

    public static void copyDb(String jdbcDriverSource, String usernameSource, String passwordSource, String jdbcUrlSource, String jdbcDriverTarget, String usernameTarget, String passwordTarget, String jdbcUrlTarget, List<String> includeDbObjects, List<String> excludeDbObjects, List<String> valuePatterns, List<String> valueReplacements, PrintStream out) throws ServiceException {
        DBOBJECTS.clear();
        List<Object> tableNames = new ArrayList();
        try {
            tableNames = DbSchemaUtils.getTableNames();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        for (String string : tableNames) {
            if (string.indexOf("_") <= 0 || string.indexOf("_TOBJ_") >= 0 || string.indexOf("_JOIN_") >= 0 || string.endsWith("_")) continue;
            DBOBJECTS.add(string);
        }
        try {
            Class.forName(jdbcDriverSource);
            Properties props = new Properties();
            props.put("user", usernameSource);
            props.put("password", passwordSource);
            Connection connSource = DriverManager.getConnection(jdbcUrlSource, props);
            connSource.setAutoCommit(true);
            Class.forName(jdbcDriverTarget);
            props = new Properties();
            props.put("user", usernameTarget);
            props.put("password", passwordTarget);
            Connection connection = DriverManager.getConnection(jdbcUrlTarget, props);
            connection.setAutoCommit(true);
            CopyDb.copyNamespace(connSource, connection, CopyDb.filterDbObjects(DBOBJECTS, includeDbObjects, excludeDbObjects), valuePatterns, valueReplacements, out);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        out.println();
        out.println("!!! DONE !!!");
    }
}

