/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.text;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openmdx.base.exception.ServiceException;

public class PDFToText {
    public Reader parse(InputStream document) throws ServiceException {
        PDDocument pdfDocument = null;
        try {
            StringWriter output = new StringWriter();
            pdfDocument = PDDocument.load((InputStream)document);
            if (!pdfDocument.isEncrypted()) {
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.setSortByPosition(true);
                stripper.setStartPage(0);
                stripper.setEndPage(Integer.MAX_VALUE);
                stripper.writeText(pdfDocument, (Writer)output);
            }
            StringReader stringReader = new StringReader(output.getBuffer().toString());
            return stringReader;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        finally {
            if (pdfDocument != null) {
                try {
                    pdfDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

