/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal.action;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.opencrx.kernel.backend.XmlExporter;
import org.opencrx.kernel.base.cci2.ExportItemResult;
import org.opencrx.kernel.base.jmi1.ExportItemResult;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Action;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.ViewsCache;
import org.openmdx.portal.servlet.action.ActionPerformResult;
import org.openmdx.portal.servlet.action.BoundAction;
import org.openmdx.portal.servlet.attribute.AttributeValue;
import org.openmdx.portal.servlet.attribute.ObjectReferenceValue;
import org.openmdx.portal.servlet.component.Grid;
import org.openmdx.portal.servlet.component.ObjectView;
import org.openmdx.portal.servlet.component.ReferencePane;
import org.openmdx.portal.servlet.component.ShowObjectView;
import org.openmdx.portal.servlet.component.UiGrid;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public abstract class ExportObjectsAction
extends BoundAction {
    protected abstract GridExporter getGridExporter(UiGrid var1, List<Path> var2, int var3) throws ServiceException;

    public ActionPerformResult perform(ObjectView view, HttpServletRequest request, HttpServletResponse response, String parameter, HttpSession session, Map<String, String[]> requestParameters, ViewsCache editViewsCache, ViewsCache showViewsCache) throws IOException, ServletException {
        ApplicationContext app = view.getApplicationContext();
        if (view instanceof ShowObjectView) {
            PersistenceManager pm;
            block16: {
                ShowObjectView currentView = (ShowObjectView)view;
                pm = app.getNewPmData();
                try {
                    int paneIndex = -1;
                    try {
                        paneIndex = Integer.parseInt(requestParameters.get("pane")[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int referenceIndex = -1;
                    try {
                        referenceIndex = Integer.parseInt(requestParameters.get("reference")[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    List referencePanes = currentView.getChildren(ReferencePane.class);
                    if (paneIndex >= referencePanes.size()) break block16;
                    currentView.selectReferencePane(paneIndex);
                    ((ReferencePane)referencePanes.get(paneIndex)).selectReference(referenceIndex);
                    Grid grid = ((ReferencePane)referencePanes.get(paneIndex)).getGrid();
                    if (!(grid instanceof UiGrid)) break block16;
                    UiGrid uiGrid = (UiGrid)grid;
                    ArrayList<Path> selectedObjectIdentities = new ArrayList<Path>();
                    StringTokenizer tokenizer = new StringTokenizer(parameter, " ");
                    while (tokenizer.hasMoreTokens()) {
                        try {
                            selectedObjectIdentities.add(new Path(Action.getParameter((String)tokenizer.nextToken(), (String)"xri")));
                        }
                        catch (Exception exception) {}
                    }
                    int maxItems = 500;
                    try {
                        maxItems = Integer.parseInt(requestParameters.get("size")[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GridExporter exporter = this.getGridExporter(uiGrid, selectedObjectIdentities, maxItems);
                    String referenceName = uiGrid.getReferenceName();
                    ExportItemResult exportItemResult = exporter.exportItem(view.getObject());
                    if (exportItemResult != null) {
                        response.setContentType(exportItemResult.getItemMimeType());
                        response.setHeader("Content-disposition", "attachment;filename=" + referenceName + "-" + exportItemResult.getItemName());
                        ServletOutputStream os = response.getOutputStream();
                        byte[] bytes = exportItemResult.getItem();
                        for (int i = 0; i < bytes.length; ++i) {
                            os.write(bytes[i]);
                        }
                        response.setContentLength(bytes.length);
                        os.close();
                    }
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e);
                    SysLog.warning((String)e0.getMessage(), (Throwable)e0.getCause());
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            pm.close();
        }
        return new ActionPerformResult(ActionPerformResult.StatusCode.DONE);
    }

    static class WysiwygBasedGridExporter
    implements GridExporter {
        private final UiGrid grid;
        private final List<Path> selectedObjectIdentities;
        private final String mimeType;
        private final boolean allColumns;
        private final int maxItems;

        public WysiwygBasedGridExporter(UiGrid grid, List<Path> selectedObjectIdentities, String mimeType, boolean allColumns, int maxItems) {
            this.grid = grid;
            this.selectedObjectIdentities = selectedObjectIdentities;
            this.mimeType = mimeType;
            this.allColumns = allColumns;
            this.maxItems = maxItems;
        }

        protected void exportRow(HSSFSheet sheet, int rowNum, List<Object> cells) throws ServiceException {
            HSSFCell cell;
            HSSFCellStyle defaultDateStyle = sheet.getWorkbook().createCellStyle();
            defaultDateStyle.setDataFormat((short)14);
            if (rowNum == 0) {
                HSSFRow heading = sheet.createRow(0);
                HSSFCell cell2 = heading.createCell(0);
                cell2.setCellValue((RichTextString)new HSSFRichTextString("XRI"));
                List columnOrderActions = this.grid.getColumnOrderActions();
                for (int i = 1; i < cells.size(); ++i) {
                    Action columnOrderAction = (Action)columnOrderActions.get(i);
                    cell = heading.createCell(i);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(columnOrderAction.getToolTip()));
                }
            }
            HSSFRow row = sheet.createRow(rowNum + 1);
            RefObject_1_0 object = (RefObject_1_0)((ObjectReferenceValue)cells.get(0)).getObject();
            HSSFCell cell3 = row.createCell(0);
            cell3.setCellValue((RichTextString)new HSSFRichTextString(object.refGetPath().toXRI()));
            for (int i = 1; i < cells.size(); ++i) {
                AttributeValue valueHolder = (AttributeValue)cells.get(i);
                Object value = valueHolder.getRawValue();
                cell = row.createCell(i);
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Double) {
                    cell.setCellValue(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Float) {
                    cell.setCellValue((double)((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Integer) {
                    cell.setCellValue((double)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    cell.setCellValue((double)((Long)value).longValue());
                    continue;
                }
                if (value instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    cell.setCellStyle((CellStyle)defaultDateStyle);
                    continue;
                }
                String stringifiedValue = valueHolder == null ? null : valueHolder.toString();
                String string = stringifiedValue = stringifiedValue == null ? "" : stringifiedValue;
                if (stringifiedValue.startsWith("[") && stringifiedValue.endsWith("]")) {
                    stringifiedValue = stringifiedValue.substring(1, stringifiedValue.length() - 1);
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(stringifiedValue));
            }
        }

        @Override
        public ExportItemResult exportItem(RefObject_1_0 startFrom) throws ServiceException {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)startFrom);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet((String)this.grid.getToolTip().get(0));
            if (this.maxItems < Short.MAX_VALUE || this.selectedObjectIdentities != null && !this.selectedObjectIdentities.isEmpty()) {
                List rows = this.grid.getRows(pm, this.allColumns);
                int rowNum = 0;
                for (UiGrid.GridRow row : rows) {
                    List cells = row.getCells();
                    if (cells == null || cells.isEmpty()) continue;
                    RefObject_1_0 object = (RefObject_1_0)((ObjectReferenceValue)cells.get(0)).getObject();
                    if (this.selectedObjectIdentities != null && !this.selectedObjectIdentities.isEmpty() && !this.selectedObjectIdentities.contains(object.refGetPath())) continue;
                    try {
                        this.exportRow(sheet, rowNum, cells);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++rowNum;
                }
            } else {
                boolean showRows = this.grid.getShowRows();
                int pageSize = this.grid.getPageSize();
                this.grid.setShowRows(true);
                int currentPage = 0;
                int rowNum = 0;
                while (true) {
                    this.grid.setPage(currentPage, 500);
                    List rows = this.grid.getRows(pm, this.allColumns);
                    for (UiGrid.GridRow row : rows) {
                        List cells = row.getCells();
                        if (cells == null || cells.isEmpty()) continue;
                        try {
                            this.exportRow(sheet, rowNum, cells);
                            ++rowNum;
                        }
                        catch (Exception exception) {}
                    }
                    if (rows.size() < this.grid.getPageSize() || rowNum > this.maxItems) break;
                    ++currentPage;
                }
                this.grid.setPage(0, pageSize);
                this.grid.setShowRows(showRows);
            }
            QuotaByteArrayOutputStream bs = new QuotaByteArrayOutputStream(XmlExporter.class.getName());
            try {
                wb.write((OutputStream)bs);
                bs.close();
            }
            catch (Exception pageSize) {
                // empty catch block
            }
            String contentMimeType = this.mimeType;
            String contentName = "Export.xls";
            return (ExportItemResult)Structures.create(ExportItemResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ExportItemResult.Member.item, (Object)bs.toByteArray()), Datatypes.member((Enum)ExportItemResult.Member.itemMimeType, (Object)contentMimeType), Datatypes.member((Enum)ExportItemResult.Member.itemName, (Object)contentName), Datatypes.member((Enum)ExportItemResult.Member.status, (Object)0), Datatypes.member((Enum)ExportItemResult.Member.statusMessage, null)});
        }
    }

    static class ModelBasedGridExporter
    extends XmlExporter
    implements GridExporter {
        private final UiGrid grid;
        private final List<Path> selectedObjectIdentities;
        private final String mimeType;
        private final String referenceFilter;
        private final int maxItems;

        public ModelBasedGridExporter(UiGrid grid, List<Path> selectedObjectIdentities, String mimeType, String referenceFilter, int maxItems) {
            this.grid = grid;
            this.selectedObjectIdentities = selectedObjectIdentities;
            this.mimeType = mimeType;
            this.referenceFilter = referenceFilter;
            this.maxItems = maxItems;
        }

        @Override
        public ExportItemResult exportItem(RefObject_1_0 startFrom) throws ServiceException {
            return super.exportItem(startFrom, this.referenceFilter, this.mimeType);
        }

        @Override
        protected Collection<?> getContent(XmlExporter.TraversedObject startingFrom, String referenceName) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)startingFrom.getObject());
            ArrayList<Object> content = new ArrayList<Object>();
            if (this.grid.getReferenceName().equals(referenceName) && this.maxItems < Integer.MAX_VALUE) {
                if (this.selectedObjectIdentities != null && !this.selectedObjectIdentities.isEmpty()) {
                    for (Path identity : this.selectedObjectIdentities) {
                        content.add(pm.getObjectById((Object)identity));
                    }
                } else {
                    List rows = this.grid.getRows(pm);
                    for (UiGrid.GridRow row : rows) {
                        List cells = row.getCells();
                        if (cells == null || cells.isEmpty()) continue;
                        content.add(((ObjectReferenceValue)cells.get(0)).getObject());
                    }
                }
            } else {
                Collection<?> objs = super.getContent(startingFrom, referenceName);
                int count = 0;
                for (Object obj : objs) {
                    content.add(obj);
                    if (++count <= this.maxItems) continue;
                    break;
                }
            }
            return content;
        }
    }

    public static interface GridExporter {
        public ExportItemResult exportItem(RefObject_1_0 var1) throws ServiceException;
    }
}

