/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefStruct;
import javax.servlet.ServletContext;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.activity1.cci2.ActivityProcessTransitionQuery;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.ResourceQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityProcess;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.activity1.jmi1.ActivityType;
import org.opencrx.kernel.activity1.jmi1.Resource;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.SecureObject;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.base.jmi1.Exporter;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.code1.cci2.CodeValueContainerContainsEntry;
import org.opencrx.kernel.code1.jmi1.AbstractEntry;
import org.opencrx.kernel.code1.jmi1.CodeValueContainer;
import org.opencrx.kernel.contract1.jmi1.ContractCreator;
import org.opencrx.kernel.contract1.jmi1.ContractType;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.home1.jmi1.SearchResult;
import org.opencrx.kernel.portal.AbstractPropertyDataBinding;
import org.opencrx.kernel.portal.AccountAssignmentDataBinding;
import org.opencrx.kernel.portal.AccountIsMemberOfDataBinding;
import org.opencrx.kernel.portal.AssignedActivityGroupsDataBinding;
import org.opencrx.kernel.portal.BooleanPropertyDataBinding;
import org.opencrx.kernel.portal.ContractHasAssignedActivitiesDataBinding;
import org.opencrx.kernel.portal.DatePropertyDataBinding;
import org.opencrx.kernel.portal.DateTimePropertyDataBinding;
import org.opencrx.kernel.portal.DecimalPropertyDataBinding;
import org.opencrx.kernel.portal.DocumentDataBinding;
import org.opencrx.kernel.portal.DocumentFolderAssignmentsDataBinding;
import org.opencrx.kernel.portal.EMailRecipientDataBinding;
import org.opencrx.kernel.portal.EmailAddressDataBinding;
import org.opencrx.kernel.portal.FilteredActivitiesDataBinding;
import org.opencrx.kernel.portal.FormattedFollowUpDataBinding;
import org.opencrx.kernel.portal.FormattedNoteDataBinding;
import org.opencrx.kernel.portal.IntegerPropertyDataBinding;
import org.opencrx.kernel.portal.LocalizedFieldDataBinding;
import org.opencrx.kernel.portal.PhoneNumberDataBinding;
import org.opencrx.kernel.portal.PostalAddressDataBinding;
import org.opencrx.kernel.portal.ReferencePropertyDataBinding;
import org.opencrx.kernel.portal.StringPropertyDataBinding;
import org.opencrx.kernel.portal.UserHomeHasAssignedPrincipalDataBinding;
import org.opencrx.kernel.portal.UserHomeHasAssignedPrincipalGroupDataBinding;
import org.opencrx.kernel.portal.UserHomeHasAssignedRoleDataBinding;
import org.opencrx.kernel.portal.UserHomeHasEMailAccountDataBinding;
import org.opencrx.kernel.portal.UserHomeIsDisabledDataBinding;
import org.opencrx.kernel.portal.UserHomeLastLoginAtDataBinding;
import org.opencrx.kernel.portal.WebAddressDataBinding;
import org.opencrx.kernel.portal.action.CreateSubfolderAction;
import org.opencrx.kernel.portal.action.DisableObjectsAction;
import org.opencrx.kernel.portal.action.EnableObjectsAction;
import org.opencrx.kernel.portal.action.ExportAsXlsAction;
import org.opencrx.kernel.portal.action.ExportAsXmlAction;
import org.opencrx.kernel.portal.action.ExportIncludingCompositesAsXmlAction;
import org.opencrx.kernel.portal.action.ExportWysiwygAllColumnsAsXlsAction;
import org.opencrx.kernel.portal.action.ExportWysiwygAsXlsAction;
import org.opencrx.kernel.portal.action.InitUserHomesAction;
import org.opencrx.kernel.portal.action.MarkAlertsAsAcceptedAction;
import org.opencrx.kernel.portal.action.MarkAlertsAsReadAction;
import org.opencrx.kernel.portal.action.MarkPriceLevelAsFinal;
import org.opencrx.kernel.portal.action.MarkPriceLevelAsNonFinal;
import org.opencrx.kernel.utils.QueryBuilderUtil;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.workflow1.cci2.ExporterTaskQuery;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.Segment;
import org.opencrx.security.realm1.jmi1.Principal;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.accessor.jmi.spi.RefMetaObject_1;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.base.query.Condition;
import org.openmdx.base.query.Filter;
import org.openmdx.base.query.IsInCondition;
import org.openmdx.base.query.IsLikeCondition;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.rest.spi.QueryExtensionRecord;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Action;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.Autocompleter_1_0;
import org.openmdx.portal.servlet.Codes;
import org.openmdx.portal.servlet.DataBinding;
import org.openmdx.portal.servlet.DefaultPortalExtension;
import org.openmdx.portal.servlet.ObjectReference;
import org.openmdx.portal.servlet.PortalExtension_1_0;
import org.openmdx.portal.servlet.ValueListAutocompleter;
import org.openmdx.portal.servlet.ViewPort;
import org.openmdx.portal.servlet.action.AbstractAction;
import org.openmdx.portal.servlet.attribute.AttributeValue;
import org.openmdx.portal.servlet.component.Grid;
import org.openmdx.portal.servlet.component.ObjectView;
import org.openmdx.portal.servlet.component.ShowObjectView;
import org.openmdx.portal.servlet.component.UiGrid;
import org.openmdx.portal.servlet.control.Control;
import org.openmdx.security.realm1.cci2.PermissionIsGrantedToRole;
import org.openmdx.security.realm1.cci2.PrincipalQuery;
import org.openmdx.security.realm1.cci2.SegmentContainsRealm;
import org.openmdx.security.realm1.jmi1.Group;
import org.openmdx.security.realm1.jmi1.Permission;
import org.openmdx.security.realm1.jmi1.Realm;
import org.openmdx.security.realm1.jmi1.Role;
import org.openmdx.security.realm1.jmi1.Subject;
import org.openmdx.ui1.jmi1.ElementDefinition;
import org.openmdx.ui1.jmi1.Inspector;
import org.w3c.cci2.BinaryLargeObjects;

public class PortalExtension
extends DefaultPortalExtension
implements Serializable {
    private static final long serialVersionUID = 3761691203816992816L;
    private static final String DOCTYPE_HTML = "<!DOCTYPE HTML";
    private static Map<Path, PermissionsCache> cachedPermissionsByRole = new ConcurrentHashMap<Path, PermissionsCache>();
    private static Map<Path, CachedRoles> cachedRolesByPrincipal = new ConcurrentHashMap<Path, CachedRoles>();
    private static final Set<String> CLASSES_WITH_USER_DEFINABLE_QUALIFER = new HashSet<String>(Arrays.asList("org:opencrx:security:realm1:PrincipalGroup", "org:opencrx:security:realm1:Principal", "org:opencrx:security:realm1:User", "org:opencrx:security:identity:Subject", "org:opencrx:kernel:uom1:Uom"));

    protected PortalExtension_1_0.ActionFactory newActionFactory() {
        return new CrxActionFactory();
    }

    protected Method getMethod(String name, Class<?>[] parameterTypes) throws ServiceException {
        ServletContext context;
        InputStream scriptIs;
        if (this.getServletContext() != null && (scriptIs = (context = this.getServletContext()).getResourceAsStream("/WEB-INF/config/scripts/" + name.substring(0, 1).toUpperCase() + name.substring(1) + ".script")) != null) {
            try {
                ByteArrayOutputStream scriptBytes = new ByteArrayOutputStream();
                BinaryLargeObjects.streamCopy((InputStream)scriptIs, (long)0L, (OutputStream)scriptBytes);
                String script = scriptBytes.toString("UTF-8");
                Class<?> scriptClazz = ScriptUtils.getClass(script);
                Method scriptMethod = scriptClazz.getMethod(name, parameterTypes);
                return scriptMethod;
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        return null;
    }

    public List<Condition> getFindObjectsBaseFilter(ApplicationContext application, RefObject_1_0 context, String referenceName) {
        List baseFilter = super.getFindObjectsBaseFilter(application, context, referenceName);
        boolean excludeDisabled = false;
        try {
            Model_1_0 model = application.getModel();
            ModelElement_1_0 parentDef = ((RefMetaObject_1)context.refMetaObject()).getElementDef();
            ModelElement_1_0 referenceDef = (ModelElement_1_0)parentDef.objGetMap("reference").get(referenceName);
            if (referenceDef != null) {
                ModelElement_1_0 referencedType = model.getElement((Object)referenceDef.getType());
                excludeDisabled = model.getAttributeDefs(referencedType, true, false).containsKey("disabled");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (excludeDisabled) {
            baseFilter.add(new IsInCondition(Quantifier.FOR_ALL, "disabled", true, new Object[]{Boolean.FALSE}));
        }
        return baseFilter;
    }

    protected Base.CodeMapper getCodeMapper(final Codes codes) {
        return new Base.CodeMapper(){

            @Override
            public String getLocaleText(short locale) {
                return (String)codes.getShortText("locale", (short)0, true, true).get(locale);
            }

            @Override
            public String getCurrencyText(short currency, short locale) {
                return (String)codes.getLongText("currency", locale, true, true).get(currency);
            }

            @Override
            public String getCountryText(short country, short locale) {
                return (String)codes.getLongText("org:opencrx:kernel:address1:PostalAddressable:postalCountry", locale, true, true).get(country);
            }
        };
    }

    public String getTitle(RefObject_1_0 obj, short locale, String localeAsString, boolean asShortTitle, ApplicationContext app) {
        if (obj == null) {
            return "#NULL";
        }
        if (JDOHelper.isNew((Object)obj) || !JDOHelper.isPersistent((Object)obj)) {
            return "Untitled";
        }
        try {
            String title = null;
            if (obj instanceof org.openmdx.base.jmi1.Segment) {
                title = app.getLabel(obj.refClass().refMofId());
            } else {
                Codes codes = app.getCodes();
                title = Base.getInstance().getTitle(obj, this.getCodeMapper(codes), locale, asShortTitle);
                title = title == null ? super.getTitle(obj, locale, localeAsString, asShortTitle, app) : title;
            }
            return title;
        }
        catch (Exception e) {
            ServiceException e0 = new ServiceException(e);
            SysLog.info((String)e0.getMessage(), (Throwable)e0.getCause());
            SysLog.info((String)"Unable to get object title", (Object)obj.refGetPath());
            return "#ERR (" + e.getMessage() + ")";
        }
    }

    protected boolean hasPermission(org.openmdx.security.realm1.jmi1.Principal principal, String permission, String specificPermission, String action) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)principal);
        String actionGrant = null;
        String actionRevoke = null;
        if (action.startsWith("+")) {
            actionGrant = action;
            actionRevoke = "-" + action.substring(1);
        } else if (action.startsWith("-")) {
            actionGrant = "+" + action.substring(1);
            actionRevoke = action;
        }
        Boolean allow = null;
        if (actionGrant != null && actionRevoke != null && principal instanceof Principal) {
            CachedRoles cachedRoles = cachedRolesByPrincipal.get(principal.refGetPath());
            if (cachedRoles == null || cachedRoles.isExpired()) {
                List roles = ((Principal)principal).getGrantedRole();
                ArrayList<Role> activeRoles = new ArrayList<Role>();
                Iterator i = roles.iterator();
                while (i.hasNext()) {
                    try {
                        Role role = (Role)i.next();
                        if (Boolean.TRUE.equals(role.isDisabled())) continue;
                        activeRoles.add(role);
                    }
                    catch (Exception e) {
                        SysLog.warning((String)"Role can not be accessed. Ignoring.", (Object)e.getMessage());
                        new ServiceException(e).log();
                    }
                }
                cachedRoles = new CachedRoles(activeRoles);
                cachedRolesByPrincipal.put(principal.refGetPath(), cachedRoles);
            }
            for (Path role : cachedRoles.getRoles()) {
                PermissionsCache permissionsCache = cachedPermissionsByRole.get(role);
                if (permissionsCache == null || permissionsCache.isExpired()) {
                    PermissionIsGrantedToRole.Permission permissions = ((Role)pm.getObjectById((Object)role)).getPermission();
                    permissionsCache = new PermissionsCache((Collection<Permission>)permissions);
                    cachedPermissionsByRole.put(role, permissionsCache);
                }
                if (permissionsCache.containsPermission(permission, actionGrant)) {
                    allow = true;
                }
                if (permissionsCache.containsPermission(permission, actionRevoke)) {
                    allow = false;
                }
                if (specificPermission == null) continue;
                if (permissionsCache.containsPermission(specificPermission, actionGrant)) {
                    allow = true;
                }
                if (!permissionsCache.containsPermission(specificPermission, actionRevoke)) continue;
                allow = false;
            }
        }
        return allow == null ? false : (action.startsWith("+") ? allow : allow == false);
    }

    public boolean hasPermission(String elementName, RefObject_1_0 refObj, ApplicationContext app, String action) {
        if (this.isRootPrincipal(app.getLoginPrincipal()) && elementName != null && (elementName.indexOf("ManageGUIPermissionsWizard") > 0 || elementName.indexOf("DashboardWizard") > 0 || elementName.indexOf("WorkspaceDashboardWizard") > 0)) {
            return action.startsWith("-");
        }
        if (elementName.equals("org:opencrx:kernel:base:Exporter:exportItem")) {
            boolean hasExporter = false;
            try {
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)refObj);
                Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, refObj.refGetPath().getSegment(2).toString(), refObj.refGetPath().getSegment(4).toString());
                ExporterTaskQuery exporterTaskQuery = (ExporterTaskQuery)pm.newQuery(ExporterTask.class);
                exporterTaskQuery.orderByName().ascending();
                exporterTaskQuery.forAllDisabled().isFalse();
                exporterTaskQuery.thereExistsForClass().equalTo((Object)refObj.refClass().refMofId());
                hasExporter = !workflowSegment.getWfProcess(exporterTaskQuery).isEmpty();
            }
            catch (Exception pm) {
                // empty catch block
            }
            return action.startsWith("-") && !hasExporter;
        }
        if (refObj != null) {
            boolean hasPermission;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)refObj);
            String providerName = app.getUserHomeIdentityAsPath().getSegment(2).toString();
            String segmentName = app.getUserHomeIdentityAsPath().getSegment(4).toString();
            org.openmdx.security.realm1.jmi1.Principal principal = Utils.getRequestingPrincipal(pm, providerName, segmentName);
            String packageName = refObj.refClass().refImmediatePackage().refMofId();
            String specificElementName = null;
            if (elementName.indexOf(":") > 0) {
                specificElementName = refObj.refClass().refMofId() + elementName.substring(elementName.lastIndexOf(":"));
            }
            boolean bl = hasPermission = this.hasPermission(principal, elementName, specificElementName, action) || this.hasPermission(principal, packageName, null, action);
            if (hasPermission) {
                return true;
            }
        }
        return super.hasPermission(elementName, refObj, app, action);
    }

    public boolean hasPermission(Control control, RefObject_1_0 refObj, ApplicationContext app, String action) {
        String segmentName;
        String providerName;
        PersistenceManager pm;
        org.openmdx.security.realm1.jmi1.Principal principal;
        boolean hasPermission;
        if (refObj != null && (hasPermission = this.hasPermission(principal = Utils.getRequestingPrincipal(pm = JDOHelper.getPersistenceManager((Object)refObj), providerName = app.getUserHomeIdentityAsPath().getSegment(2).toString(), segmentName = app.getUserHomeIdentityAsPath().getSegment(4).toString()), control.getId(), null, action))) {
            return true;
        }
        return super.hasPermission(control, refObj, app, action);
    }

    public Filter getQueryConditions(String clause, List<String> stringParams, ApplicationContext app) {
        Filter filter = new Filter();
        QueryExtensionRecord queryExtension = new QueryExtensionRecord();
        queryExtension.setClause(clause);
        queryExtension.setStringParam(stringParams.toArray(new String[stringParams.size()]));
        filter.getExtension().add(queryExtension);
        return filter;
    }

    protected QueryBuilderUtil.Predicate getAccountFullNameMatchesPredicate(String qualifiedFeatureName, boolean negate, String ... params) {
        return new QueryBuilderUtil.ReferencePredicate(Utils.getUidAsString(), null, qualifiedFeatureName, QueryBuilderUtil.ReferencePredicate.Condition.EXISTS, new QueryBuilderUtil.OrPredicate(Utils.getUidAsString(), null, negate).or(new QueryBuilderUtil.SingleValuedAttributePredicate(Utils.getUidAsString(), null, "UPPER(fullName)", "org:opencrx:kernel:account1:Account:fullName", QueryBuilderUtil.SingleValuedAttributePredicate.Condition.IS_LIKE, "UPPER(" + params[0] + ")")).or(new QueryBuilderUtil.SingleValuedAttributePredicate(Utils.getUidAsString(), null, "UPPER(fullName)", "org:opencrx:kernel:account1:Account:fullName", QueryBuilderUtil.SingleValuedAttributePredicate.Condition.IS_LIKE, params[1])));
    }

    public Filter getQuery(String qualifiedFeatureName, String filterValue, int queryFilterStringParamCount, ApplicationContext app) throws ServiceException {
        String featureName = qualifiedFeatureName.substring(qualifiedFeatureName.lastIndexOf(":") + 1);
        PortalExtension_1_0.QueryConditionParser conditionParser = this.getQueryConditionParser(qualifiedFeatureName, (Condition)new IsLikeCondition(Quantifier.THERE_EXISTS, featureName, true, new Object[0]));
        Condition condition = conditionParser.parse(filterValue);
        filterValue = filterValue.substring(conditionParser.getOffset());
        if (condition instanceof IsLikeCondition) {
            String stringParam1;
            String clause = null;
            boolean negate = !((IsLikeCondition)condition).isFulfil();
            int paramCount = queryFilterStringParamCount;
            String s0 = "?s" + paramCount++;
            String s1 = "?s" + paramCount++;
            ArrayList<String> stringParams = new ArrayList<String>();
            String stringParam = app.getWildcardFilterValue(filterValue);
            String stringParam0 = stringParam.startsWith("(?i)") ? stringParam.substring(4) : stringParam;
            String string = stringParam1 = stringParam.startsWith("(?i)") ? stringParam.substring(4).toUpperCase() : stringParam.toUpperCase();
            if ("org:opencrx:kernel:contract1:SalesContract:salesRep".equals(qualifiedFeatureName) || "org:opencrx:kernel:contract1:SalesContract:customer".equals(qualifiedFeatureName) || "org:opencrx:kernel:contract1:SalesContract:supplier".equals(qualifiedFeatureName)) {
                clause = this.getAccountFullNameMatchesPredicate(qualifiedFeatureName, negate, s0, s1).toSql("", new Path("xri://@openmdx*org:opencrx.kernel.contract1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "salesOrder"}), "v");
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:activity1:Activity:assignedTo".equals(qualifiedFeatureName) || "org:opencrx:kernel:activity1:Activity:reportingContact".equals(qualifiedFeatureName) || "org:opencrx:kernel:activity1:Activity:reportingAccount".equals(qualifiedFeatureName)) {
                clause = this.getAccountFullNameMatchesPredicate(qualifiedFeatureName, negate, s0, s1).toSql("", new Path("xri://@openmdx*org:opencrx.kernel.activity1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "activity"}), "v");
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:product1:PriceListEntry:product".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_PRODUCT p WHERE v.product = p.object_id AND " + (negate ? "NOT" : "") + " (UPPER(p.name) LIKE UPPER(" + s0 + ") OR UPPER(p.name) LIKE " + s1 + "))";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:AccountAssignment:account".equals(qualifiedFeatureName)) {
                clause = this.getAccountFullNameMatchesPredicate(qualifiedFeatureName, negate, s0, s1).toSql("", new Path("xri://@openmdx*org:opencrx.kernel.account1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "account", ":*", "member"}), "v");
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:contract1:ContractRole:account".equals(qualifiedFeatureName)) {
                clause = this.getAccountFullNameMatchesPredicate(qualifiedFeatureName, negate, s0, s1).toSql("", new Path("xri://@openmdx*org:opencrx.kernel.contract1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "contractRole"}), "v");
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:AccountMembership:accountFrom".equals(qualifiedFeatureName) || "org:opencrx:kernel:account1:AccountMembership:accountTo".equals(qualifiedFeatureName) || "org:opencrx:kernel:account1:AccountMembership:forUseBy".equals(qualifiedFeatureName)) {
                clause = this.getAccountFullNameMatchesPredicate(qualifiedFeatureName, negate, s0, s1).toSql("", new Path("xri://@openmdx*org:opencrx.kernel.account1").getDescendant(new String[]{"provider", ":*", "segment", ":*", "account", ":*", "accountMembership"}), "v");
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:activity1:AddressGroupMember:address".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a WHERE v.address = a.object_id AND " + (negate ? "NOT" : "") + " (UPPER(a.postal_address_line_0) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_address_line_1) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_address_line_2) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_street_0) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_street_1) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_street_2) LIKE UPPER(" + s0 + ") OR UPPER(a.phone_number_full) LIKE UPPER(" + s0 + ") OR UPPER(a.email_address) LIKE UPPER(" + s0 + ")))";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:contract1:AbstractContract:account".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ACCOUNTASSIGNMENT aa INNER JOIN OOCKE1_ACCOUNT a ON aa.account = a.object_id WHERE v.object_id = aa.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.full_name) LIKE UPPER(" + s0 + ") OR UPPER(a.full_name) LIKE " + s1 + "))";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!phoneNumberFull".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.phone_number_full) LIKE UPPER(" + s0 + ") OR UPPER(a.phone_number_full) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Mobile!phoneNumberFull".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.phone_number_full) LIKE UPPER(" + s0 + ") OR UPPER(a.phone_number_full) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_MOBILE + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!emailAddress".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.email_address) LIKE UPPER(" + s0 + ") OR UPPER(a.email_address) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!postalCity".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.postal_city) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_city) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!postalStreet".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.postal_street_0) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_street_0) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!postalAddressLine".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.postal_address_line_0) LIKE UPPER(" + s0 + ") OR UPPER(a.postal_address_line_0) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!region1".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (UPPER(a.region1) LIKE UPPER(" + s0 + ") OR UPPER(a.region1) LIKE " + s1 + ") AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:activity1:Activity:identity".equals(qualifiedFeatureName)) {
                String s2 = "?s" + paramCount++;
                String s3 = "?s" + paramCount++;
                String s4 = "?s" + paramCount++;
                String s5 = "?s" + paramCount++;
                clause = (negate ? "NOT" : "") + " (UPPER(v.name) LIKE UPPER(" + s0 + ") OR UPPER(v.name) LIKE " + s1 + " OR UPPER(v.description) LIKE UPPER(" + s2 + ") OR UPPER(v.description) LIKE " + s3 + " OR UPPER(v.detailed_description) LIKE UPPER(" + s4 + ") OR UPPER(v.detailed_description) LIKE " + s5 + ")";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:home1:UserHome:identity".equals(qualifiedFeatureName)) {
                String s2 = "?s" + paramCount++;
                String s3 = "?s" + paramCount++;
                String s4 = "?s" + paramCount++;
                clause = "(v.object_id LIKE " + s0 + " OR EXISTS (SELECT 0 FROM OOCKE1_ACCOUNT a WHERE v.contact = a.object_id AND (UPPER(a.full_name) LIKE UPPER(" + s1 + ") OR UPPER(a.full_name) LIKE " + s2 + ")) OR EXISTS (SELECT 0 FROM OOCKE1_EMAILACCOUNT a WHERE a.p$$parent = v.object_id AND (UPPER(a.name) LIKE UPPER(" + s3 + ") OR UPPER(a.name) LIKE " + s4 + ")))";
                stringParams.add(stringParam0.endsWith(".*") ? stringParam0.substring(0, stringParam0.length() - 2) : stringParam0);
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else if ("org:opencrx:kernel:account1:Account:address*Business!postalCountry".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_ADDRESS a INNER JOIN OOCKE1_ADDRESS_ a_ ON a.object_id = a_.object_id WHERE v.object_id = a.p$$parent AND " + (negate ? "NOT" : "") + " (a.postal_country IN (" + filterValue + ")) AND a_.objusage = " + Addresses.USAGE_BUSINESS + ")";
            } else if ("org:opencrx:kernel:depot1:DepotReportItemPosition:position".equals(qualifiedFeatureName) || "org:opencrx:kernel:depot1:InventoryLevel:position".equals(qualifiedFeatureName)) {
                clause = "EXISTS (SELECT 0 FROM OOCKE1_DEPOTPOSITION dp WHERE v.position = dp.object_id AND " + (negate ? "NOT" : "") + " (UPPER(dp.name) LIKE UPPER(" + s0 + ") OR UPPER(dp.name) LIKE " + s1 + "))";
                stringParams.add(stringParam0);
                stringParams.add(stringParam1);
            } else {
                return super.getQuery(qualifiedFeatureName, filterValue, queryFilterStringParamCount, app);
            }
            return this.getQueryConditions(clause, stringParams, app);
        }
        return super.getQuery(qualifiedFeatureName, filterValue, queryFilterStringParamCount, app);
    }

    public int getGridPageSize(String referencedTypeName) {
        if ("org:opencrx:kernel:product1:SelectableItem".equals(referencedTypeName)) {
            return 500;
        }
        if ("org:opencrx:kernel:model1:EditableOperation".equals(referencedTypeName)) {
            return 200;
        }
        if ("org:opencrx:kernel:model1:EditableParameter".equals(referencedTypeName)) {
            return 200;
        }
        if ("org:opencrx:kernel:model1:EditableAttribute".equals(referencedTypeName)) {
            return 200;
        }
        if ("org:opencrx:kernel:model1:EditableStructureField".equals(referencedTypeName)) {
            return 200;
        }
        return super.getGridPageSize(referencedTypeName);
    }

    public boolean isLookupType(ModelElement_1_0 classDef) throws ServiceException {
        String qualifiedName = classDef.getQualifiedName();
        return !"org:opencrx:kernel:generic:CrxObject".equals(qualifiedName) && super.isLookupType(classDef);
    }

    public Autocompleter_1_0 getAutocompleter(ApplicationContext app, RefObject_1_0 context, String qualifiedFeatureName, String restrictToType) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)context);
        if ("org:opencrx:kernel:contract1:CreateContractParams:contractType".equals(qualifiedFeatureName) || "org:opencrx:kernel:contract1:CreateSalesContractParams:contractType".equals(qualifiedFeatureName)) {
            ArrayList<ObjectReference> selectableValues = null;
            if (context instanceof ContractCreator) {
                selectableValues = new ArrayList<ObjectReference>();
                ContractCreator contractCreator = (ContractCreator)context;
                List contractTypes = contractCreator.getContractType();
                for (ContractType contractType : contractTypes) {
                    selectableValues.add(new ObjectReference((RefObject_1_0)contractType, app));
                }
            }
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:activity1:ActivityDoFollowUpParams:transition".equals(qualifiedFeatureName) || "org:opencrx:kernel:activity1:LinkToAndFollowUpParams:transition".equals(qualifiedFeatureName)) {
            ArrayList<ObjectReference> selectableValues = null;
            if (context instanceof Activity) {
                Activity activity = (Activity)context;
                ActivityType activityType = null;
                ActivityProcessState processState = null;
                try {
                    activityType = activity.getActivityType();
                    processState = activity.getProcessState();
                }
                catch (Exception contractType) {
                    // empty catch block
                }
                if (activityType != null && processState != null) {
                    selectableValues = new ArrayList<ObjectReference>();
                    ActivityProcess activityProcess = activityType.getControlledBy();
                    processState = activity.getProcessState();
                    if (processState != null) {
                        ActivityProcessTransitionQuery transitionFilter = (ActivityProcessTransitionQuery)pm.newQuery(ActivityProcessTransition.class);
                        transitionFilter.orderByNewPercentComplete().ascending();
                        List transitions = activityProcess.getTransition(transitionFilter);
                        for (ActivityProcessTransition transition : transitions) {
                            if (transition.getPrevState() == null) {
                                SysLog.warning((String)"Transition has undefined previous state", (Object)transition);
                                continue;
                            }
                            if (!transition.getPrevState().equals(processState)) continue;
                            selectableValues.add(new ObjectReference((RefObject_1_0)transition, app));
                        }
                    } else {
                        SysLog.warning((String)"Activity has undefined process state", (Object)activity);
                    }
                }
            }
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:activity1:ActivityAssignToParams:resource".equals(qualifiedFeatureName)) {
            ArrayList<ObjectReference> selectableValues = null;
            if (context instanceof Activity) {
                Activity activity = (Activity)context;
                try {
                    org.opencrx.kernel.activity1.jmi1.Segment activitySegment = Activities.getInstance().getActivitySegment(pm, activity.refGetPath().getSegment(2).toString(), activity.refGetPath().getSegment(4).toString());
                    ResourceQuery query = (ResourceQuery)pm.newQuery(Resource.class);
                    query.forAllDisabled().isFalse();
                    query.contact().isNonNull();
                    query.orderByName().ascending();
                    selectableValues = new ArrayList<ObjectReference>();
                    int count = 0;
                    List resources = activitySegment.getResource(query);
                    for (Resource resource : resources) {
                        if (resource == null) continue;
                        selectableValues.add(new ObjectReference((RefObject_1_0)resource, app));
                    }
                    if (count >= 20) {
                        selectableValues = null;
                    }
                }
                catch (Exception activitySegment) {
                    // empty catch block
                }
            }
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:activity1:ResourceAddWorkRecordByPeriodParams:activity".equals(qualifiedFeatureName) || "org:opencrx:kernel:activity1:ResourceAddWorkRecordByDurationParams:activity".equals(qualifiedFeatureName)) {
            ArrayList<ObjectReference> selectableValues = null;
            if (context instanceof Resource) {
                int count;
                Resource resource = (Resource)context;
                ActivityQuery filter = (ActivityQuery)pm.newQuery(Activity.class);
                filter.thereExistsPercentComplete().lessThan((Comparable)new Short(100));
                filter.orderByActivityNumber().ascending();
                selectableValues = new ArrayList<ObjectReference>();
                List activities = resource.getAssignedActivity(filter);
                Iterator i = activities.iterator();
                for (count = 0; i.hasNext() && count < 20; ++count) {
                    selectableValues.add(new ObjectReference((RefObject_1_0)i.next(), app));
                }
                if (count >= 20) {
                    selectableValues = null;
                }
            }
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:base:StringProperty:stringValue".equals(qualifiedFeatureName) || "org:opencrx:kernel:base:IntegerProperty:integerValue".equals(qualifiedFeatureName) || "org:opencrx:kernel:base:BooleanProperty:booleanValue".equals(qualifiedFeatureName) || "org:opencrx:kernel:base:UriProperty:uriValue".equals(qualifiedFeatureName) || "org:opencrx:kernel:base:DecimalProperty:decimalValue".equals(qualifiedFeatureName)) {
            ArrayList<String> selectableValues = null;
            if (context instanceof Property) {
                Property property = (Property)context;
                try {
                    if (property.getDomain() != null) {
                        selectableValues = new ArrayList<String>();
                        CodeValueContainer domain = property.getDomain();
                        CodeValueContainerContainsEntry.Entry entries = domain.getEntry();
                        Iterator activities = entries.iterator();
                        while (activities.hasNext()) {
                            AbstractEntry entry = (AbstractEntry)activities.next();
                            selectableValues.add(entry.getEntryValue() != null ? entry.getEntryValue() : new Path(entry.refMofId()).getLastSegment().toString());
                        }
                    }
                }
                catch (Exception domain) {
                    // empty catch block
                }
            }
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:base:ExportItemAdvancedParams:itemMimeType".equals(qualifiedFeatureName)) {
            ArrayList<String> selectableValues = new ArrayList<String>();
            selectableValues.add("application/x-excel");
            selectableValues.add("application/xml");
            return selectableValues == null ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:base:ExportItemParams:exporterTask".equals(qualifiedFeatureName)) {
            ArrayList<ObjectReference> selectableValues = new ArrayList<ObjectReference>();
            if (context instanceof Exporter) {
                try {
                    Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, context.refGetPath().getSegment(2).toString(), context.refGetPath().getSegment(4).toString());
                    ExporterTaskQuery exporterTaskQuery = (ExporterTaskQuery)pm.newQuery(ExporterTask.class);
                    exporterTaskQuery.orderByName().ascending();
                    exporterTaskQuery.forAllDisabled().isFalse();
                    exporterTaskQuery.thereExistsForClass().equalTo((Object)context.refClass().refMofId());
                    for (ExporterTask exporterTask : workflowSegment.getWfProcess(exporterTaskQuery)) {
                        selectableValues.add(new ObjectReference((RefObject_1_0)exporterTask, app));
                    }
                }
                catch (Exception workflowSegment) {
                    // empty catch block
                }
            }
            return selectableValues.isEmpty() ? null : new ValueListAutocompleter(selectableValues);
        }
        if ("org:opencrx:kernel:address1:Addressable:tz".equals(qualifiedFeatureName)) {
            TreeSet<String> selectableValues = new TreeSet<String>();
            selectableValues.add("");
            String[] timezones = TimeZone.getAvailableIDs();
            for (int i = 0; i < timezones.length; ++i) {
                String timezoneID = timezones[i].trim();
                selectableValues.add(timezoneID);
            }
            return selectableValues == null ? null : new ValueListAutocompleter(new ArrayList(selectableValues));
        }
        return super.getAutocompleter(app, context, qualifiedFeatureName, restrictToType);
    }

    public ObjectView getLookupView(String id, ModelElement_1_0 lookupType, RefObject_1_0 startFrom, String filterValues, ApplicationContext app) throws ServiceException {
        Model_1_0 model = app.getModel();
        if (startFrom instanceof SalesContract) {
            SalesContract contract = (SalesContract)startFrom;
            Account customer = null;
            try {
                customer = contract.getCustomer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (customer != null && model.isSubtypeOf((Object)"org:opencrx:kernel:account1:AccountAddress", (Object)lookupType)) {
                startFrom = customer;
            }
            ShowObjectView view = (ShowObjectView)super.getLookupView(id, lookupType, startFrom, filterValues, app);
            return view;
        }
        return super.getLookupView(id, lookupType, startFrom, filterValues, app);
    }

    public boolean hasUserDefineableQualifier(Inspector inspector, ApplicationContext application) {
        return application.getCurrentUserRole().startsWith("admin" + SecurityKeys.ID_SEPARATOR) || CLASSES_WITH_USER_DEFINABLE_QUALIFER.contains(inspector.getForClass());
    }

    public void renderTextValue(ViewPort p, AttributeValue attributeValue, String value, boolean asWiki) throws ServiceException {
        ApplicationContext app = p.getApplicationContext();
        if (attributeValue != null && attributeValue.getFieldDef() != null && "org:opencrx:kernel:activity1:EMail:messageBody".equals(attributeValue.getFieldDef().qualifiedFeatureName)) {
            String mailSubject = (String)attributeValue.getValue(false);
            if (mailSubject != null) {
                int end;
                int start = mailSubject.indexOf("<script");
                while (start >= 0 && (end = mailSubject.indexOf("</script>")) > start) {
                    mailSubject = mailSubject.substring(0, start) + mailSubject.substring(end + 9);
                    start = mailSubject.indexOf("<script");
                }
                boolean isHtmlDoctype = mailSubject.regionMatches(true, 0, DOCTYPE_HTML, 0, DOCTYPE_HTML.length());
                String id = Utils.getUidAsString();
                p.write(new CharSequence[]{"<iframe id=\"", id, "\" class=\"container well well-small\" style=\"width:100%\">"});
                p.write(new CharSequence[]{"</iframe>"});
                p.write(new CharSequence[]{"<div id=\"", id, "-content\" style=\"display:none\">"});
                p.write(new CharSequence[]{mailSubject});
                p.write(new CharSequence[]{"</div>"});
                p.write(new CharSequence[]{"<script type=\"text/javascript\">"});
                p.write(new CharSequence[]{"  // FF workaround. Init iframe with empty document"});
                p.write(new CharSequence[]{"  var target = jQuery('#", id, "').contents()[0];"});
                p.write(new CharSequence[]{"  target.open();"});
                p.write(new CharSequence[]{"  target.write('<!doctype html><html><head></head><body></body></html>');"});
                p.write(new CharSequence[]{"  target.close();"});
                p.write(new CharSequence[]{"  jQuery('#", id, "').contents().find('html').html(", isHtmlDoctype ? "" : "'<pre>'+", "jQuery('#", id, "-content').html()", isHtmlDoctype ? "" : "+'</pre>'", ");"});
                p.write(new CharSequence[]{"</script>"});
            }
        } else if (p.getView() instanceof ObjectView && value.indexOf("activity:") >= 0) {
            int newPos;
            RefObject_1_0 object = ((ObjectView)p.getView()).getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
            String providerName = object.refGetPath().getSegment(2).toString();
            String segmentName = object.refGetPath().getSegment(4).toString();
            Path activitySegmentIdentity = new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName});
            org.opencrx.kernel.activity1.jmi1.Segment activitySegment = (org.opencrx.kernel.activity1.jmi1.Segment)pm.getObjectById((Object)activitySegmentIdentity);
            int currentPos = 0;
            while ((newPos = value.indexOf("activity:", currentPos)) >= 0) {
                int start;
                int end;
                super.renderTextValue(p, attributeValue, value.substring(currentPos, newPos), asWiki);
                for (end = start = newPos + 9; end < value.length() && Character.isDigit(value.charAt(end)); ++end) {
                }
                if (end > start) {
                    String activityNumber = value.substring(start, end);
                    ActivityQuery activityQuery = (ActivityQuery)pm.newQuery(Activity.class);
                    activityQuery.thereExistsActivityNumber().equalTo((Object)activityNumber);
                    List activities = activitySegment.getActivity(activityQuery);
                    if (activities.size() == 1) {
                        ObjectReference objRef = new ObjectReference((RefObject_1_0)activities.iterator().next(), app);
                        Action action = objRef.getSelectObjectAction(new Action.Parameter[0]);
                        p.write(new CharSequence[]{"<a href=\"\" onclick=\"javascript:this.href=", p.getEvalHRef(action), ";\">", app.getHtmlEncoder().encode(action.getTitle(), false), "</a>"});
                    } else {
                        super.renderTextValue(p, attributeValue, value.substring(newPos, end), asWiki);
                    }
                } else {
                    super.renderTextValue(p, attributeValue, value.substring(newPos, end), asWiki);
                }
                currentPos = end;
            }
            super.renderTextValue(p, attributeValue, value.substring(currentPos), asWiki);
        } else {
            super.renderTextValue(p, attributeValue, value, asWiki);
        }
    }

    public DataBinding getDataBinding(String dataBindingName) {
        if (dataBindingName != null && dataBindingName.startsWith(StringPropertyDataBinding.class.getName())) {
            return new StringPropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(IntegerPropertyDataBinding.class.getName())) {
            return new IntegerPropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(BooleanPropertyDataBinding.class.getName())) {
            return new BooleanPropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(DecimalPropertyDataBinding.class.getName())) {
            return new DecimalPropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(DatePropertyDataBinding.class.getName())) {
            return new DatePropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(DateTimePropertyDataBinding.class.getName())) {
            return new DateTimePropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(ReferencePropertyDataBinding.class.getName())) {
            return new ReferencePropertyDataBinding(dataBindingName.indexOf("?") < 0 ? AbstractPropertyDataBinding.PropertySetHolderType.CrxObject : AbstractPropertyDataBinding.PropertySetHolderType.valueOf(dataBindingName.substring(dataBindingName.indexOf("?") + 1)));
        }
        if (dataBindingName != null && dataBindingName.startsWith(EmailAddressDataBinding.class.getName())) {
            return new EmailAddressDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(PhoneNumberDataBinding.class.getName())) {
            return new PhoneNumberDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(PostalAddressDataBinding.class.getName())) {
            return new PostalAddressDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(WebAddressDataBinding.class.getName())) {
            return new WebAddressDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(AssignedActivityGroupsDataBinding.class.getName())) {
            return new AssignedActivityGroupsDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(AccountIsMemberOfDataBinding.class.getName())) {
            return new AccountIsMemberOfDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(AccountAssignmentDataBinding.class.getName())) {
            return new AccountAssignmentDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(DocumentFolderAssignmentsDataBinding.class.getName())) {
            return new DocumentFolderAssignmentsDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (dataBindingName != null && dataBindingName.startsWith(EMailRecipientDataBinding.class.getName())) {
            return new EMailRecipientDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (FilteredActivitiesDataBinding.class.getName().equals(dataBindingName)) {
            return new FilteredActivitiesDataBinding();
        }
        if (FormattedNoteDataBinding.class.getName().equals(dataBindingName)) {
            return new FormattedNoteDataBinding();
        }
        if (FormattedFollowUpDataBinding.class.getName().equals(dataBindingName)) {
            return new FormattedFollowUpDataBinding();
        }
        if (DocumentDataBinding.class.getName().equals(dataBindingName)) {
            return new DocumentDataBinding();
        }
        if (ContractHasAssignedActivitiesDataBinding.class.getName().equals(dataBindingName)) {
            return new ContractHasAssignedActivitiesDataBinding();
        }
        if (dataBindingName != null && dataBindingName.startsWith(LocalizedFieldDataBinding.class.getName())) {
            return new LocalizedFieldDataBinding(dataBindingName.indexOf("?") < 0 ? "" : dataBindingName.substring(dataBindingName.indexOf("?") + 1));
        }
        if (UserHomeHasAssignedPrincipalDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeHasAssignedPrincipalDataBinding();
        }
        if (UserHomeHasAssignedPrincipalGroupDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeHasAssignedPrincipalGroupDataBinding();
        }
        if (UserHomeHasAssignedRoleDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeHasAssignedRoleDataBinding();
        }
        if (UserHomeIsDisabledDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeIsDisabledDataBinding();
        }
        if (UserHomeLastLoginAtDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeLastLoginAtDataBinding();
        }
        if (UserHomeHasEMailAccountDataBinding.class.getName().equals(dataBindingName)) {
            return new UserHomeHasEMailAccountDataBinding();
        }
        return super.getDataBinding(dataBindingName);
    }

    public RefObject_1_0 handleOperationResult(RefObject_1_0 target, String operationName, RefStruct params, RefStruct result) throws ServiceException {
        SearchResult searchResult;
        if (result instanceof SearchResult && (searchResult = (SearchResult)result).getObjectFinder() != null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)target);
            RefObject_1_0 objectFinder = (RefObject_1_0)pm.getObjectById((Object)searchResult.getObjectFinder().refGetPath());
            return objectFinder;
        }
        return super.handleOperationResult(target, operationName, params, result);
    }

    public String getNewUserRole(ApplicationContext app, Path requestedObjectIdentity) {
        if (requestedObjectIdentity != null && "Root".equals(requestedObjectIdentity.getSegment(4).toString())) {
            return app.getCurrentUserRole();
        }
        return super.getNewUserRole(app, requestedObjectIdentity);
    }

    protected List<Action> getAlertGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        UiGrid uiGrid;
        ApplicationContext app = view.getApplicationContext();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (grid instanceof UiGrid && "org:opencrx:kernel:home1:Alert".equals((uiGrid = (UiGrid)grid).getReferencedTypeName())) {
            ElementDefinition uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:home1:Alert:Pane:Op:Tab:markAsRead");
            String label = uiElementDef == null ? "Mark as read" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
            Action markAlertsAsReadAction = new Action(106, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label, true);
            actions.add(markAlertsAsReadAction);
            uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:home1:Alert:Pane:Op:Tab:markAsAccepted");
            label = uiElementDef == null ? "Mark as accepted" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
            Action markAlertsAsAcceptedAction = new Action(107, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label, true);
            actions.add(markAlertsAsAcceptedAction);
        }
        return actions;
    }

    protected List<Action> getPriceLevelGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        UiGrid uiGrid;
        ApplicationContext app = view.getApplicationContext();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (grid instanceof UiGrid && "org:opencrx:kernel:product1:AbstractPriceLevel".equals((uiGrid = (UiGrid)grid).getReferencedTypeName())) {
            ElementDefinition uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:product1:AbstractPriceLevel:isFinal");
            String label = uiElementDef == null ? "Is final" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
            Action markPriceLevelsAsFinalAction = new Action(108, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, "Set &#171" + label + "&#187", true);
            actions.add(markPriceLevelsAsFinalAction);
            uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:product1:AbstractPriceLevel:isFinal");
            label = uiElementDef == null ? "Is final" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
            Action markPriceLevelsAsNonFinalAction = new Action(114, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, "Reset &#171" + label + "&#187", true);
            actions.add(markPriceLevelsAsNonFinalAction);
        }
        return actions;
    }

    protected List<Action> getDocumentFolderGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        UiGrid uiGrid;
        ApplicationContext app = view.getApplicationContext();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (grid instanceof UiGrid && "org:opencrx:kernel:document1:DocumentFolder".equals((uiGrid = (UiGrid)grid).getReferencedTypeName())) {
            ElementDefinition uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:document1:DocumentFolder");
            String label = uiElementDef == null ? app.getTexts().getNewText() + " folder" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? app.getTexts().getNewText() + " " + (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : app.getTexts().getNewText() + " " + (String)uiElementDef.getToolTip().get(0));
            Action createSubfolderAction = new Action(109, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId())}, label, true);
            actions.add(createSubfolderAction);
        }
        return actions;
    }

    protected List<Action> getUserHomeGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        UiGrid uiGrid;
        ArrayList<Action> actions = new ArrayList<Action>();
        if (grid instanceof UiGrid && "org:opencrx:kernel:home1:UserHome".equals((uiGrid = (UiGrid)grid).getReferencedTypeName())) {
            Action initUserHomesAction = new Action(111, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId())}, "Init user homes", true);
            actions.add(initUserHomesAction);
        }
        return actions;
    }

    protected List<Action> getEnableDisableGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        ApplicationContext app = view.getApplicationContext();
        ArrayList<Action> actions = new ArrayList<Action>();
        ElementDefinition uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:generic:CrxObject:Pane:Op:Tab:enableCrxObject");
        String label = uiElementDef == null ? "Enable" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
        Action enableObjectsAction = new Action(112, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label, true);
        actions.add(enableObjectsAction);
        uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:generic:CrxObject:Pane:Op:Tab:disableCrxObject");
        label = uiElementDef == null ? "Disable" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
        Action disableObjectsAction = new Action(113, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label, true);
        actions.add(disableObjectsAction);
        return actions;
    }

    protected List<Action> getExportGridActions(ObjectView view, Grid grid, int maxSize) throws ServiceException {
        ApplicationContext app = view.getApplicationContext();
        ArrayList<Action> actions = new ArrayList<Action>();
        ElementDefinition uiElementDef = app.getUiElementDefinition("org:opencrx:kernel:base:Exporter:Pane:Op:Tab:exportItem");
        String label = uiElementDef == null ? "Export" : (app.getCurrentLocaleAsIndex() < uiElementDef.getToolTip().size() ? (String)uiElementDef.getToolTip().get(app.getCurrentLocaleAsIndex()) : (String)uiElementDef.getToolTip().get(0));
        Action exportWysiwygAsXlsAction = new Action(104, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label + " &#10137 XLS (wysiwyg)", true);
        actions.add(exportWysiwygAsXlsAction);
        Action exportWysiwygAllColumnsAsXlsAction = new Action(105, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label + " &#10137 XLS (wysiwyg+)", true);
        actions.add(exportWysiwygAllColumnsAsXlsAction);
        Action exportAsXmlAction = new Action(102, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label + " &#10137 XML", true);
        actions.add(exportAsXmlAction);
        Action exportAsXlsAction = new Action(101, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label + " &#10137 XLS", true);
        actions.add(exportAsXlsAction);
        Action exportIncludingCompositesAsXmlAction = new Action(103, new Action.Parameter[]{new Action.Parameter("xri", view.getObject().refMofId()), new Action.Parameter("size", Integer.toString(maxSize))}, label + " &#10137 XML+", true);
        actions.add(exportIncludingCompositesAsXmlAction);
        return actions;
    }

    public List<Action> getGridActions(ObjectView view, Grid grid) throws ServiceException {
        int MAX_SIZE = 500;
        ArrayList<Action> actions = new ArrayList<Action>(super.getGridActions(view, grid));
        actions.addAll(this.getAlertGridActions(view, grid, 500));
        actions.addAll(this.getPriceLevelGridActions(view, grid, 500));
        actions.addAll(this.getDocumentFolderGridActions(view, grid, 500));
        actions.addAll(this.getUserHomeGridActions(view, grid, 500));
        actions.addAll(this.getEnableDisableGridActions(view, grid, 500));
        actions.addAll(this.getExportGridActions(view, grid, 500));
        return actions;
    }

    protected List<Group> getGroupMembership(org.openmdx.security.realm1.jmi1.Principal loginPrincipal, String realmName, PersistenceManager pm) {
        try {
            String loginPrincipalName = new Path(loginPrincipal.refMofId()).getLastSegment().toString();
            Path loginPrincipalIdentity = loginPrincipal.refGetPath();
            SysLog.detail((String)"Group membership for segment", (Object)realmName);
            SysLog.detail((String)"Group membership for principal", (Object)loginPrincipalIdentity);
            org.openmdx.security.realm1.jmi1.Principal principal = (org.openmdx.security.realm1.jmi1.Principal)pm.getObjectById((Object)loginPrincipalIdentity.getPrefix(loginPrincipalIdentity.size() - 3).getDescendant(new String[]{realmName, "principal", loginPrincipalName}));
            return principal.getIsMemberOf();
        }
        catch (Exception e) {
            SysLog.detail((String)"Can not retrieve group membership", (Throwable)e);
            new ServiceException(e).log();
            return null;
        }
    }

    public boolean checkPrincipal(Path realmIdentity, String principalName, PersistenceManager pm) throws ServiceException {
        org.openmdx.security.realm1.jmi1.Principal principal = SecureObject.getInstance().findPrincipal(principalName, realmIdentity, pm);
        if (principal == null) {
            SysLog.info((String)"principal not found in realm", (Object)("realm=" + realmIdentity + ", principal=" + principalName));
            return false;
        }
        return !Boolean.TRUE.equals(principal.isDisabled());
    }

    public List<String> getUserRoles(Path loginRealmIdentity, String loginPrincipalName, PersistenceManager pm) throws ServiceException {
        List principalChain = PersistenceManagers.toPrincipalChain((String)loginPrincipalName);
        Realm loginRealm = (Realm)pm.getObjectById((Object)loginRealmIdentity);
        ArrayList<String> roleNames = new ArrayList<String>();
        org.openmdx.security.realm1.jmi1.Principal primaryLoginPrincipal = loginRealm.getPrincipal((String)principalChain.get(0));
        Subject subject = primaryLoginPrincipal.getSubject();
        PrincipalQuery principalQuery = (PrincipalQuery)pm.newQuery(org.openmdx.security.realm1.jmi1.Principal.class);
        principalQuery.thereExistsSubject().equalTo((Object)subject);
        List allLoginPrincipals = loginRealm.getPrincipal(principalQuery);
        org.openmdx.security.realm1.jmi1.Segment realmSegment = (org.openmdx.security.realm1.jmi1.Segment)pm.getObjectById((Object)loginRealm.refGetPath().getParent().getParent());
        long leastRecentLoginAt = 0L;
        SegmentContainsRealm.Realm realms = realmSegment.getRealm();
        for (Realm realm : realms) {
            SysLog.detail((String)"Checking realm", (Object)realm);
            if (realm.equals(loginRealm)) continue;
            for (org.openmdx.security.realm1.jmi1.Principal loginPrincipal : allLoginPrincipals) {
                String id = loginPrincipal.refGetPath().getLastSegment().toString();
                ArrayList<String> principalIds = new ArrayList<String>();
                principalIds.add(id);
                if (id.equals(principalChain.get(0)) && !id.equals(loginPrincipalName)) {
                    principalIds.add(loginPrincipalName);
                }
                for (String principalId : principalIds) {
                    SysLog.detail((String)"Checking principal", (Object)principalId);
                    org.openmdx.security.realm1.jmi1.Principal principal = SecureObject.getInstance().findPrincipal(principalId, realm.refGetPath(), pm);
                    String realmName = realm.refGetPath().getLastSegment().toString();
                    if (principal == null || Boolean.TRUE.equals(principal.isDisabled())) continue;
                    try {
                        List<Group> groups = this.getGroupMembership(principal, realmName, pm);
                        SysLog.detail((String)"Principal groups", groups);
                        if (groups == null) continue;
                        long lastLoginAt = 0L;
                        try {
                            Date at = (Date)principal.refGetValue("lastLoginAt");
                            if (at != null) {
                                lastLoginAt = at.getTime();
                            }
                        }
                        catch (Exception at) {
                            // empty catch block
                        }
                        String roleId = principalId + "@" + realmName;
                        SysLog.detail((String)"Checking role", (Object)roleId);
                        if (!(roleNames.contains(roleId) || "Root".equals(realmName) && !"admin-Root".equals(principalId))) {
                            SysLog.detail((String)"Adding role", (Object)roleId);
                            roleNames.add(lastLoginAt > leastRecentLoginAt ? 0 : roleNames.size(), roleId);
                        }
                        try {
                            for (Group userGroup : groups) {
                                SysLog.detail((String)"Checking group", (Object)userGroup);
                                String userGroupIdentity = userGroup.refGetPath().getLastSegment().toString();
                                if (!"Administrators".equals(userGroupIdentity) || roleNames.contains(roleId = "admin-" + realmName + "@" + realmName)) continue;
                                SysLog.detail((String)"Adding role", (Object)roleId);
                                roleNames.add(lastLoginAt > leastRecentLoginAt ? 1 : roleNames.size(), roleId);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        leastRecentLoginAt = Math.max(lastLoginAt, leastRecentLoginAt);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return roleNames;
    }

    public String getAdminPrincipal(String realmName) {
        return "admin-" + realmName;
    }

    public boolean isRootPrincipal(String principalName) {
        return principalName.startsWith("admin-Root");
    }

    public void setLastLoginAt(Path realmIdentity, String segmentName, String principalName, PersistenceManager pm) throws ServiceException {
        try {
            List principalChain = PersistenceManagers.toPrincipalChain((String)principalName);
            org.openmdx.security.realm1.jmi1.Principal principal = (org.openmdx.security.realm1.jmi1.Principal)pm.getObjectById((Object)realmIdentity.getParent().getDescendant(new String[]{segmentName, "principal", (String)principalChain.get(0)}));
            pm.currentTransaction().begin();
            principal.refSetValue("lastLoginAt", (Object)new Date());
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SysLog.info((String)"Unable to set last login date. For more info see detail log", (Object)e.getMessage());
            SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    public TimeZone getTimeZone(String qualifiedFeatureName, ApplicationContext app) {
        if ("org:opencrx:kernel:account1:Contact:birthdate".equals(qualifiedFeatureName) || "org:opencrx:kernel:account1:Contact:anniversary".equals(qualifiedFeatureName) || "org:opencrx:kernel:account1:Contact:dateOfDeath".equals(qualifiedFeatureName)) {
            return TimeZone.getTimeZone("UTC");
        }
        return super.getTimeZone(qualifiedFeatureName, app);
    }

    public PortalExtension_1_0.SearchFieldDef getSearchFieldDef(String qualifiedReferenceName, String featureName, ApplicationContext app) throws ServiceException {
        Model_1_0 model = app.getModel();
        ModelElement_1_0 referenceDef = null;
        try {
            referenceDef = model.getElement((Object)qualifiedReferenceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (referenceDef != null && referenceDef.isReferenceType()) {
            ModelElement_1_0 featureType;
            ModelElement_1_0 referencedType = model.getElement((Object)referenceDef.getType());
            ModelElement_1_0 featureDef = null;
            try {
                featureDef = model.getFeatureDef(referencedType, featureName, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (featureDef != null && featureDef.isReferenceType() && (featureType = model.getElement((Object)featureDef.getType())) != null && featureType.isClassType() && model.isSubtypeOf((Object)featureType, (Object)"org:opencrx:kernel:account1:Account")) {
                return new AccountSearchFieldDef(qualifiedReferenceName, featureName);
            }
        }
        return super.getSearchFieldDef(qualifiedReferenceName, featureName, app);
    }

    static class AccountSearchFieldDef
    extends PortalExtension_1_0.SearchFieldDef {
        public AccountSearchFieldDef(String qualifiedReferenceName, String featureName) {
            super(qualifiedReferenceName, featureName);
        }

        public List<String> findValues(Object object, String pattern, ApplicationContext app) throws ServiceException {
            ArrayList<String> values = new ArrayList<String>();
            if (object instanceof RefObject_1_0 && pattern != null && pattern.length() >= 1) {
                RefObject_1_0 refObj = (RefObject_1_0)object;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)refObj);
                String providerName = refObj.refGetPath().getSegment(2).toString();
                String segmentName = refObj.refGetPath().getSegment(4).toString();
                org.opencrx.kernel.account1.jmi1.Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
                AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
                accountQuery.forAllDisabled().isFalse();
                accountQuery.thereExistsFullName().like((Object)("(?i).*" + pattern + ".*"));
                accountQuery.orderByFullName().ascending();
                int count = 0;
                for (Account account : accountSegment.getAccount(accountQuery)) {
                    values.add(app.getPortalExtension().getTitle((RefObject_1_0)account, app.getCurrentLocaleAsIndex(), app.getCurrentLocaleAsString(), false, app));
                    if (++count <= 30) continue;
                    break;
                }
            }
            return values;
        }
    }

    static class CachedRoles {
        private final List<Path> roles;
        private final long expiresAt = System.currentTimeMillis() + 60000L;
        private static final long TTL = 60000L;

        public CachedRoles(List<Role> roles) {
            this.roles = new ArrayList<Path>();
            for (Role role : roles) {
                this.roles.add(role.refGetPath());
            }
        }

        public List<Path> getRoles() {
            return this.roles;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }
    }

    static class PermissionsCache {
        private final Set<CachedPermission> permissions;
        private final long expiresAt = System.currentTimeMillis() + 60000L;
        private static final long TTL = 60000L;

        public PermissionsCache(Collection<Permission> permissions) {
            this.permissions = new TreeSet<CachedPermission>();
            for (Permission permission : permissions) {
                for (String action : permission.getAction()) {
                    this.permissions.add(new CachedPermission(permission.getName(), action));
                }
            }
        }

        public boolean containsPermission(String permission, String action) {
            return this.permissions.contains(new CachedPermission(permission, action));
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }
    }

    static class CachedPermission
    implements Comparable<CachedPermission> {
        public String permission;
        public String action;

        public CachedPermission(String permission, String action) {
            this.permission = permission;
            this.action = action;
        }

        @Override
        public int compareTo(CachedPermission that) {
            int compare = this.permission.compareTo(that.permission);
            return compare == 0 ? this.action.compareTo(that.action) : compare;
        }

        public String toString() {
            return this.permission + "|" + this.action;
        }
    }

    public static class CrxActionFactory
    extends DefaultPortalExtension.DefaultActionFactory {
        public AbstractAction getAction(short event) {
            switch (event) {
                case 102: {
                    return new ExportAsXmlAction();
                }
                case 101: {
                    return new ExportAsXlsAction();
                }
                case 103: {
                    return new ExportIncludingCompositesAsXmlAction();
                }
                case 104: {
                    return new ExportWysiwygAsXlsAction();
                }
                case 105: {
                    return new ExportWysiwygAllColumnsAsXlsAction();
                }
                case 106: {
                    return new MarkAlertsAsReadAction();
                }
                case 107: {
                    return new MarkAlertsAsAcceptedAction();
                }
                case 108: {
                    return new MarkPriceLevelAsFinal();
                }
                case 109: {
                    return new CreateSubfolderAction();
                }
                case 111: {
                    return new InitUserHomesAction();
                }
                case 112: {
                    return new EnableObjectsAction();
                }
                case 113: {
                    return new DisableObjectsAction();
                }
                case 114: {
                    return new MarkPriceLevelAsNonFinal();
                }
            }
            return super.getAction(event);
        }
    }
}

