/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.generic.cci2.LocalizedFieldQuery;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.LocalizedField;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DataBinding;

public class LocalizedFieldDataBinding
extends DataBinding {
    private final short usage;

    public LocalizedFieldDataBinding(String parameterString) {
        short usage = 0;
        if (parameterString != null) {
            String[] parameters;
            for (String parameter : parameters = parameterString.split(";")) {
                if (!parameter.startsWith("usage=")) continue;
                try {
                    usage = Short.valueOf(parameter.substring(6));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.usage = usage;
    }

    protected String getLocalizedFieldName(String qualifiedFeatureName) {
        return qualifiedFeatureName.substring(qualifiedFeatureName.indexOf("!") + 1);
    }

    protected LocalizedField findLocalizedField(RefObject object, String name, ApplicationContext app) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
        if (object instanceof CrxObject) {
            CrxObject crxObject = (CrxObject)object;
            LocalizedFieldQuery query = (LocalizedFieldQuery)pm.newQuery(LocalizedField.class);
            query.name().equalTo((Object)name);
            query.locale().equalTo((Object)app.getCurrentLocaleAsIndex());
            query.usage().equalTo((Object)this.usage);
            List localizedFields = crxObject.getLocalizedField(query);
            return localizedFields.isEmpty() ? null : (LocalizedField)localizedFields.iterator().next();
        }
        return null;
    }

    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        String name = this.getLocalizedFieldName(qualifiedFeatureName);
        LocalizedField localizedField = this.findLocalizedField(object, name, app);
        return localizedField == null ? null : localizedField.getLocalizedValue();
    }

    public void setValue(RefObject object, String qualifiedFeatureName, Object newValue, ApplicationContext app) {
        String name = this.getLocalizedFieldName(qualifiedFeatureName);
        LocalizedField localizedField = this.findLocalizedField(object, name, app);
        if (localizedField == null) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
            if (object instanceof CrxObject) {
                CrxObject crxObject = (CrxObject)object;
                localizedField = (LocalizedField)pm.newInstance(LocalizedField.class);
                crxObject.addLocalizedField(Utils.getUidAsString(), localizedField);
            }
        }
        if (localizedField != null) {
            localizedField.setName(name);
            localizedField.setLocale(app.getCurrentLocaleAsIndex());
            localizedField.setLocalizedValue((String)newValue);
            localizedField.setUsage(this.usage);
        }
    }
}

