/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.application;

import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Interaction;
import org.opencrx.kernel.layer.application.DerivedReferences;
import org.openmdx.base.collection.TreeSparseArray;
import org.openmdx.base.dataprovider.cci.DataproviderRequestProcessor;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.AbstractRestInteraction;
import org.openmdx.base.rest.spi.AbstractRestPort;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.SparseArray;

public class OpenCrxKernel_2
extends AbstractRestPort {
    protected List<String> readOnlyTypes = null;

    public SparseArray<String> getReadOnlyObjectType() {
        return new TreeSparseArray(this.readOnlyTypes);
    }

    public void setReadOnlyObjectType(SparseArray<String> readOnlyObjectType) {
        this.readOnlyTypes = new ArrayList<String>(readOnlyObjectType.values());
    }

    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(connection);
    }

    protected DataproviderRequestProcessor newDelegateRequestProcessor(RestConnection connection) throws ResourceException {
        return new DataproviderRequestProcessor(PersistenceManagers.toPrincipalChain((String)connection.getMetaData().getUserName()), this.getDelegate());
    }

    public class RestInteraction
    extends AbstractRestInteraction {
        public RestInteraction(RestConnection connection) throws ResourceException {
            super(connection, OpenCrxKernel_2.this.newDelegateInteraction(connection));
        }

        protected DerivedReferences newDerivedReferences(RestInteractionSpec ispec) throws ResourceException {
            return new DerivedReferences(OpenCrxKernel_2.this.newDelegateRequestProcessor((RestConnection)this.getConnection()), OpenCrxKernel_2.this.readOnlyTypes);
        }

        public void testReferenceIsChangeable(Path referencePath) throws ResourceException {
            try {
                Model_1_0 model = Model_1Factory.getModel();
                ModelElement_1_0 reference = null;
                try {
                    reference = model.getReferenceType(referencePath);
                }
                catch (ServiceException e) {
                    SysLog.warning((String)"Reference not found in model", (Object)referencePath);
                }
                if (reference != null && !reference.isChangeable().booleanValue()) {
                    throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Reference is readonly. Can not add/remove objects.", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)10002, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)referencePath)})));
                }
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean get(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            boolean isDerived = this.newDerivedReferences(ispec).getReply(ispec, request, response);
            if (!isDerived) {
                return super.get(ispec, request, response);
            }
            return true;
        }

        public boolean find(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            boolean isDerived = this.newDerivedReferences(ispec).getReply(ispec, request, response);
            if (!isDerived) {
                return super.find(ispec, request, response);
            }
            return true;
        }

        public boolean create(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            this.testReferenceIsChangeable(request.getResourceIdentifier().getParent());
            return super.create(ispec, request, response);
        }

        public boolean delete(RestInteractionSpec ispec, ObjectRecord request) throws ResourceException {
            this.testReferenceIsChangeable(request.getResourceIdentifier().getParent());
            return super.delete(ispec, request);
        }
    }
}

