/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.layer.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.MappedRecord;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.backend.Products;
import org.openmdx.application.dataprovider.cci.AttributeSpecifier;
import org.openmdx.application.dataprovider.cci.FilterProperty;
import org.openmdx.base.dataprovider.cci.DataproviderRequestProcessor;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.query.Condition;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Filter;
import org.openmdx.base.query.IsInCondition;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.query.SortOrder;
import org.openmdx.base.resource.Records;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryFilterRecord;
import org.openmdx.base.rest.cci.QueryRecord;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;

public class DerivedReferences {
    private final Model_1_0 model = Model_1Factory.getModel();
    private final DataproviderRequestProcessor dataproviderRequestProcessor;
    private final List<String> readOnlyTypes;
    private static final Path COMPOUND_BOOKING_HAS_BOOKINGS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/cb/:*/booking");
    private static final Path DEPOT_POSITION_HAS_BOOKINGS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depotHolder/:*/depot/:*/position/:*/booking");
    private static final Path DEPOT_POSITION_HAS_SIMPLE_BOOKINGS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depotHolder/:*/depot/:*/position/:*/simpleBooking");
    private static final Path CLASSIFIER_CLASSIFIES_TYPED_ELEMENT = new Path("xri://@openmdx*org.opencrx.kernel.model1/provider/:*/segment/:*/element/:*/typedElement");
    private static final Path DEPOT_REPORT_ITEM_HAS_BOOKING_ITEMS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depotHolder/:*/depot/:*/report/:*/itemPosition/:*/itemBooking");
    private static final Path DEPOT_GROUP_CONTAINS_DEPOTS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depotGroup/:*/depot");
    private static final Path DEPOT_GROUP_CONTAINS_DEPOT_GROUPS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depotGroup/:*/depotGroup");
    private static final Path DEPOT_ENTITY_CONTAINS_DEPOTS = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/entity/:*/depot");
    private static final Path FOLDER_CONTAINS_FOLDERS = new Path("xri://@openmdx*org.opencrx.kernel.document1/provider/:*/segment/:*/folder/:*/subFolder");
    private static final Path MODEL_NAMESPACE_CONTAINS_ELEMENTS = new Path("xri://@openmdx*org.opencrx.kernel.model1/provider/:*/segment/:*/element/:*/content");
    private static final Path GLOBAL_FILTER_INCLUDES_ACTIVITY = new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityFilter/:*/filteredActivity");
    private static final Path GLOBAL_FILTER_INCLUDES_ACCOUNT = new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/:*/segment/:*/accountFilter/:*/filteredAccount");
    private static final Path GLOBAL_FILTER_INCLUDES_ADDRESS = new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/:*/segment/:*/addressFilter/:*/filteredAddress");
    private static final Path GLOBAL_FILTER_INCLUDES_CONTRACT = new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/contractFilter/:*/filteredContract");
    private static final Path GLOBAL_FILTER_INCLUDES_PRODUCT = new Path("xri://@openmdx*org.opencrx.kernel.product1/provider/:*/segment/:*/productFilter/:*/filteredProduct");
    private static final Path GLOBAL_FILTER_INCLUDES_DOCUMENT = new Path("xri://@openmdx*org.opencrx.kernel.document1/provider/:*/segment/:*/documentFilter/:*/filteredDocument");
    private static final Path GLOBAL_FILTER_INCLUDES_SINGLE_BOOKING = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/singleBookingFilter/:*/filteredSingleBooking");
    private static final Path GLOBAL_FILTER_INCLUDES_SIMPLE_BOOKING = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/simpleBookingFilter/:*/filteredSimpleBooking");
    private static final Path GLOBAL_FILTER_INCLUDES_COMPOUND_BOOKING = new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/:*/segment/:*/compoundBookingFilter/:*/filteredCompoundBooking");
    private static final Path ACTIVITY_FILTER_INCLUDES_ACTIVITY = new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/:*/:*/activityFilter/:*/filteredActivity");
    private static final Path CONTRACT_FILTER_INCLUDES_CONTRACT = new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/contractGroup/:*/contractFilter/:*/filteredContract");
    private static final Path PRODUCT_PRICE_LEVEL_HAS_FILTERED_ACCOUNT = new Path("xri://@openmdx*org.opencrx.kernel.product1/provider/:*/segment/:*/priceLevel/:*/filteredAccount");
    private static final Path PRODUCT_PRICE_LEVEL_INCLUDES_FILTERED_PRODUCT = new Path("xri://@openmdx*org.opencrx.kernel.product1/provider/:*/segment/:*/priceLevel/:*/filteredProduct");
    private static final Path PRODUCT_PRICE_LEVEL_HAS_ASSIGNED_PRICE_LIST_ENTRY = new Path("xri://@openmdx*org.opencrx.kernel.product1/provider/:*/segment/:*/priceLevel/:*/priceListEntry");
    private static final Path CONTRACT_POSITION_HAS_MODIFICATION = new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/:*/:*/position/:*/positionModification");
    private static final Path REMOVED_CONTRACT_POSITION_HAS_MODIFICATION = new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/:*/:*/removedPosition/:*/positionModification");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_ACTIVITY = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryActivity");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_ACCOUNT = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryAccount");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_CONTRACT = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryContract");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_PRODUCT = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryProduct");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_DOCUMENT = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryDocument");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_BUILDING = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryBuilding");
    private static final Path OBJECT_FINDER_SELECTS_INDEX_ENTRY_DEPOT = new Path("xri://@openmdx*org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/objectFinder/:*/indexEntryDepot");
    private static final Path SALES_VOLUME_BUDGET_POSITION_INCLUDES_FILTERED_PRODUCT = new Path("xri://@openmdx*org.opencrx.kernel.forecast1/provider/:*/segment/:*/budget/:*/position/:*/filteredProduct");

    public DerivedReferences(DataproviderRequestProcessor dataproviderRequestProcessor, List<String> readOnlyTypes) {
        this.dataproviderRequestProcessor = dataproviderRequestProcessor;
        this.readOnlyTypes = readOnlyTypes;
    }

    public List<String> getReadOnlyTypes() {
        return this.readOnlyTypes;
    }

    public Model_1_0 getModel() {
        return this.model;
    }

    public DataproviderRequestProcessor getDataproviderRequestProcessor() {
        return this.dataproviderRequestProcessor;
    }

    public ObjectRecord retrieveObject(DataproviderRequestProcessor p, Path identity) throws ResourceException {
        return p.addGetRequest(identity, "all");
    }

    public void testObjectIsChangeable(MappedRecord object) throws ServiceException {
        Object_2Facade facade;
        try {
            facade = Object_2Facade.newInstance((MappedRecord)object);
        }
        catch (ResourceException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        String objectClass = facade.getObjectClass();
        for (String type : this.getReadOnlyTypes()) {
            if (!this.getModel().isSubtypeOf((Object)objectClass, (Object)type)) continue;
            for (String attributeName : facade.getValue().keySet()) {
                if ("object_class".equals(attributeName) || "modifiedAt".equals(attributeName) || "modifiedBy".equals(attributeName)) continue;
                throw new ServiceException("OpenCrxDomain", 10003, "Object type is readonly. Can not modify object.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)objectClass)});
            }
        }
    }

    protected QueryRecord remapQuery(QueryRecord request, Path reference, FilterProperty[] additionalFilterProperties, AttributeSpecifier[] additionalAttributeSpecifiers) throws ResourceException {
        QueryRecord mappedQuery = request.clone();
        mappedQuery.setResourceIdentifier(reference);
        if (mappedQuery.getQueryFilter() == null) {
            mappedQuery.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
        }
        if (additionalFilterProperties != null) {
            mappedQuery.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])additionalFilterProperties));
        }
        if (additionalAttributeSpecifiers != null) {
            mappedQuery.getQueryFilter().getOrderSpecifier().addAll(AttributeSpecifier.toOrderSpecifier((AttributeSpecifier[])additionalAttributeSpecifiers));
        }
        return mappedQuery;
    }

    protected QueryRecord remapFindRequest(QueryRecord request, Path reference) throws ResourceException {
        return this.remapQuery(request, reference, null, null);
    }

    protected QueryRecord remapQuery(QueryRecord request, Path reference, FilterProperty[] additionalFilterProperties) throws ResourceException {
        return this.remapQuery(request, reference, additionalFilterProperties, null);
    }

    public boolean getReply(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
        Path path = request.getResourceIdentifier();
        DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
        try {
            if (path.isLike(GLOBAL_FILTER_INCLUDES_ACTIVITY)) {
                ObjectRecord globalFilter = this.retrieveObject(p, path.getPrefix(7));
                Object_2Facade globalFilterFacade = Facades.asObject((MappedRecord)globalFilter);
                Path reference = path.getPrefix(5).getChild("activity");
                if (globalFilterFacade.attributeValue("activitiesSource") != null) {
                    Path activitiesSourceIdentity = (Path)globalFilterFacade.attributeValue("activitiesSource");
                    ObjectRecord activitiesSource = this.retrieveObject(p, activitiesSourceIdentity);
                    Object_2Facade activitiesSourceFacade = Facades.asObject((MappedRecord)activitiesSource);
                    Model_1_0 model = this.getModel();
                    if (model.isSubtypeOf((Object)activitiesSourceFacade.getObjectClass(), (Object)"org:opencrx:kernel:activity1:ActivityGroup")) {
                        reference = activitiesSourceIdentity.getChild("filteredActivity");
                    } else if (model.isSubtypeOf((Object)activitiesSourceFacade.getObjectClass(), (Object)"org:opencrx:kernel:activity1:Segment")) {
                        reference = activitiesSourceIdentity.getChild("activity");
                    } else if (model.isSubtypeOf((Object)activitiesSourceFacade.getObjectClass(), (Object)"org:opencrx:kernel:home1:UserHome")) {
                        reference = activitiesSourceIdentity.getChild("assignedActivity");
                    } else if (model.isSubtypeOf((Object)activitiesSourceFacade.getObjectClass(), (Object)"org:opencrx:kernel:account1:Account")) {
                        reference = activitiesSourceIdentity.getChild("assignedActivity");
                    }
                }
                p.addFindRequest(this.remapQuery(request, reference, this.getActivityFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_ACCOUNT)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("account"), this.getAccountFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_ADDRESS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("address"), this.getAddressFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(ACTIVITY_FILTER_INCLUDES_ACTIVITY)) {
                ArrayList<FilterProperty> filterProperties = new ArrayList<FilterProperty>();
                filterProperties.addAll(Arrays.asList(this.getActivityFilterProperties(path.getPrefix(path.size() - 1))));
                p.addFindRequest(this.remapQuery(request, path.getPrefix(7).getChild("filteredActivity"), filterProperties.toArray(new FilterProperty[filterProperties.size()])), response);
                return true;
            }
            if (path.isLike(CONTRACT_FILTER_INCLUDES_CONTRACT)) {
                ArrayList<FilterProperty> filterProperties = new ArrayList<FilterProperty>();
                filterProperties.addAll(Arrays.asList(this.getContractFilterProperties(path.getPrefix(path.size() - 1))));
                p.addFindRequest(this.remapQuery(request, path.getPrefix(7).getChild("filteredContract"), filterProperties.toArray(new FilterProperty[filterProperties.size()])), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_CONTRACT)) {
                p.addFindRequest(this.remapQuery(request, path, this.getContractFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_PRODUCT)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("product"), this.getProductFilterProperties(path.getPrefix(path.size() - 1), false)), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_DOCUMENT)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("document"), this.getDocumentFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_SINGLE_BOOKING)) {
                p.addFindRequest(this.remapQuery(request, path, this.getBookingFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_SIMPLE_BOOKING)) {
                p.addFindRequest(this.remapQuery(request, path, this.getBookingFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(GLOBAL_FILTER_INCLUDES_COMPOUND_BOOKING)) {
                p.addFindRequest(this.remapQuery(request, path, this.getBookingFilterProperties(path.getPrefix(path.size() - 1))), response);
                return true;
            }
            if (path.isLike(PRODUCT_PRICE_LEVEL_HAS_FILTERED_ACCOUNT)) {
                ArrayList<FilterProperty> filterProperties = new ArrayList<FilterProperty>();
                filterProperties.addAll(Arrays.asList(this.getAccountFilterProperties(path.getPrefix(path.size() - 1))));
                p.addFindRequest(this.remapQuery(request, new Path("xri:@openmdx:org.opencrx.kernel.account1/provider").getDescendant(new String[]{path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "account"}), filterProperties.toArray(new FilterProperty[filterProperties.size()])), response);
                return true;
            }
            if (path.isLike(PRODUCT_PRICE_LEVEL_INCLUDES_FILTERED_PRODUCT) || path.isLike(SALES_VOLUME_BUDGET_POSITION_INCLUDES_FILTERED_PRODUCT)) {
                ArrayList<FilterProperty> filterProperties = new ArrayList<FilterProperty>();
                filterProperties.addAll(Arrays.asList(this.getProductFilterProperties(path.getPrefix(path.size() - 1), false)));
                p.addFindRequest(this.remapQuery(request, new Path("xri://@openmdx*org.opencrx.kernel.product1/provider").getDescendant(new String[]{path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "product"}), filterProperties.toArray(new FilterProperty[filterProperties.size()])), response);
                return true;
            }
            if (path.isLike(PRODUCT_PRICE_LEVEL_HAS_ASSIGNED_PRICE_LIST_ENTRY)) {
                ArrayList<FilterProperty> filterProperties = new ArrayList<FilterProperty>();
                filterProperties.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "priceLevel", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(7)}));
                p.addFindRequest(this.remapQuery(request, new Path("xri:@openmdx:org.opencrx.kernel.product1/provider").getDescendant(new String[]{path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "priceListEntry"}), filterProperties.toArray(new FilterProperty[filterProperties.size()])), response);
                return true;
            }
            if (path.isLike(COMPOUND_BOOKING_HAS_BOOKINGS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("booking"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "cb", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(7)})}), response);
                return true;
            }
            if (path.isLike(DEPOT_POSITION_HAS_BOOKINGS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("booking"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "position", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(13)})}), response);
                return true;
            }
            if (path.isLike(DEPOT_POSITION_HAS_SIMPLE_BOOKINGS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("simpleBooking"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "position", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(13)})}), response);
                return true;
            }
            if (path.isLike(CLASSIFIER_CLASSIFIES_TYPED_ELEMENT)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("element"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "type", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(7)})}), response);
                return true;
            }
            if (path.isLike(DEPOT_REPORT_ITEM_HAS_BOOKING_ITEMS)) {
                ObjectRecord itemPosition = this.retrieveObject(p, path.getParent());
                p.addFindRequest(this.remapQuery(request, path.getPrefix(path.size() - 3).getChild("itemBooking"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "position", ConditionType.IS_IN.code(), new Object[]{Object_2Facade.newInstance((MappedRecord)itemPosition).attributeValue("position")})}), response);
                return true;
            }
            if (path.isLike(DEPOT_GROUP_CONTAINS_DEPOTS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("extent"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "depotGroup", ConditionType.IS_IN.code(), new Object[]{path.getParent()}), new FilterProperty(Quantifier.THERE_EXISTS.code(), "identity", ConditionType.IS_LIKE.code(), new Object[]{path.getPrefix(7).getDescendant(new String[]{"depotHolder", ":*", "depot", ":*"})})}), response);
                return true;
            }
            if (path.isLike(DEPOT_GROUP_CONTAINS_DEPOT_GROUPS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(path.size() - 2), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "parent", ConditionType.IS_IN.code(), new Object[]{path.getParent()})}), response);
                return true;
            }
            if (path.isLike(DEPOT_ENTITY_CONTAINS_DEPOTS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("extent"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "identity", ConditionType.IS_LIKE.code(), new Object[]{path.getParent().getDescendant(new String[]{"depotHolder", ":*", "depot", ":*"})})}), response);
                return true;
            }
            if (path.isLike(FOLDER_CONTAINS_FOLDERS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("folder"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "parent", ConditionType.IS_IN.code(), new Object[]{path.getParent()})}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_ACTIVITY)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:activity1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_ACCOUNT)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:account1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_CONTRACT)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:contract1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_PRODUCT)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:product1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_DOCUMENT)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:document1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_BUILDING)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:building1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(OBJECT_FINDER_SELECTS_INDEX_ENTRY_DEPOT)) {
                Path segmentIdentity = new Path(new String[]{"org:opencrx:kernel:depot1", "provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString()});
                ObjectRecord objectFinder = this.retrieveObject(p, path.getParent());
                FilterProperty[] filter = this.mapObjectFinderToFilter((MappedRecord)objectFinder);
                p.addFindRequest(this.remapQuery(request, segmentIdentity.getChild("indexEntry"), filter, new AttributeSpecifier[]{new AttributeSpecifier("createdAt", SortOrder.DESCENDING.code())}), response);
                return true;
            }
            if (path.isLike(MODEL_NAMESPACE_CONTAINS_ELEMENTS)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(5).getChild("element"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "container", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(7)})}), response);
                return true;
            }
            if (path.isLike(CONTRACT_POSITION_HAS_MODIFICATION) || path.isLike(REMOVED_CONTRACT_POSITION_HAS_MODIFICATION)) {
                p.addFindRequest(this.remapQuery(request, path.getPrefix(7).getChild("positionModification"), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "involved", ConditionType.IS_IN.code(), new Object[]{path.getPrefix(9)})}), response);
                return true;
            }
            return false;
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] mapObjectFinderToFilter(MappedRecord objectFinder) throws ResourceException {
        try {
            String atLeastOneOfTheWords;
            String withoutWords;
            Object_2Facade objectFinderFacade = Facades.asObject((MappedRecord)objectFinder);
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            String allWords = (String)objectFinderFacade.attributeValue("allWords");
            if (allWords != null && allWords.length() > 0) {
                String[] words = allWords.split("[\\s,]");
                for (int i = 0; i < words.length; ++i) {
                    filter.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "keywords", ConditionType.IS_LIKE.code(), new Object[]{".*" + words[i] + ".*"}));
                }
            }
            if ((withoutWords = (String)objectFinderFacade.attributeValue("withoutWords")) != null && withoutWords.length() > 0) {
                String[] words = withoutWords.split("[\\s,]");
                for (int i = 0; i < words.length; ++i) {
                    filter.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "keywords", ConditionType.IS_UNLIKE.code(), new Object[]{".*" + words[i] + ".*"}));
                }
            }
            if ((atLeastOneOfTheWords = (String)objectFinderFacade.attributeValue("atLeastOneOfTheWords")) != null && atLeastOneOfTheWords.length() > 0) {
                String[] words = atLeastOneOfTheWords.split("[\\s,]");
                for (int i = 0; i < words.length; ++i) {
                    words[i] = ".*" + words[i] + ".*";
                }
                filter.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "keywords", ConditionType.IS_LIKE.code(), (Object[])words));
            }
            String queryExtensionId = "context:" + Base.getInstance().getUidAsString() + ":";
            filter.add(new FilterProperty(Quantifier.codeOf(null), queryExtensionId + "clause", ConditionType.codeOf(null), new Object[]{"(v.created_at IN (SELECT MAX(created_at) FROM OOCKE1_INDEXENTRY e WHERE e.indexed_object = v.indexed_object))"}));
            filter.add(new FilterProperty(Quantifier.codeOf(null), queryExtensionId + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getProductFilterProperties(Path productFilterIdentity, boolean forCounting) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(productFilterIdentity.getChild("productFilterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            boolean hasQueryFilterClause = false;
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:product1:ProductQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Products.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), productFilterIdentity.getParent(), "productFilterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    hasQueryFilterClause = true;
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValue("filterQuantor")).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:product1:ProductClassificationFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "classification", filterOperator, filterPropertyFacade.attributeValuesAsList("classification").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:product1:DefaultSalesTaxTypeFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "salesTaxType", filterOperator, filterPropertyFacade.attributeValuesAsList("salesTaxType").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:product1:CategoryFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "category", filterOperator, filterPropertyFacade.attributeValuesAsList("category").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:product1:PriceUomFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "priceUom", filterOperator, filterPropertyFacade.attributeValuesAsList("priceUom").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:product1:DisabledFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
            }
            if (!hasQueryFilterClause && forCounting) {
                String queryFilterContext = "context:" + Products.getInstance().getUidAsString() + ":";
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{"/*!COUNT*/(1=1)"}));
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getContractFilterProperties(Path contractFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(contractFilterIdentity.getChild("filterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:contract1:ContractQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Contracts.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), contractFilterIdentity.getParent(), "filterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValue("filterQuantor")).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:contract1:ContractTypeFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "object_class", filterOperator, filterPropertyFacade.attributeValuesAsList("contractType").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:ContractStateFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "contractState", filterOperator, filterPropertyFacade.attributeValuesAsList("contractState").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:ContractPriorityFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "priority", filterOperator, filterPropertyFacade.attributeValuesAsList("priority").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:TotalAmountFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "totalAmount", filterOperator, filterPropertyFacade.attributeValuesAsList("totalAmount").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:CustomerFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "customer", filterOperator, filterPropertyFacade.attributeValuesAsList("customer").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:SupplierFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "supplier", filterOperator, filterPropertyFacade.attributeValuesAsList("supplier").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:contract1:SalesRepFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "salesRep", filterOperator, filterPropertyFacade.attributeValuesAsList("salesRep").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:contract1:DisabledFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getBookingFilterProperties(Path bookingFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(bookingFilterIdentity.getChild("filterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue() || !"org:opencrx:kernel:depot1:SingleBookingQueryFilterProperty".equals(filterPropertyClass) && !"org:opencrx:kernel:depot1:SimpleBookingQueryFilterProperty".equals(filterPropertyClass) && !"org:opencrx:kernel:depot1:CompoundBookingQueryFilterProperty".equals(filterPropertyClass)) continue;
                String queryFilterContext = "context:" + Contracts.getInstance().getUidAsString() + ":";
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), bookingFilterIdentity.getParent(), "filterProperty")}));
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                values = filterPropertyFacade.attributeValuesAsList("integerParam");
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                values = new ArrayList<Object>();
                for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                    values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                }
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                values = new ArrayList();
                for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                    values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                }
                filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getActivityFilterProperties(Path activityFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(activityFilterIdentity.getChild("filterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                GregorianCalendar date2;
                int j;
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:activity1:ActivityQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Activities.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), activityFilterIdentity.getParent(), "filterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValue("filterQuantor")).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:activity1:ActivityStateFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "activityState", filterOperator, filterPropertyFacade.attributeValuesAsList("activityState").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ScheduledStartFilterProperty".equals(filterPropertyClass)) {
                    if (filterPropertyFacade.attributeValuesAsList("scheduledStart").isEmpty()) {
                        filterPropertyFacade.attributeValuesAsList("scheduledStart").add(DateTimeFormat.BASIC_UTC_FORMAT.format(new Date()));
                    }
                    if (!filterPropertyFacade.attributeValuesAsList("offsetInHours").isEmpty()) {
                        int offsetInHours = ((Number)filterPropertyFacade.attributeValue("offsetInHours")).intValue();
                        for (j = 0; j < filterPropertyFacade.attributeValuesAsList("scheduledStart").size(); ++j) {
                            try {
                                date2 = new GregorianCalendar();
                                date2.setTime(DateTimeFormat.BASIC_UTC_FORMAT.parse((String)filterPropertyFacade.attributeValuesAsList("scheduledStart").get(j)));
                                date2.add(11, offsetInHours);
                                filterPropertyFacade.attributeValuesAsList("scheduledStart").set(j, DateTimeFormat.BASIC_UTC_FORMAT.format(date2.getTime()));
                                continue;
                            }
                            catch (Exception date2) {
                                // empty catch block
                            }
                        }
                    }
                    filter.add(new FilterProperty(filterQuantor, "scheduledStart", filterOperator, filterPropertyFacade.attributeValuesAsList("scheduledStart").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ScheduledEndFilterProperty".equals(filterPropertyClass)) {
                    if (filterPropertyFacade.attributeValuesAsList("scheduledEnd").isEmpty()) {
                        filterPropertyFacade.attributeValuesAsList("scheduledEnd").add(DateTimeFormat.BASIC_UTC_FORMAT.format(new Date()));
                    }
                    if (!filterPropertyFacade.attributeValuesAsList("offsetInHours").isEmpty()) {
                        int offsetInHours = ((Number)filterPropertyFacade.attributeValue("offsetInHours")).intValue();
                        for (j = 0; j < filterPropertyFacade.attributeValuesAsList("scheduledEnd").size(); ++j) {
                            try {
                                date2 = new GregorianCalendar();
                                date2.setTime(DateTimeFormat.BASIC_UTC_FORMAT.parse((String)filterPropertyFacade.attributeValuesAsList("scheduledEnd").get(j)));
                                date2.add(11, offsetInHours);
                                filterPropertyFacade.attributeValuesAsList("scheduledEnd").set(j, DateTimeFormat.BASIC_UTC_FORMAT.format(date2.getTime()));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    filter.add(new FilterProperty(filterQuantor, "scheduledEnd", filterOperator, filterPropertyFacade.attributeValuesAsList("scheduledEnd").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ActivityProcessStateFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "processState", filterOperator, filterPropertyFacade.attributeValuesAsList("processState").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ActivityTypeFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "activityType", filterOperator, filterPropertyFacade.attributeValuesAsList("activityType").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:AssignedToFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "assignedTo", filterOperator, filterPropertyFacade.attributeValuesAsList("contact").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ReportedByContactFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "reportingContact", filterOperator, filterPropertyFacade.attributeValuesAsList("contact").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ReportedByAccountFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "reportingAccount", filterOperator, filterPropertyFacade.attributeValuesAsList("account").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:activity1:ActivityNumberFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "activityNumber", filterOperator, filterPropertyFacade.attributeValuesAsList("activityNumber").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:activity1:DisabledFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getDocumentFilterProperties(Path documentFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(documentFilterIdentity.getChild("filterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:document1:DocumentQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Activities.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), documentFilterIdentity.getParent(), "filterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValue("filterQuantor")).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:document1:DocumentStateFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "documentState", filterOperator, filterPropertyFacade.attributeValuesAsList("documentState").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:document1:DocumentTypeFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "documentType", filterOperator, filterPropertyFacade.attributeValuesAsList("documentType").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:document1:DocumentFolderFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "folder", filterOperator, filterPropertyFacade.attributeValuesAsList("documentFolder").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:document1:DocumentNameFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "name", filterOperator, filterPropertyFacade.attributeValuesAsList("namePattern").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:document1:DocumentLanguageFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "contentLanguage", filterOperator, filterPropertyFacade.attributeValuesAsList("contentLanguage").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:document1:DisabledFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getAddressFilterProperties(Path addressFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(addressFilterIdentity.getChild("addressFilterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:account1:AddressQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Accounts.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), addressFilterIdentity.getParent(), "addressFilterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValuesAsList("filterQuantor").get(0)).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:account1:AddressCategoryFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "category", filterOperator, filterPropertyFacade.attributeValuesAsList("category").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:AddressTypeFilterProperty".equals(filterPropertyClass)) {
                    ArrayList<String> addressTypes = new ArrayList<String>();
                    Iterator j = filterPropertyFacade.attributeValuesAsList("addressType").iterator();
                    while (j.hasNext()) {
                        int addressType = ((Number)j.next()).intValue();
                        addressTypes.add(Addresses.ADDRESS_TYPES[addressType]);
                    }
                    filter.add(new FilterProperty(filterQuantor, "object_instanceof", filterOperator, addressTypes.toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:AddressMainFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "isMain", filterOperator, filterPropertyFacade.attributeValuesAsList("isMain").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:AddressUsageFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "usage", filterOperator, filterPropertyFacade.attributeValuesAsList("usage").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:AddressDisabledFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:account1:AddressAccountMembershipFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "account", ConditionType.IS_IN.code(), new Object[]{new Filter(new Condition[]{new IsInCondition(Quantifier.THERE_EXISTS, "accountMembership", true, new Object[]{new Filter(new Condition[]{new IsInCondition(Quantifier.valueOf((short)filterQuantor), "accountFrom", filterOperator == ConditionType.IS_IN.code(), filterPropertyFacade.attributeValuesAsList("account").toArray()), new IsInCondition(Quantifier.FOR_ALL, "distance", true, new Object[]{(short)-1})})})})}));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public String resolveQueryClause(String clause, Path filterReference, String propertyKind) throws ResourceException {
        try {
            int placeHolderStart;
            int placeHolderEnd;
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            while ((placeHolderEnd = clause.indexOf("}", placeHolderStart = clause.indexOf("${"))) > placeHolderStart) {
                String replacement = "(null=null)";
                String[] placeHolder = clause.substring(placeHolderStart + 2, placeHolderEnd).split("(?<!\\\\)\\.");
                if (placeHolder.length == 2) {
                    String filterName = placeHolder[0].replace("\\.", ".");
                    Object_2Facade filter = null;
                    if (filterName.startsWith("\"")) {
                        filterName = (filterName = filterName.substring(1)).endsWith("\"") ? filterName.substring(0, filterName.length() - 1) : filterName;
                        ResultRecord filterFindReply = p.addFindRequest(filterReference, new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "name", ConditionType.IS_IN.code(), new Object[]{filterName})});
                        if (!filterFindReply.isEmpty()) {
                            filter = Facades.asObject((MappedRecord)((ObjectRecord)filterFindReply.get(0)));
                        }
                    } else {
                        try {
                            filter = Facades.asObject((MappedRecord)this.retrieveObject(p, filterReference.getChild(filterName)));
                        }
                        catch (Exception filterFindReply) {
                            // empty catch block
                        }
                    }
                    if (filter != null) {
                        String filterPropertyName = placeHolder[1].replace("\\.", ".");
                        Object_2Facade filterProperty = null;
                        if (filterPropertyName.startsWith("\"")) {
                            filterPropertyName = (filterPropertyName = filterPropertyName.substring(1)).endsWith("\"") ? filterPropertyName.substring(0, filterPropertyName.length() - 1) : filterPropertyName;
                            ResultRecord filterPropertyFindReply = p.addFindRequest(filter.getPath().getChild(propertyKind), new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "name", ConditionType.IS_IN.code(), new Object[]{filterPropertyName})});
                            if (!filterPropertyFindReply.isEmpty()) {
                                filterProperty = Facades.asObject((MappedRecord)((ObjectRecord)filterPropertyFindReply.get(0)));
                            }
                        } else {
                            try {
                                try {
                                    filterProperty = Facades.asObject((MappedRecord)this.retrieveObject(p, filter.getPath().getDescendant(new String[]{propertyKind, filterPropertyName})));
                                }
                                catch (Exception exception) {}
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (filterProperty != null && filterProperty.attributeValue("clause") != null) {
                            replacement = this.resolveQueryClause((String)filterProperty.attributeValue("clause"), filterReference, propertyKind);
                        }
                    }
                }
                clause = clause.substring(0, placeHolderStart) + replacement + clause.substring(placeHolderEnd + 1);
            }
            return clause;
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public FilterProperty[] getAccountFilterProperties(Path accountFilterIdentity) throws ResourceException {
        try {
            DataproviderRequestProcessor p = this.getDataproviderRequestProcessor();
            ResultRecord filterProperties = p.addFindRequest(accountFilterIdentity.getChild("accountFilterProperty"), "all");
            ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
            for (Object filterProperty : filterProperties) {
                Object_2Facade filterPropertyFacade = Facades.asObject((MappedRecord)((ObjectRecord)filterProperty));
                String filterPropertyClass = filterPropertyFacade.getObjectClass();
                Boolean isActive = (Boolean)filterPropertyFacade.attributeValue("isActive");
                if (isActive == null || !isActive.booleanValue()) continue;
                if ("org:opencrx:kernel:account1:AccountQueryFilterProperty".equals(filterPropertyClass)) {
                    String queryFilterContext = "context:" + Accounts.getInstance().getUidAsString() + ":";
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "clause", ConditionType.codeOf(null), new Object[]{this.resolveQueryClause((String)filterPropertyFacade.attributeValue("clause"), accountFilterIdentity.getParent(), "accountFilterProperty")}));
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "object_class", ConditionType.codeOf(null), new Object[]{"org:openmdx:compatibility:datastore1:QueryFilter"}));
                    ArrayList<Object> values = filterPropertyFacade.attributeValuesAsList("stringParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "stringParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("integerParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "integerParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("decimalParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "decimalParam", ConditionType.codeOf(null), values.toArray()));
                    values = filterPropertyFacade.attributeValuesAsList("booleanParam");
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "booleanParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList<Object>();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateParam")) {
                        values.add(Datatypes.create(XMLGregorianCalendar.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateParam", ConditionType.codeOf(null), values.toArray()));
                    values = new ArrayList();
                    for (Object value : filterPropertyFacade.attributeValuesAsList("dateTimeParam")) {
                        values.add(Datatypes.create(Date.class, (Object[])new Object[]{value}));
                    }
                    filter.add(new FilterProperty(Quantifier.codeOf(null), queryFilterContext + "dateTimeParam", ConditionType.codeOf(null), values.toArray()));
                    continue;
                }
                short filterOperator = filterPropertyFacade.attributeValuesAsList("filterOperator").isEmpty() ? ConditionType.IS_IN.code() : ((Number)filterPropertyFacade.attributeValue("filterOperator")).shortValue();
                filterOperator = filterOperator == 0 ? ConditionType.IS_IN.code() : filterOperator;
                short filterQuantor = filterPropertyFacade.attributeValuesAsList("filterQuantor").isEmpty() ? Quantifier.THERE_EXISTS.code() : ((Number)filterPropertyFacade.attributeValue("filterQuantor")).shortValue();
                short s = filterQuantor = filterQuantor == 0 ? Quantifier.THERE_EXISTS.code() : filterQuantor;
                if ("org:opencrx:kernel:account1:AccountTypeFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "accountType", filterOperator, filterPropertyFacade.attributeValuesAsList("accountType").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:AccountCategoryFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "accountCategory", filterOperator, filterPropertyFacade.attributeValuesAsList("accountCategory").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:CategoryFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "category", filterOperator, filterPropertyFacade.attributeValuesAsList("category").toArray()));
                    continue;
                }
                if ("org:opencrx:kernel:account1:DisabledFilterProperty".equals(filterPropertyClass)) {
                    filter.add(new FilterProperty(filterQuantor, "disabled", filterOperator, filterPropertyFacade.attributeValuesAsList("disabled").toArray()));
                    continue;
                }
                if (!"org:opencrx:kernel:account1:AccountMembershipFilterProperty".equals(filterPropertyClass)) continue;
                filter.add(new FilterProperty(Quantifier.THERE_EXISTS.code(), "accountMembership", ConditionType.IS_IN.code(), new Object[]{new Filter(new Condition[]{new IsInCondition(Quantifier.valueOf((short)filterQuantor), "accountFrom", filterOperator == ConditionType.IS_IN.code(), filterPropertyFacade.attributeValuesAsList("account").toArray()), new IsInCondition(Quantifier.FOR_ALL, "distance", true, new Object[]{(short)-1})})}));
            }
            return filter.toArray(new FilterProperty[filter.size()]);
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }
}

