/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.depot1.aop2;

import java.util.ArrayList;
import javax.jdo.JDOUserException;
import javax.jdo.listener.DeleteCallback;
import org.opencrx.kernel.backend.Depots;
import org.opencrx.kernel.depot1.cci2.DepotHolder;
import org.opencrx.kernel.depot1.cci2.OpenDepotResult;
import org.opencrx.kernel.depot1.jmi1.AssertReportsParams;
import org.opencrx.kernel.depot1.jmi1.Depot;
import org.opencrx.kernel.depot1.jmi1.DepotPosition;
import org.opencrx.kernel.depot1.jmi1.OpenDepotParams;
import org.opencrx.kernel.depot1.jmi1.OpenDepotResult;
import org.openmdx.base.accessor.jmi.cci.JmiServiceException;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.aop2.AbstractObject;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.Void;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class DepotHolderImpl<S extends org.opencrx.kernel.depot1.jmi1.DepotHolder, N extends DepotHolder, C extends java.lang.Void>
extends AbstractObject<S, N, C>
implements DeleteCallback {
    public DepotHolderImpl(S same, N next) {
        super(same, next);
    }

    public OpenDepotResult openDepot(OpenDepotParams params) {
        try {
            ArrayList<String> errors = new ArrayList<String>();
            Depot depot = Depots.getInstance().openDepot((org.opencrx.kernel.depot1.jmi1.DepotHolder)this.sameObject(), params.getName(), params.getDescription(), params.getDepotNumber(), params.getOpeningDate(), params.getDepotType(), params.getDepotGroup(), errors);
            if (depot == null) {
                return (OpenDepotResult)Structures.create(OpenDepotResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)OpenDepotResult.Member.depot, null), Datatypes.member((Enum)OpenDepotResult.Member.status, (Object)1), Datatypes.member((Enum)OpenDepotResult.Member.statusMessage, (Object)((Object)errors).toString())});
            }
            return (OpenDepotResult)Structures.create(OpenDepotResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)OpenDepotResult.Member.depot, (Object)depot), Datatypes.member((Enum)OpenDepotResult.Member.status, (Object)0), Datatypes.member((Enum)OpenDepotResult.Member.statusMessage, null)});
        }
        catch (ServiceException e) {
            throw new JmiServiceException((Throwable)e);
        }
    }

    public Void assertReports(AssertReportsParams params) {
        try {
            ArrayList depots = new ArrayList(((org.opencrx.kernel.depot1.jmi1.DepotHolder)this.sameObject()).getDepot());
            ArrayList<DepotPosition> includePositions = new ArrayList<DepotPosition>();
            if (params.getIncludePosition0() != null) {
                includePositions.add(params.getIncludePosition0());
            }
            if (params.getIncludePosition1() != null) {
                includePositions.add(params.getIncludePosition1());
            }
            if (params.getIncludePosition2() != null) {
                includePositions.add(params.getIncludePosition2());
            }
            ArrayList<DepotPosition> excludePositions = new ArrayList<DepotPosition>();
            if (params.getExcludePosition0() != null) {
                includePositions.add(params.getExcludePosition0());
            }
            if (params.getExcludePosition1() != null) {
                includePositions.add(params.getExcludePosition1());
            }
            if (params.getExcludePosition2() != null) {
                includePositions.add(params.getExcludePosition2());
            }
            for (Depot depot : depots) {
                Depots.getInstance().assertReports(depot, params.getBookingStatusThreshold(), includePositions, excludePositions);
            }
            return super.newVoid();
        }
        catch (ServiceException e) {
            throw new JmiServiceException((Throwable)e);
        }
    }

    public void jdoPreDelete() {
        try {
            Depots.getInstance().preDelete((RefObject_1_0)this.sameObject(), true);
            super.jdoPreDelete();
        }
        catch (ServiceException e) {
            throw new JDOUserException("jdoPreDelete failed", (Throwable)e, (Object)this.sameObject());
        }
    }
}

