/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.cci2.AccountHasAccountAddress;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.cci2.EMailAddressQuery;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.base.cci2.ImportItemParams;
import org.opencrx.kernel.base.jmi1.ImportItemParams;
import org.opencrx.kernel.code1.jmi1.Segment;
import org.opencrx.kernel.generic.jmi1.Media;
import org.opencrx.kernel.generic.jmi1.Note;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Codes;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class VCard
extends AbstractImpl {
    public static final Map<Integer, String> salutations = new HashMap<Integer, String>();
    public static final String DATETIME_FORMAT = "yyyyMMdd'T'HHmmss";
    public static final String MIME_TYPE = "text/x-vcard";
    public static final String FILE_EXTENSION = ".vcf";
    public static final String PROD_ID = "//OPENCRX//V3//EN";
    public static final int MIME_TYPE_CODE = 3;
    public static final short DEFAULT_LOCALE = 0;
    public static final String VCARD_SCHEMA = "VCARD:";

    public static void register() {
        VCard.registerImpl(new VCard());
    }

    public static VCard getInstance() throws ServiceException {
        return VCard.getInstance(VCard.class);
    }

    protected VCard() {
    }

    protected String escapeNewlines(String from) {
        String to = "";
        for (int i = 0; i < from.length(); ++i) {
            to = from.charAt(i) == '\n' ? to + "\\n" : to + from.charAt(i);
        }
        return to;
    }

    protected String getUtcDateTime(String dateTime, SimpleDateFormat dateTimeFormatter) throws ParseException {
        Date date = null;
        date = dateTime.endsWith("Z") ? (dateTime.length() == 16 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime.substring(0, 15) + ".000Z") : DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime)) : (dateTime.length() == 8 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime + "T000000.000Z") : dateTimeFormatter.parse(dateTime));
        return DateTimeFormat.BASIC_UTC_FORMAT.format(date);
    }

    protected Date getUtcDate(String dateTime, SimpleDateFormat dateTimeFormatter) throws ParseException {
        Date date = null;
        date = dateTime.endsWith("Z") ? (dateTime.length() == 16 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime.substring(0, 15) + ".000Z") : DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime)) : (dateTime.length() == 8 ? DateTimeFormat.BASIC_UTC_FORMAT.parse(dateTime + "T000000.000Z") : dateTimeFormatter.parse(dateTime));
        return date;
    }

    protected String encodeString(String s) {
        if (s == null) {
            return s;
        }
        s = s.replace(";", "\\;");
        return s;
    }

    private String mapToSalutationText(short salutationCode) throws ServiceException {
        return salutations.get(salutationCode);
    }

    private short mapToSalutationCode(String salutation, Segment codeSegment) throws ServiceException {
        if (codeSegment != null) {
            try {
                Codes codes = new Codes((RefObject_1_0)codeSegment);
                return codes.findCodeFromValue(salutation, "org:opencrx:kernel:account1:Contact:salutationCode");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Map.Entry<Integer, String> entry : salutations.entrySet()) {
            if (!entry.getValue().equals(salutation)) continue;
            return entry.getKey().shortValue();
        }
        return 0;
    }

    public String mergeVcard(Account account, String sourceVcard, List<String> statusMessage) throws ServiceException {
        String emailHome;
        AccountAddress[] addresses;
        String note;
        String bday;
        String title;
        String org;
        String rev;
        String nickName;
        String fn;
        String n;
        boolean isContact;
        Segment codeSegment;
        block55: {
            Contact contact;
            Contact contact2;
            Contact contact3;
            AbstractGroup group;
            String firstName;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
            codeSegment = null;
            try {
                codeSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", account.refGetPath().getSegment(2).toString(), "segment", "Root"}));
            }
            catch (Exception exception) {
                // empty catch block
            }
            isContact = account instanceof Contact;
            n = null;
            if (isContact) {
                Contact contact4 = (Contact)account;
                if (contact4.getLastName() != null) {
                    String lastName = contact4.getLastName();
                    firstName = contact4.getFirstName() == null ? "" : contact4.getFirstName();
                    String middleName = contact4.getMiddleName() == null ? "" : contact4.getMiddleName();
                    Short salutationCode = contact4.getSalutationCode();
                    String salutation = contact4.getSalutation() == null ? (salutationCode == null || salutationCode == 0 ? null : this.mapToSalutationText(salutationCode)) : contact4.getSalutation();
                    String suffix = contact4.getSuffix() == null ? "" : contact4.getSuffix();
                    n = lastName + ";" + firstName + ";" + middleName + ";" + (salutation == null ? "" : salutation) + ";" + suffix;
                }
            } else if (account instanceof AbstractGroup && (group = (AbstractGroup)account).getName() != null) {
                String name;
                n = name = group.getName();
            }
            fn = null;
            if (isContact) {
                Contact contact5 = (Contact)account;
                firstName = contact5.getFirstName() == null ? "" : contact5.getFirstName();
                String lastName = contact5.getLastName() == null ? "" : contact5.getLastName();
                String middleName = contact5.getMiddleName() == null ? "" : contact5.getMiddleName();
                String suffix = contact5.getSuffix() == null ? "" : contact5.getSuffix();
                fn = firstName + (middleName.length() == 0 ? "" : " " + middleName) + (lastName.length() == 0 ? "" : " " + lastName) + (suffix.length() == 0 ? "" : " " + suffix);
            } else {
                String fullName;
                fn = fullName = account.getFullName() == null ? "" : account.getFullName();
            }
            nickName = null;
            if (isContact) {
                Contact contact6 = (Contact)account;
                nickName = contact6.getNickName() == null ? "" : contact6.getNickName();
            }
            rev = DateTimeFormat.BASIC_UTC_FORMAT.format(new Date());
            org = null;
            if (isContact && (contact3 = (Contact)account).getOrganization() != null) {
                org = contact3.getOrganization();
            }
            title = null;
            if (isContact && (contact2 = (Contact)account).getJobTitle() != null) {
                title = contact2.getJobTitle();
            }
            bday = null;
            if (isContact && (contact = (Contact)account).getBirthdate() != null) {
                bday = DateTimeFormat.BASIC_UTC_FORMAT.format(contact.getBirthdate());
            }
            note = "";
            try {
                Note aNote;
                if (!JDOHelper.isNew((Object)account) && (aNote = (Note)pm.getObjectById((Object)account.refGetPath().getDescendant(new String[]{"note", "VCARD"}))) != null) {
                    note = aNote.getText();
                }
            }
            catch (Exception aNote) {
                // empty catch block
            }
            addresses = new AccountAddress[11];
            try {
                addresses = Accounts.getInstance().getMainAddresses(account);
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e);
                if (e0.getExceptionCode() == -34) break block55;
                throw e0;
            }
        }
        String telWorkVoice = addresses[2] == null ? "" : ((PhoneNumber)addresses[2]).getPhoneNumberFull();
        String telHomeVoice = addresses[3] == null ? "" : ((PhoneNumber)addresses[3]).getPhoneNumberFull();
        String telCellVoice = addresses[10] == null ? "" : ((PhoneNumber)addresses[10]).getPhoneNumberFull();
        String telWorkFax = addresses[4] == null ? "" : ((PhoneNumber)addresses[4]).getPhoneNumberFull();
        String telHomeFax = addresses[5] == null ? "" : ((PhoneNumber)addresses[5]).getPhoneNumberFull();
        String adrWork = "";
        if (addresses[6] != null) {
            PostalAddress postalAddress = (PostalAddress)addresses[6];
            StringBuilder adr = new StringBuilder();
            List addressLines = postalAddress.getPostalAddressLine();
            for (int j = 0; j < addressLines.size(); ++j) {
                adr.append(adr.length() == 0 ? "" : "\\n");
                adr.append(this.encodeString((String)addressLines.get(j)));
            }
            List postalStreet = postalAddress.getPostalStreet();
            for (int j = 0; j < postalStreet.size(); ++j) {
                adr.append(adr.length() == 0 ? "" : "\\n");
                adr.append(this.encodeString((String)postalStreet.get(j)));
            }
            adr.append(postalAddress.getPostalCity() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalCity()));
            adr.append(postalAddress.getPostalState() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalState()));
            adr.append(postalAddress.getPostalCode() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalCode()));
            adr.append(";");
            String[] postalCountry = Addresses.getInstance().mapToPostalCountryText(postalAddress.getPostalCountry(), codeSegment);
            adr.append(postalCountry == null ? "" : postalCountry[0]);
            adrWork = adr.toString();
        }
        String adrHome = "";
        if (addresses[8] != null) {
            PostalAddress postalAddress = (PostalAddress)addresses[8];
            StringBuilder adr = new StringBuilder();
            List addressLines = postalAddress.getPostalAddressLine();
            for (int j = 0; j < addressLines.size(); ++j) {
                adr.append(adr.length() == 0 ? "" : "\\n");
                adr.append(this.encodeString((String)addressLines.get(j)));
            }
            List postalStreet = postalAddress.getPostalStreet();
            for (int j = 0; j < postalStreet.size(); ++j) {
                adr.append(adr.length() == 0 ? "" : "\\n");
                adr.append(this.encodeString((String)postalStreet.get(j)));
            }
            adr.append(postalAddress.getPostalCity() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalCity()));
            adr.append(postalAddress.getPostalState() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalState()));
            adr.append(postalAddress.getPostalCode() == null ? ";" : ";" + this.encodeString(postalAddress.getPostalCode()));
            adr.append(";");
            String[] postalCountry = Addresses.getInstance().mapToPostalCountryText(postalAddress.getPostalCountry(), codeSegment);
            adr.append(postalCountry == null ? "" : postalCountry[0]);
            adrHome = adr.toString();
        }
        String urlWork = addresses[7] == null ? "" : ((WebAddress)addresses[7]).getWebUrl();
        String urlHome = addresses[9] == null ? "" : ((WebAddress)addresses[9]).getWebUrl();
        String emailWork = addresses[0] == null ? "" : ((EMailAddress)addresses[0]).getEmailAddress();
        String string = emailHome = addresses[1] == null ? "" : ((EMailAddress)addresses[1]).getEmailAddress();
        if (!statusMessage.isEmpty()) {
            return null;
        }
        if (sourceVcard == null || sourceVcard.isEmpty()) {
            UUID uid = null;
            try {
                uid = UUIDConversion.fromString((String)account.refGetPath().getLastSegment().toString());
            }
            catch (Exception e) {
                uid = UUIDs.newUUID();
            }
            sourceVcard = "BEGIN:VCARD\nVERSION:3.0\nUID:" + UUIDConversion.toUID((UUID)uid) + "\nREV:" + rev.substring(0, 15) + "Z\nN:\nFN:\nNICKNAME:\nORG:\nTITLE:\nTEL;WORK;VOICE:\nTEL;HOME;VOICE:\nTEL;CELL;VOICE:\n" + (isContact ? "BDAY:\n" : "") + "TEL;FAX:\nTEL;HOME;FAX:\nADR;WORK:;;\nADR;HOME:;;\nURL;HOME:\nURL;WORK:\nEMAIL;TYPE=PREF,INTERNET,WORK:\nEMAIL;TYPE=INTERNET,HOME:\nNOTE:\nEND:VCARD";
        }
        try {
            QuotaByteArrayOutputStream targetVcardBos = new QuotaByteArrayOutputStream(VCard.class.getName());
            PrintWriter targetVcard = new PrintWriter(new OutputStreamWriter((OutputStream)targetVcardBos, "UTF-8"));
            String line = null;
            BufferedReader readerSourceVcard = new BufferedReader(new StringReader(sourceVcard));
            boolean isVcard = false;
            String tagStart = null;
            while ((line = readerSourceVcard.readLine()) != null) {
                if (!line.startsWith(" ")) {
                    tagStart = line;
                }
                if (line.toUpperCase().startsWith("BEGIN:VCARD")) {
                    targetVcard.println("BEGIN:VCARD");
                    isVcard = true;
                    continue;
                }
                if (line.toUpperCase().startsWith("END:VCARD")) {
                    if (rev != null) {
                        targetVcard.println("REV:" + rev.substring(0, 15) + "Z");
                    }
                    if (n != null && !n.isEmpty()) {
                        targetVcard.println("N:" + n);
                    }
                    if (fn != null && !fn.isEmpty()) {
                        targetVcard.println("FN:" + fn);
                    }
                    if (nickName != null && !nickName.isEmpty()) {
                        targetVcard.println("NICKNAME:" + nickName);
                    }
                    if (org != null && !org.isEmpty()) {
                        targetVcard.println("ORG:" + org);
                    }
                    if (title != null && !title.isEmpty()) {
                        targetVcard.println("TITLE:" + title);
                    }
                    if (bday != null && !bday.isEmpty()) {
                        targetVcard.println("BDAY:" + bday.substring(0, 15) + "Z");
                    }
                    if (note != null && !note.isEmpty()) {
                        targetVcard.println("NOTE:" + this.escapeNewlines(note));
                    }
                    if (telWorkVoice != null && !telWorkVoice.isEmpty()) {
                        targetVcard.println("TEL;WORK;VOICE:" + telWorkVoice);
                    }
                    if (telHomeVoice != null && !telHomeVoice.isEmpty()) {
                        targetVcard.println("TEL;HOME;VOICE:" + telHomeVoice);
                    }
                    if (telCellVoice != null && !telCellVoice.isEmpty()) {
                        targetVcard.println("TEL;CELL;VOICE:" + telCellVoice);
                    }
                    if (telWorkFax != null && !telWorkFax.isEmpty()) {
                        targetVcard.println("TEL;FAX;WORK:" + telWorkFax);
                    }
                    if (telHomeFax != null && !telHomeFax.isEmpty()) {
                        targetVcard.println("TEL;HOME;FAX:" + telHomeFax);
                    }
                    if (adrWork != null && !adrWork.isEmpty()) {
                        targetVcard.println("ADR;WORK:;;" + adrWork);
                    }
                    if (adrHome != null && !adrHome.isEmpty()) {
                        targetVcard.println("ADR;HOME:;;" + adrHome);
                    }
                    if (urlHome != null && !urlHome.isEmpty()) {
                        targetVcard.println("URL;HOME:" + urlHome);
                    }
                    if (urlWork != null && !urlWork.isEmpty()) {
                        targetVcard.println("URL;WORK:" + urlWork);
                    }
                    if (emailWork != null && !emailWork.isEmpty()) {
                        targetVcard.println("EMAIL;TYPE=PREF,INTERNET,WORK:" + emailWork);
                    }
                    if (emailHome != null && !emailHome.isEmpty()) {
                        targetVcard.println("EMAIL;TYPE=INTERNET,HOME:" + emailHome);
                    }
                    targetVcard.println("END:VCARD");
                    isVcard = false;
                    continue;
                }
                if (isVcard) {
                    boolean isUpdatableTag = tagStart.toUpperCase().startsWith("REV");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("N");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("FN");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("NICKNAME");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("ORG");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("TITLE");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("BDAY");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("TEL");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("ADR");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("URL");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("EMAIL");
                    isUpdatableTag |= tagStart.toUpperCase().startsWith("PHOTO");
                    if (isUpdatableTag |= tagStart.toUpperCase().startsWith("NOTE")) continue;
                    targetVcard.println(line);
                    continue;
                }
                targetVcard.println(line);
            }
            targetVcard.flush();
            targetVcardBos.close();
            try {
                return targetVcardBos.toString("UTF-8");
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean updatePostalAddress(PostalAddress address, String newValue, short locale, Segment codeSegment) throws ServiceException {
        boolean modified = false;
        if (newValue != null && newValue.length() > 0) {
            int i;
            String[] tokens = new String[]{"", "", "", "", "", "", ""};
            newValue = newValue.replace("\\;", "\u0001");
            newValue = newValue.replace(";", "\t");
            newValue = newValue.replace("\u0001", ";");
            StringTokenizer tokenizer = new StringTokenizer(newValue, "\t", true);
            int ii = 0;
            boolean hasTokens = false;
            while (tokenizer.hasMoreTokens() && ii < tokens.length) {
                String t = tokenizer.nextToken();
                if ("\t".equals(t)) {
                    ++ii;
                    continue;
                }
                tokens[ii] = t;
                hasTokens = true;
            }
            if (!hasTokens) {
                return false;
            }
            ArrayList<String> street = new ArrayList<String>();
            String temp = tokens[2];
            int pos = 0;
            if (temp.indexOf("=0D=0A") >= 0) {
                while ((pos = temp.indexOf("=0D=0A")) >= 0) {
                    street.add(temp.substring(0, pos));
                    temp = temp.substring(pos + 6);
                }
            } else if (temp.indexOf("\\n") >= 0) {
                while ((pos = temp.indexOf("\\n")) >= 0) {
                    street.add(temp.substring(0, pos));
                    temp = temp.substring(pos + 2);
                }
            }
            street.add(temp);
            address.getPostalAddressLine().clear();
            int nPostalAddressLines = Math.min(2, street.size() - 1);
            for (i = 0; i < nPostalAddressLines; ++i) {
                address.getPostalAddressLine().add(street.get(i));
            }
            address.getPostalStreet().clear();
            for (i = nPostalAddressLines; i < street.size(); ++i) {
                address.getPostalStreet().add(street.get(i));
                modified = true;
            }
            if (!tokens[3].equals(address.getPostalCity())) {
                address.setPostalCity(tokens[3]);
                modified = true;
            }
            if (!tokens[4].equals(address.getPostalState())) {
                address.setPostalState(tokens[4]);
                modified = true;
            }
            if (!tokens[5].equals(address.getPostalCode())) {
                address.setPostalCode(tokens[5]);
                modified = true;
            }
            SysLog.trace((String)"lookup country", (Object)tokens[6]);
            short postalCountry = Addresses.getInstance().mapToPostalCountryCode(tokens[6], codeSegment);
            if (postalCountry != address.getPostalCountry()) {
                address.setPostalCountry(postalCountry);
                modified = true;
            }
            SysLog.trace((String)"updated address", (Object)address);
            return true;
        }
        return modified;
    }

    public boolean updatePhoneNumber(PhoneNumber address, String newValue) throws ServiceException {
        if (newValue != null && newValue.length() > 0) {
            String normalizedPhoneNumberNew = "";
            for (int i = 0; i < newValue.length(); ++i) {
                char c = newValue.charAt(i);
                if (c == ' ' || c == '(' || c == ')' || c == '-') continue;
                normalizedPhoneNumberNew = normalizedPhoneNumberNew + c;
            }
            String normalizedPhoneNumber = "";
            if (address.getPhoneNumberFull() != null) {
                String phoneNumber = address.getPhoneNumberFull();
                for (int i = 0; i < phoneNumber.length(); ++i) {
                    char c = phoneNumber.charAt(i);
                    if (c == ' ' || c == '(' || c == ')' || c == '-') continue;
                    normalizedPhoneNumber = normalizedPhoneNumber + c;
                }
            }
            if (!normalizedPhoneNumberNew.equals(normalizedPhoneNumber)) {
                address.setPhoneNumberFull(newValue);
            }
            address.setAutomaticParsing(Boolean.TRUE);
            Addresses.getInstance().updatePhoneNumber(address);
            SysLog.trace((String)"updated address", (Object)address);
            return true;
        }
        return false;
    }

    public boolean updateWebAddress(WebAddress address, String newValue) {
        if (newValue != null && newValue.length() > 0) {
            address.setWebUrl(newValue);
            SysLog.trace((String)"updated address", (Object)address);
            return true;
        }
        return false;
    }

    public boolean updateEMailAddress(EMailAddress address, String newValue) {
        if (newValue != null && newValue.length() > 0) {
            address.setEmailAddress(newValue);
            SysLog.trace((String)"updated address", (Object)address);
            return true;
        }
        return false;
    }

    public String getVCardUid(String vcard) {
        int start;
        int end;
        String uid = null;
        if (vcard.indexOf("UID:") > 0 && (end = vcard.indexOf("\n", start = vcard.indexOf("UID:"))) > start) {
            uid = vcard.substring(start + 4, end).trim();
        }
        return uid;
    }

    public Map<String, VCardField> parseVCard(BufferedReader reader, StringBuilder vcardAsString) throws IOException {
        int pos;
        HashMap<String, VCardField> vcard = new HashMap<String, VCardField>();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String s = null;
            while ((s = reader.readLine()) != null) {
                lines.add(s);
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        int l = 0;
        while (l < lines.size()) {
            String line = (String)lines.get(l++);
            while (l < lines.size() && (((String)lines.get(l)).startsWith(" ") || line.endsWith("=") && (line.length() - 1) % 62 == 0)) {
                if (line.endsWith("=") && (line.length() - 1) % 62 == 0) {
                    line = line.substring(0, 62) + (String)lines.get(l++);
                    continue;
                }
                line = line + ((String)lines.get(l++)).substring(1);
            }
            vcardAsString.append(line).append("\n");
            int pos2 = line.indexOf(":");
            if (pos2 < 0) continue;
            String qualifiedFieldName = line.substring(0, pos2).toUpperCase();
            String[] fieldNameParts = qualifiedFieldName.split(";");
            HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
            for (int i = 1; i < fieldNameParts.length; ++i) {
                String fieldNamePart = fieldNameParts[i];
                String parameterName = "TYPE";
                String[] parameterValues = new String[]{};
                if (fieldNamePart.indexOf("=") > 0) {
                    int index = fieldNamePart.indexOf("=");
                    parameterName = fieldNamePart.substring(0, index);
                    parameterValues = fieldNamePart.substring(index + 1).split(",");
                } else {
                    parameterName = "TYPE";
                    parameterValues = fieldNamePart.split(",");
                }
                if (parameters.get(parameterName) != null) {
                    ((List)parameters.get(parameterName)).addAll(Arrays.asList(parameterValues));
                    continue;
                }
                parameters.put(parameterName, new ArrayList<String>(Arrays.asList(parameterValues)));
            }
            vcard.put(qualifiedFieldName, new VCardField(fieldNameParts[0], line.substring(pos2 + 1, line.length()), parameters));
        }
        if (this.getVCardUid(vcardAsString.toString()) == null && (pos = vcardAsString.indexOf("BEGIN:VCARD")) >= 0) {
            String uid = this.getUidAsString();
            vcardAsString.replace(pos, pos + 11, "BEGIN:VCARD\nUID:" + uid);
            vcard.put("UID", new VCardField("UID", uid, Collections.emptyMap()));
        }
        return vcard;
    }

    public BasicObject importItem(byte[] item, Account account, short locale, List<String> errors, List<String> report) throws ServiceException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(item);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            StringBuilder vcardAsString = new StringBuilder();
            Map<String, VCardField> vcard = this.parseVCard(reader, vcardAsString);
            SysLog.detail((String)"Parsed vcard", vcard);
            return this.importItem(vcardAsString.toString(), vcard, account, locale, report);
        }
        catch (IOException e) {
            SysLog.warning((String)"can not read item", (Object)e.getMessage());
            return null;
        }
    }

    protected Account importItem(String vcardAsString, Map<String, VCardField> vcard, Account account, short locale, List<String> report) throws ServiceException {
        VCardField field;
        String s;
        String t;
        StringTokenizer tokenizer;
        String[] nameTokens;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(DATETIME_FORMAT);
        Segment codeSegment = null;
        try {
            codeSegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", account.refGetPath().getSegment(2).toString(), "segment", "Root"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        dateTimeFormatter.setLenient(false);
        boolean isContact = account instanceof Contact;
        String name = VCardField.getFieldValue("N", vcard);
        if (isContact) {
            String bday;
            String organization;
            String jobTitle;
            String nickName;
            Contact contact = (Contact)account;
            if (name != null) {
                nameTokens = new String[]{"", "", "", "", ""};
                tokenizer = new StringTokenizer(name, ";", true);
                int ii = 0;
                while (tokenizer.hasMoreTokens() && ii < nameTokens.length) {
                    t = tokenizer.nextToken();
                    if (";".equals(t)) {
                        ++ii;
                        continue;
                    }
                    nameTokens[ii] = t;
                }
                if (!nameTokens[0].isEmpty()) {
                    contact.setLastName(nameTokens[0]);
                } else if (contact.getLastName() == null) {
                    contact.setLastName("N/A");
                }
                if (!nameTokens[1].isEmpty()) {
                    contact.setFirstName(nameTokens[1]);
                }
                if (!nameTokens[2].isEmpty()) {
                    contact.setMiddleName(nameTokens[2]);
                }
                if (!nameTokens[3].isEmpty()) {
                    String salutation = nameTokens[3];
                    short salutationCode = this.mapToSalutationCode(salutation, codeSegment);
                    contact.setSalutationCode(salutationCode);
                    contact.setSalutation(salutation);
                } else {
                    contact.setSalutation(null);
                }
                if (!nameTokens[4].isEmpty()) {
                    contact.setSuffix(nameTokens[4]);
                }
            }
            if ((nickName = VCardField.getFieldValue("NICKNAME", vcard)) != null && !nickName.isEmpty()) {
                contact.setNickName(nickName);
            }
            if ((jobTitle = VCardField.getFieldValue("TITLE", vcard)) != null && !jobTitle.isEmpty()) {
                contact.setJobTitle(jobTitle);
            }
            if ((organization = VCardField.getFieldValue("ORG", vcard)) != null && !organization.isEmpty()) {
                contact.setOrganization(organization.split(";")[0]);
            }
            if ((bday = VCardField.getFieldValue("BDAY", vcard)) != null && !bday.isEmpty()) {
                bday = bday.replace("-", "");
                try {
                    if (bday.length() == 8) {
                        bday = bday + "T000000.000Z";
                    }
                    if ((bday.endsWith("T000000Z") || bday.endsWith("T000000.000Z")) && contact.getBirthdate() != null) {
                        bday = bday.substring(0, 9) + DateTimeFormat.BASIC_UTC_FORMAT.format(contact.getBirthdate()).substring(9);
                    }
                    contact.setBirthdate(this.getUtcDate(bday, dateTimeFormatter));
                }
                catch (Exception salutationCode) {
                    // empty catch block
                }
            }
            report.add("Update account");
        } else if (account instanceof AbstractGroup) {
            AbstractGroup group = (AbstractGroup)account;
            if (name != null) {
                nameTokens = new String[]{"", "", "", "", ""};
                tokenizer = new StringTokenizer(name, ";", true);
                int ii = 0;
                while (tokenizer.hasMoreTokens() && ii < nameTokens.length) {
                    t = tokenizer.nextToken();
                    if (";".equals(t)) {
                        ++ii;
                        continue;
                    }
                    nameTokens[ii] = t;
                }
                if (!nameTokens[0].isEmpty()) {
                    group.setName(nameTokens[0]);
                } else if (group.getName() == null) {
                    group.setName("N/A");
                }
            }
        }
        String photo = VCardField.getFieldValue("PHOTO", vcard);
        if (photo != null && !photo.isEmpty()) {
            List<String> mimeTypes;
            String mimeType;
            Media picture = null;
            try {
                picture = (Media)pm.getObjectById((Object)account.refGetPath().getDescendant(new String[]{"media", "VCARD"}));
            }
            catch (Exception tokenizer2) {
                // empty catch block
            }
            if (picture == null) {
                picture = (Media)pm.newInstance(Media.class);
                account.addMedia("VCARD", picture);
            }
            String string = mimeType = (mimeTypes = VCardField.getField("PHOTO", null, null, vcard).getParameters().get("TYPE")).isEmpty() ? "image/jpeg" : mimeTypes.get(0).toLowerCase();
            if (mimeType.indexOf("/") < 0) {
                mimeType = "image/" + mimeType;
            }
            picture.setContentMimeType(mimeType);
            picture.setContentName("VCARD~PHOTO");
            picture.setContent(BinaryLargeObjects.valueOf((byte[])Base64.decode((String)photo)));
            account.setPicture(picture);
        }
        boolean hasVcardUid = false;
        List<String> externalLinks = account.getExternalLink();
        String vcardUid = vcard.get("UID") == null ? account.refGetPath().getLastSegment().toString() : VCardField.getFieldValue("UID", vcard);
        for (int i = 0; i < externalLinks.size(); ++i) {
            if (!externalLinks.get(i).startsWith(VCARD_SCHEMA)) continue;
            externalLinks.set(i, VCARD_SCHEMA + vcardUid);
            hasVcardUid = true;
            break;
        }
        if (!hasVcardUid) {
            externalLinks.add(VCARD_SCHEMA + vcardUid);
        }
        String string = s = vcard.get("NOTE") == null ? null : VCardField.getFieldValue("NOTE", vcard);
        if (s != null) {
            Note note = null;
            try {
                note = (Note)pm.getObjectById((Object)account.refGetPath().getDescendant(new String[]{"note", "VCARD"}));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (note == null) {
                note = (Note)pm.newInstance(Note.class);
                account.addNote("VCARD", note);
                report.add("Create note");
            } else {
                report.add("Update note");
            }
            note.setTitle("VCARD~NOTE");
            String text = "";
            int pos = 0;
            if (s.indexOf("=0D=0A") >= 0) {
                while ((pos = s.indexOf("=0D=0A")) >= 0) {
                    text = text + s.substring(0, pos) + "\n";
                    s = s.substring(pos + 6);
                }
            } else if (s.indexOf("\\n") >= 0) {
                while ((pos = s.indexOf("\\n")) >= 0) {
                    text = text + s.substring(0, pos) + "\n";
                    s = s.substring(pos + 2);
                }
            } else {
                text = s;
            }
            note.setText(text);
        }
        account.setVcard(vcardAsString);
        AccountHasAccountAddress.Address addresses = account.getAddress();
        PostalAddress adrHome = null;
        PostalAddress adrWork = null;
        PhoneNumber telHomeVoice = null;
        PhoneNumber telWorkVoice = null;
        PhoneNumber telHomeFax = null;
        PhoneNumber telWorkFax = null;
        WebAddress urlHome = null;
        WebAddress urlWork = null;
        PhoneNumber telCellVoice = null;
        EMailAddress emailInternet = null;
        EMailAddress emailPrefInternet = null;
        Iterator iterator = addresses.iterator();
        while (iterator.hasNext()) {
            AccountAddress address = (AccountAddress)iterator.next();
            ArrayList<Short> usage = new ArrayList<Short>();
            Iterator<Short> j = address.getUsage().iterator();
            while (j.hasNext()) {
                usage.add(j.next());
            }
            if (address instanceof PostalAddress) {
                if (usage.contains(Addresses.USAGE_HOME)) {
                    adrHome = (PostalAddress)address;
                    continue;
                }
                if (!usage.contains(Addresses.USAGE_BUSINESS)) continue;
                adrWork = (PostalAddress)address;
                continue;
            }
            if (address instanceof EMailAddress) {
                if (usage.contains(Addresses.USAGE_BUSINESS)) {
                    emailPrefInternet = (EMailAddress)address;
                    continue;
                }
                if (!usage.contains(Addresses.USAGE_HOME)) continue;
                emailInternet = (EMailAddress)address;
                continue;
            }
            if (address instanceof PhoneNumber) {
                if (usage.contains(Addresses.USAGE_HOME)) {
                    telHomeVoice = (PhoneNumber)address;
                    continue;
                }
                if (usage.contains(Addresses.USAGE_BUSINESS)) {
                    telWorkVoice = (PhoneNumber)address;
                    continue;
                }
                if (usage.contains(Addresses.USAGE_HOME_FAX)) {
                    telHomeFax = (PhoneNumber)address;
                    continue;
                }
                if (usage.contains(Addresses.USAGE_BUSINESS_FAX)) {
                    telWorkFax = (PhoneNumber)address;
                    continue;
                }
                if (!usage.contains(Addresses.USAGE_MOBILE)) continue;
                telCellVoice = (PhoneNumber)address;
                continue;
            }
            if (!(address instanceof WebAddress)) continue;
            if (usage.contains(Addresses.USAGE_HOME)) {
                urlHome = (WebAddress)address;
                continue;
            }
            if (!usage.contains(Addresses.USAGE_BUSINESS)) continue;
            urlWork = (WebAddress)address;
        }
        s = VCardField.getFieldValue("ADR", "TYPE", Arrays.asList("HOME"), vcard);
        if (s != null && !s.isEmpty() && !s.startsWith(";;;")) {
            if (adrHome == null) {
                adrHome = (PostalAddress)pm.newInstance(PostalAddress.class);
                adrHome.getUsage().add(Addresses.USAGE_HOME);
                adrHome.setMain(Boolean.TRUE);
                this.updatePostalAddress(adrHome, s, locale, codeSegment);
                account.addAddress(false, this.getUidAsString(), adrHome);
                report.add("Create postal address");
            } else {
                this.updatePostalAddress(adrHome, s, locale, codeSegment);
                report.add("Update postal address");
            }
        }
        if ((s = VCardField.getFieldValue("ADR", "TYPE", Arrays.asList("WORK"), vcard)) != null && !s.isEmpty() && !s.startsWith(";;;")) {
            if (adrWork == null) {
                adrWork = (PostalAddress)pm.newInstance(PostalAddress.class);
                adrWork.getUsage().add(Addresses.USAGE_BUSINESS);
                adrWork.setMain(Boolean.TRUE);
                this.updatePostalAddress(adrWork, s, locale, codeSegment);
                account.addAddress(false, this.getUidAsString(), adrWork);
                report.add("Create postal address");
            } else {
                this.updatePostalAddress(adrWork, s, locale, codeSegment);
                report.add("Update postal address");
            }
        }
        if ((s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("HOME", "VOICE"), vcard)) == null || s.isEmpty()) {
            s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("HOME"), vcard);
        }
        if (s != null && !s.isEmpty()) {
            if (telHomeVoice == null) {
                telHomeVoice = (PhoneNumber)pm.newInstance(PhoneNumber.class);
                telHomeVoice.getUsage().add(Addresses.USAGE_HOME);
                telHomeVoice.setMain(Boolean.TRUE);
                this.updatePhoneNumber(telHomeVoice, s);
                account.addAddress(false, this.getUidAsString(), telHomeVoice);
                report.add("Create phone number");
            } else {
                this.updatePhoneNumber(telHomeVoice, s);
                report.add("Update phone number");
            }
        }
        if ((s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("WORK", "VOICE"), vcard)) == null || s.isEmpty()) {
            s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("WORK"), vcard);
        }
        if (s != null && !s.isEmpty()) {
            if (telWorkVoice == null) {
                telWorkVoice = (PhoneNumber)pm.newInstance(PhoneNumber.class);
                telWorkVoice.getUsage().add(Addresses.USAGE_BUSINESS);
                telWorkVoice.setMain(Boolean.TRUE);
                this.updatePhoneNumber(telWorkVoice, s);
                account.addAddress(false, this.getUidAsString(), telWorkVoice);
                report.add("Create phone number");
            } else {
                this.updatePhoneNumber(telWorkVoice, s);
                report.add("Update phone number");
            }
        }
        if ((s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("HOME", "FAX"), vcard)) != null && !s.isEmpty()) {
            if (telHomeFax == null) {
                telHomeFax = (PhoneNumber)pm.newInstance(PhoneNumber.class);
                telHomeFax.getUsage().add(Addresses.USAGE_HOME_FAX);
                telHomeFax.setMain(Boolean.TRUE);
                this.updatePhoneNumber(telHomeFax, s);
                account.addAddress(false, this.getUidAsString(), telHomeFax);
                report.add("Create phone number");
            } else {
                this.updatePhoneNumber(telHomeFax, s);
                report.add("Update phone number");
            }
        }
        if ((s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("WORK", "FAX"), vcard)) != null && !s.isEmpty()) {
            if (telWorkFax == null) {
                telWorkFax = (PhoneNumber)pm.newInstance(PhoneNumber.class);
                telWorkFax.getUsage().add(Addresses.USAGE_BUSINESS_FAX);
                telWorkFax.setMain(Boolean.TRUE);
                this.updatePhoneNumber(telWorkFax, s);
                account.addAddress(false, this.getUidAsString(), telWorkFax);
                report.add("Create phone number");
            } else {
                this.updatePhoneNumber(telWorkFax, s);
                report.add("Update phone number");
            }
        }
        if ((s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("CELL", "VOICE"), vcard)) == null || s.isEmpty()) {
            s = VCardField.getFieldValue("TEL", "TYPE", Arrays.asList("CELL"), vcard);
        }
        if (s != null && !s.isEmpty()) {
            if (telCellVoice == null) {
                telCellVoice = (PhoneNumber)pm.newInstance(PhoneNumber.class);
                telCellVoice.getUsage().add(Addresses.USAGE_MOBILE);
                telCellVoice.setMain(Boolean.TRUE);
                this.updatePhoneNumber(telCellVoice, s);
                account.addAddress(false, this.getUidAsString(), telCellVoice);
                report.add("Create phone number");
            } else {
                this.updatePhoneNumber(telCellVoice, s);
                report.add("Update phone number");
            }
        }
        if ((s = VCardField.getFieldValue("URL", "TYPE", Arrays.asList("HOME"), vcard)) != null && !s.isEmpty()) {
            if (urlHome == null) {
                urlHome = (WebAddress)pm.newInstance(WebAddress.class);
                urlHome.getUsage().add(Addresses.USAGE_HOME);
                urlHome.setMain(Boolean.TRUE);
                this.updateWebAddress(urlHome, s);
                account.addAddress(false, this.getUidAsString(), urlHome);
                report.add("Create web address");
            } else {
                this.updateWebAddress(urlHome, s);
                report.add("Update web address");
            }
        }
        if ((s = VCardField.getFieldValue("URL", "TYPE", Arrays.asList("WORK"), vcard)) != null && !s.isEmpty()) {
            if (urlWork == null) {
                urlWork = (WebAddress)pm.newInstance(WebAddress.class);
                urlWork.getUsage().add(Addresses.USAGE_BUSINESS);
                urlWork.setMain(Boolean.TRUE);
                this.updateWebAddress(urlWork, s);
                account.addAddress(false, this.getUidAsString(), urlWork);
                report.add("Create web address");
            } else {
                this.updateWebAddress(urlWork, s);
                report.add("Update web address");
            }
        }
        if ((s = VCardField.getFieldValue("EMAIL", "TYPE", Arrays.asList("WORK"), vcard)) == null) {
            s = VCardField.getFieldValue("EMAIL", "TYPE", Arrays.asList("PREF", "INTERNET"), vcard);
        }
        if (s != null && !s.isEmpty()) {
            if (emailPrefInternet == null) {
                emailPrefInternet = (EMailAddress)pm.newInstance(EMailAddress.class);
                emailPrefInternet.getUsage().add(Addresses.USAGE_BUSINESS);
                emailPrefInternet.setMain(Boolean.TRUE);
                this.updateEMailAddress(emailPrefInternet, s);
                account.addAddress(false, this.getUidAsString(), emailPrefInternet);
                report.add("Create email address");
            } else {
                this.updateEMailAddress(emailPrefInternet, s);
                report.add("Update email address");
            }
        }
        if ((s = VCardField.getFieldValue("EMAIL", "TYPE", Arrays.asList("HOME"), vcard)) == null && (field = VCardField.getField("EMAIL", null, null, vcard)) != null && (field.getParameters().get("TYPE") == null || field.getParameters().get("TYPE").equals(Arrays.asList("INTERNET")))) {
            s = field.getValue();
        }
        if (s != null && !s.isEmpty()) {
            if (emailInternet == null) {
                emailInternet = (EMailAddress)pm.newInstance(EMailAddress.class);
                emailInternet.getUsage().add(Addresses.USAGE_HOME);
                emailInternet.setMain(Boolean.TRUE);
                this.updateEMailAddress(emailInternet, s);
                account.addAddress(false, this.getUidAsString(), emailInternet);
                report.add("Create email address");
            } else {
                this.updateEMailAddress(emailInternet, s);
                report.add("Update email address");
            }
        }
        return account;
    }

    public Account updateAccount(String vcardAsString, Map<String, VCardField> vcard, org.opencrx.kernel.account1.jmi1.Segment accountSegment, short locale, List<String> report) throws ServiceException {
        boolean isNew;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        String lookupEmail = VCardField.getFieldValue("EMAIL", "TYPE", Arrays.asList("PREF", "INTERNET"), vcard);
        Account contact = null;
        if (lookupEmail != null && lookupEmail.length() > 0) {
            SysLog.trace((String)"looking up", (Object)lookupEmail);
            EMailAddressQuery addressQuery = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            addressQuery.identity().like((Object)accountSegment.refGetPath().getDescendant(new String[]{"account", ":*", "address", ":*"}).toXRI());
            addressQuery.thereExistsEmailAddress().equalTo((Object)lookupEmail);
            List addresses = accountSegment.getAddress(addressQuery);
            if (!addresses.isEmpty()) {
                SysLog.trace((String)"address found");
                AccountAddress address = (AccountAddress)addresses.iterator().next();
                contact = (Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
            }
        }
        SysLog.trace((String)"account", contact);
        boolean bl = isNew = contact == null;
        if (isNew) {
            return null;
        }
        return this.importItem(vcardAsString, vcard, contact, locale, report);
    }

    protected Account findAccount(PersistenceManager pm, org.opencrx.kernel.account1.jmi1.Segment accountSegment, String uid) {
        AccountQuery query = (AccountQuery)pm.newQuery(Account.class);
        query.thereExistsExternalLink().equalTo((Object)(VCARD_SCHEMA + uid));
        List accounts = accountSegment.getAccount(query);
        if (accounts.isEmpty()) {
            query = (AccountQuery)pm.newQuery(Account.class);
            query.thereExistsExternalLink().equalTo((Object)(VCARD_SCHEMA + uid.replace('.', '+')));
            accounts = accountSegment.getAccount(query);
            if (accounts.isEmpty()) {
                return null;
            }
            return (Account)accounts.iterator().next();
        }
        return (Account)accounts.iterator().next();
    }

    public PutVCardResult putVCard(BufferedReader reader, org.opencrx.kernel.account1.jmi1.Segment accountSegment) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        boolean isTxLocal = !pm.currentTransaction().isActive();
        PutVCardResult.Status status = PutVCardResult.Status.UPDATED;
        Account account = null;
        String cardUID = null;
        String newUID = null;
        block10: while (true) {
            try {
                String l;
                while ((l = reader.readLine()) != null) {
                    if (!l.toUpperCase().startsWith("BEGIN:VCARD")) continue;
                    String vcard = "";
                    vcard = vcard + "BEGIN:VCARD\n";
                    String cardREV = null;
                    while ((l = reader.readLine()) != null) {
                        int posEndItemPrefix;
                        if ((l.startsWith("item") || l.startsWith("ITEM")) && (posEndItemPrefix = l.indexOf(".")) > 0) {
                            l = l.substring(posEndItemPrefix + 1);
                        }
                        vcard = vcard + l;
                        vcard = vcard + "\n";
                        if (l.startsWith("UID:")) {
                            cardUID = l.substring(4);
                            continue;
                        }
                        if (l.startsWith("REV:")) {
                            cardREV = l.substring(4);
                            continue;
                        }
                        if (!l.startsWith("END:VCARD")) continue;
                    }
                    SysLog.trace((String)"VCARD", (Object)vcard);
                    newUID = cardUID;
                    if (cardUID == null || cardREV == null) continue;
                    SysLog.detail((String)"Lookup account", cardUID);
                    account = this.findAccount(pm, accountSegment, cardUID);
                    StringBuilder dummy = new StringBuilder();
                    Map<Object, Object> newCard = new HashMap();
                    try {
                        newCard = VCard.getInstance().parseVCard(new BufferedReader(new StringReader(vcard.toString())), dummy);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    newCard.remove("LAST-MODIFIED");
                    newCard.remove("DTSTAMP");
                    newCard.remove("CREATED");
                    newCard.remove("REV");
                    newCard.remove("PRODID");
                    newCard.remove("VERSION");
                    dummy.setLength(0);
                    Map<String, VCardField> oldCard = null;
                    if (account == null) {
                        int pos2;
                        int pos1 = vcard.indexOf("UID:");
                        if (pos1 > 0 && (pos2 = vcard.indexOf("\n", pos1)) > pos1) {
                            newUID = Base.getInstance().getUidAsString();
                            vcard = vcard.substring(0, pos1) + "UID:" + newUID + "\n" + vcard.substring(pos2 + 1);
                        }
                        if (account == null) {
                            if (!pm.currentTransaction().isActive()) {
                                pm.currentTransaction().begin();
                            }
                            account = (Account)pm.newInstance(Contact.class);
                            accountSegment.addAccount(Base.getInstance().getUidAsString(), account);
                        }
                        status = PutVCardResult.Status.CREATED;
                    } else {
                        try {
                            oldCard = this.parseVCard(new BufferedReader(new StringReader(account.getVcard())), dummy);
                        }
                        catch (Exception pos1) {
                            // empty catch block
                        }
                        oldCard.remove("LAST-MODIFIED");
                        oldCard.remove("DTSTAMP");
                        oldCard.remove("CREATED");
                        oldCard.remove("REV");
                        oldCard.remove("PRODID");
                        oldCard.remove("VERSION");
                        oldCard.keySet().retainAll(newCard.keySet());
                    }
                    if (newCard.equals(oldCard)) continue;
                    try {
                        if (!pm.currentTransaction().isActive()) {
                            pm.currentTransaction().begin();
                        }
                        ImportItemParams importItemParams = (ImportItemParams)Structures.create(ImportItemParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportItemParams.Member.item, (Object)vcard.toString().getBytes("UTF-8")), Datatypes.member((Enum)ImportItemParams.Member.itemMimeType, (Object)MIME_TYPE), Datatypes.member((Enum)ImportItemParams.Member.itemName, (Object)"import.vcf")});
                        account.importItem(importItemParams);
                        if (!isTxLocal) continue block10;
                        pm.currentTransaction().commit();
                        pm.refresh((Object)account);
                        continue block10;
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                        status = PutVCardResult.Status.ERROR;
                        try {
                            pm.currentTransaction().rollback();
                            continue block10;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                break;
            }
            catch (IOException e) {
                status = PutVCardResult.Status.ERROR;
                new ServiceException((Exception)e).log();
                break;
            }
        }
        return new PutVCardResult(status, cardUID, newUID, account);
    }

    static {
        salutations.put(0, "NA");
        salutations.put(1, "Mr.");
        salutations.put(2, "Mrs.");
        salutations.put(3, "Miss");
        salutations.put(4, "Mr. and Mrs.");
        salutations.put(5, "Company");
        salutations.put(6, "Brothers");
        salutations.put(7, "Prof.");
        salutations.put(8, "Dr.");
        salutations.put(9, "Family");
    }

    public static class PutVCardResult {
        private final Status status;
        private final String oldUID;
        private final String newUID;
        private final Account account;

        public PutVCardResult(Status status, String oldUID, String newUID, Account account) {
            this.status = status;
            this.oldUID = oldUID;
            this.newUID = newUID;
            this.account = account;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getOldUID() {
            return this.oldUID;
        }

        public String getNewUID() {
            return this.newUID;
        }

        public Account getAccount() {
            return this.account;
        }

        public static enum Status {
            CREATED,
            UPDATED,
            ERROR;

        }
    }

    public static class VCardField {
        private final String name;
        private String value;
        private final Map<String, List<String>> parameters;

        public VCardField(String name, String value, Map<String, List<String>> parameters) {
            this.name = name;
            this.value = value;
            this.parameters = parameters;
        }

        public static VCardField getField(String name, String parameterName, List<String> parameterValues, Map<String, VCardField> vcard) {
            for (VCardField field : vcard.values()) {
                if (!name.equals(field.getName()) || parameterName != null && (field.getParameters().get(parameterName) == null || !field.getParameters().get(parameterName).containsAll(parameterValues))) continue;
                return field;
            }
            return null;
        }

        public static String getFieldValue(String name, String parameterName, List<String> parameterValues, Map<String, VCardField> vcard) {
            VCardField field = VCardField.getField(name, parameterName, parameterValues, vcard);
            return field == null ? null : field.getValue();
        }

        public static String getFieldValue(String name, Map<String, VCardField> vcard) {
            return VCardField.getFieldValue(name, null, null, vcard);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Map<String, List<String>> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VCardField) {
                VCardField that = (VCardField)obj;
                return this.name.equals(that.name) && this.parameters.equals(that.parameters) && this.value.equals(that.value);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.name + this.parameters.toString() + ":" + this.value;
        }
    }
}

