/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.oasisopen.jmi1.RefContainer;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.marshalling.Marshaller;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.ModelHelper;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.security.authorization1.jmi1.Policy;
import org.openmdx.security.realm1.jmi1.Principal;
import org.openmdx.security.realm1.jmi1.Realm;

public class SecureObject
extends AbstractImpl {
    public static final int MODE_LOCAL = 0;
    public static final int MODE_RECURSIVE = 1;

    public static void register() {
        SecureObject.registerImpl(new SecureObject());
    }

    public static SecureObject getInstance() throws ServiceException {
        return SecureObject.getInstance(SecureObject.class);
    }

    protected SecureObject() {
    }

    public Principal findPrincipal(String name, Realm realm) {
        try {
            List principalChain = PersistenceManagers.toPrincipalChain((String)name);
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)realm);
            return (Principal)pm.getObjectById((Object)realm.refGetPath().getDescendant(new String[]{"principal", (String)principalChain.get(0)}));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Principal findPrincipal(String name, Path realmIdentity, PersistenceManager pm) throws ServiceException {
        Realm realm = (Realm)pm.getObjectById((Object)realmIdentity);
        return this.findPrincipal(name, realm);
    }

    public Realm getRealm(PersistenceManager pm, String providerName, String segmentName) {
        return (Realm)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName}));
    }

    public Policy getPolicy(PersistenceManager pm, String providerName, String segmentName) {
        return (Policy)pm.getObjectById((Object)new Path("xri://@openmdx*org.openmdx.security.authorization1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "policy", segmentName}));
    }

    public PrincipalGroup initPrincipalGroup(String groupName, PersistenceManager pm, String providerName, String segmentName) {
        Realm realm = this.getRealm(pm, providerName, segmentName);
        PrincipalGroup principalGroup = null;
        principalGroup = (PrincipalGroup)this.findPrincipal(groupName, realm);
        if (principalGroup != null) {
            return principalGroup;
        }
        pm.currentTransaction().begin();
        principalGroup = (PrincipalGroup)pm.newInstance(PrincipalGroup.class);
        principalGroup.setDescription(segmentName + "\\\\" + groupName);
        realm.addPrincipal(groupName, (Principal)principalGroup);
        pm.currentTransaction().commit();
        return principalGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAcls(org.opencrx.kernel.base.jmi1.SecureObject obj, AclMarshaller marshaller, Short mode, String reportText, List<String> report, int level, Map<String, Set<String>> filter) {
        PersistenceManager pm1 = null;
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (JDOHelper.isPersistent((Object)obj) && level > 0 && obj.refGetPath().size() == 7) {
                pm1 = pm.getPersistenceManagerFactory().getPersistenceManager(UserObjects.getPrincipalChain((PersistenceManager)pm).toString(), null);
                pm1.currentTransaction().begin();
                obj = (org.opencrx.kernel.base.jmi1.SecureObject)pm1.getObjectById((Object)obj.refGetPath());
                marshaller = marshaller.clone(pm1);
            }
            marshaller.marshal(obj);
            report.add(reportText);
            if (mode != null && mode.intValue() == 1) {
                Model_1_0 model = Model_1Factory.getModel();
                String refClass = obj.refClass().refMofId();
                Map references = model.getElement((Object)refClass).objGetMap("reference");
                for (ModelElement_1_0 featureDef : references.values()) {
                    ModelElement_1_0 referencedEnd = model.getElement((Object)featureDef.getReferencedEnd());
                    if (!ModelHelper.isCompositeEnd((ModelElement_1_0)featureDef, (boolean)false) || !Boolean.TRUE.equals(referencedEnd.isChangeable())) continue;
                    String referenceName = featureDef.getName();
                    if (filter != null && filter.containsKey(refClass) && !filter.get(refClass).contains(referenceName)) continue;
                    RefContainer container = (RefContainer)obj.refGetValue(referenceName);
                    List content = container.refGetAll(null);
                    for (Object contained : content) {
                        if (!(contained instanceof org.opencrx.kernel.base.jmi1.SecureObject)) continue;
                        this.applyAcls((org.opencrx.kernel.base.jmi1.SecureObject)contained, marshaller, mode, reportText, report, level + 1, filter);
                    }
                }
            }
            if (pm1 != null) {
                pm1.currentTransaction().commit();
            }
        }
        catch (Exception e) {
            report.add(e.getMessage());
            new ServiceException(e).log();
            try {
                if (pm1 != null) {
                    pm1.currentTransaction().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                if (pm1 != null) {
                    pm1.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setOwningUser(org.opencrx.kernel.base.jmi1.SecureObject obj, User user, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, new SetOwningUserMarshaller(user), mode, "setOwningUser", report, 0, filter);
    }

    public void addOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, PrincipalGroup group, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.addOwningGroup(obj, group, new AddOwningGroupMarshaller(group), mode, report, filter);
    }

    public void addOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, PrincipalGroup group, AclMarshaller marshaller, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, marshaller, mode, "addOwningGroup", report, 0, filter);
    }

    public void replaceOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, List<PrincipalGroup> groups, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.replaceOwningGroup(obj, groups, new ReplaceOwningGroupMarshaller(groups), mode, report, filter);
    }

    public void replaceOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, List<PrincipalGroup> groups, AclMarshaller marshaller, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, marshaller, mode, "replaceOwningGroup", report, 0, filter);
    }

    public void removeOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, PrincipalGroup group, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.removeOwningGroup(obj, group, new RemoveOwningGroupMarshaller(group), mode, report, filter);
    }

    public void removeOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, PrincipalGroup group, AclMarshaller marshaller, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, marshaller, mode, "removeOwningGroup", report, 0, filter);
    }

    public void removeAllOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, new AclMarshaller(){

            public Object marshal(Object s) throws ServiceException {
                if (s instanceof org.opencrx.kernel.base.jmi1.SecureObject) {
                    ((org.opencrx.kernel.base.jmi1.SecureObject)s).getOwningGroup().clear();
                }
                return s;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public AclMarshaller clone(PersistenceManager pm) {
                return this;
            }
        }, mode, "removeAllOwningGroup", report, 0, filter);
    }

    public void setAccessLevel(org.opencrx.kernel.base.jmi1.SecureObject obj, short accessLevelBrowse, short accessLevelUpdate, short accessLevelDelete, short mode, List<String> report, Map<String, Set<String>> filter) throws ServiceException {
        this.applyAcls(obj, new SetAccessLevelMarshaller(accessLevelBrowse, accessLevelUpdate, accessLevelDelete), mode, "setAccessLevel", report, 0, filter);
    }

    public void assertOwningGroup(org.opencrx.kernel.base.jmi1.SecureObject obj) throws ServiceException {
    }

    public Path getLoginRealmIdentity(String providerName) {
        return SecureObject.getRealmIdentity(providerName, "Default");
    }

    public static Path getRealmIdentity(String providerName, String segmentName) {
        return new Path("xri://@openmdx*org.openmdx.security.realm1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "realm", segmentName});
    }

    public static Path getPolicyIdentity(String providerName, String segmentName) {
        return new Path("xri://@openmdx*org.openmdx.security.authorization1").getDescendant(new String[]{"provider", providerName, "segment", "Root", "policy", segmentName});
    }

    public void updateSecureObject(org.opencrx.kernel.base.jmi1.SecureObject secureObject) throws ServiceException {
    }

    public static class SetAccessLevelMarshaller
    implements AclMarshaller {
        private final short accessLevelBrowse;
        private final short accessLevelUpdate;
        private final short accessLevelDelete;

        public SetAccessLevelMarshaller(short accessLevelBrowse, short accessLevelUpdate, short accessLevelDelete) {
            this.accessLevelBrowse = accessLevelBrowse;
            this.accessLevelUpdate = accessLevelUpdate;
            this.accessLevelDelete = accessLevelDelete;
        }

        public Object marshal(Object s) throws ServiceException {
            if (s instanceof org.opencrx.kernel.base.jmi1.SecureObject) {
                org.opencrx.kernel.base.jmi1.SecureObject obj = (org.opencrx.kernel.base.jmi1.SecureObject)s;
                if (obj.getAccessLevelBrowse() != this.accessLevelBrowse) {
                    obj.setAccessLevelBrowse(this.accessLevelBrowse);
                }
                if (obj.getAccessLevelUpdate() != this.accessLevelUpdate) {
                    obj.setAccessLevelUpdate(this.accessLevelUpdate);
                }
                if (obj.getAccessLevelDelete() != this.accessLevelDelete) {
                    obj.setAccessLevelDelete(this.accessLevelDelete);
                }
            }
            return s;
        }

        @Override
        public AclMarshaller clone(PersistenceManager pm) {
            return this;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public static class RemoveOwningGroupMarshaller
    implements AclMarshaller {
        private final PrincipalGroup group;

        public RemoveOwningGroupMarshaller(PrincipalGroup group) {
            this.group = group;
        }

        @Override
        public AclMarshaller clone(PersistenceManager pm) {
            return new RemoveOwningGroupMarshaller((PrincipalGroup)pm.getObjectById((Object)this.group.refGetPath()));
        }

        public Object marshal(Object s) throws ServiceException {
            org.opencrx.kernel.base.jmi1.SecureObject obj;
            if (s instanceof org.opencrx.kernel.base.jmi1.SecureObject && (obj = (org.opencrx.kernel.base.jmi1.SecureObject)s).getOwningGroup().contains(this.group)) {
                obj.getOwningGroup().remove(this.group);
            }
            return s;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ReplaceOwningGroupMarshaller
    implements AclMarshaller {
        protected final List<PrincipalGroup> groups;

        public ReplaceOwningGroupMarshaller(List<PrincipalGroup> groups) {
            this.groups = groups;
        }

        @Override
        public AclMarshaller clone(PersistenceManager pm) {
            ArrayList<PrincipalGroup> groups = new ArrayList<PrincipalGroup>();
            for (PrincipalGroup group : this.groups) {
                groups.add((PrincipalGroup)pm.getObjectById((Object)group.refGetPath()));
            }
            return new ReplaceOwningGroupMarshaller(groups);
        }

        public Object marshal(Object s) throws ServiceException {
            org.opencrx.kernel.base.jmi1.SecureObject obj;
            if (!(!(s instanceof org.opencrx.kernel.base.jmi1.SecureObject) || this.groups.containsAll((obj = (org.opencrx.kernel.base.jmi1.SecureObject)s).getOwningGroup()) && obj.getOwningGroup().containsAll(this.groups))) {
                obj.getOwningGroup().clear();
                obj.getOwningGroup().addAll(this.groups);
            }
            return s;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public static class AddOwningGroupMarshaller
    implements AclMarshaller {
        private final PrincipalGroup group;

        public AddOwningGroupMarshaller(PrincipalGroup group) {
            this.group = group;
        }

        @Override
        public AclMarshaller clone(PersistenceManager pm) {
            return new AddOwningGroupMarshaller((PrincipalGroup)pm.getObjectById((Object)this.group.refGetPath()));
        }

        public Object marshal(Object s) throws ServiceException {
            org.opencrx.kernel.base.jmi1.SecureObject obj;
            if (s instanceof org.opencrx.kernel.base.jmi1.SecureObject && !(obj = (org.opencrx.kernel.base.jmi1.SecureObject)s).getOwningGroup().contains(this.group)) {
                obj.getOwningGroup().add(this.group);
            }
            return s;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public static class SetOwningUserMarshaller
    implements AclMarshaller {
        private final User user;

        public SetOwningUserMarshaller(User user) {
            this.user = user;
        }

        @Override
        public AclMarshaller clone(PersistenceManager pm) {
            return new SetOwningUserMarshaller((User)pm.getObjectById((Object)this.user.refGetPath()));
        }

        public Object marshal(Object s) throws ServiceException {
            if (s instanceof org.opencrx.kernel.base.jmi1.SecureObject) {
                org.opencrx.kernel.base.jmi1.SecureObject obj = (org.opencrx.kernel.base.jmi1.SecureObject)s;
                if (this.user != null && !this.user.equals(obj.getOwningUser())) {
                    obj.setOwningUser(this.user);
                }
            }
            return s;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface AclMarshaller
    extends Marshaller {
        public AclMarshaller clone(PersistenceManager var1);
    }
}

