/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Depots;
import org.opencrx.kernel.contract1.cci2.InvoicePositionQuery;
import org.opencrx.kernel.contract1.cci2.OpportunityPositionQuery;
import org.opencrx.kernel.contract1.cci2.QuotePositionQuery;
import org.opencrx.kernel.contract1.cci2.SalesOrderPositionQuery;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.InvoicePosition;
import org.opencrx.kernel.contract1.jmi1.OpportunityPosition;
import org.opencrx.kernel.contract1.jmi1.QuotePosition;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.contract1.jmi1.SalesOrderPosition;
import org.opencrx.kernel.depot1.cci2.SimpleBookingQuery;
import org.opencrx.kernel.depot1.jmi1.DepotPosition;
import org.opencrx.kernel.depot1.jmi1.SimpleBooking;
import org.opencrx.kernel.forecast1.cci2.SalesVolumeBudgetHasPosition;
import org.opencrx.kernel.forecast1.jmi1.AbstractBudget;
import org.opencrx.kernel.forecast1.jmi1.QuantityBasedSalesVolumeBudgetPosition;
import org.opencrx.kernel.forecast1.jmi1.SalesVolumeBudget;
import org.opencrx.kernel.forecast1.jmi1.SalesVolumeBudgetContributionSource;
import org.opencrx.kernel.forecast1.jmi1.SalesVolumeBudgetPosition;
import org.opencrx.kernel.forecast1.jmi1.Segment;
import org.opencrx.kernel.forecast1.jmi1.ValueBasedSalesVolumeBudgetPosition;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.product1.cci2.ConfiguredProductQuery;
import org.opencrx.kernel.product1.cci2.ProductQuery;
import org.opencrx.kernel.product1.jmi1.Product;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;

public class Forecasts
extends AbstractImpl {
    public static final short VALUE_TYPE_NA = 0;
    public static final short VALUE_TYPE_BASE_AMOUNT = 1;
    public static final short VALUE_TYPE_AMOUNT = 2;
    public static final short VALUE_TYPE_DISCOUNT_AMOUNT = 3;
    public static final short VALUE_TYPE_PRICE_PER_UNIT = 4;

    public static void register() {
        Forecasts.registerImpl(new Forecasts());
    }

    public static Forecasts getInstance() throws ServiceException {
        return Forecasts.getInstance(Forecasts.class);
    }

    protected Forecasts() {
    }

    public Segment getForecastSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.forecast1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public void updateBudget(AbstractBudget budget) throws ServiceException {
    }

    public void recalcBudget(SalesVolumeBudget budget) throws ServiceException {
        ConfiguredProductQuery query;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)budget);
        if (budget.getDepot() == null) {
            return;
        }
        String providerName = budget.refGetPath().get(2);
        String segmentName = budget.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = (org.opencrx.kernel.contract1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
        Date lastCalculatedAt = budget.getLastCalculatedAt();
        ArrayList contributionSources = new ArrayList();
        if (budget.getContractType() == 2) {
            query = (OpportunityPositionQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(OpportunityPosition.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "opportunity", ":*", "position", ":*"}));
            query.thereExistsBudget().equalTo(budget);
            if (lastCalculatedAt != null) {
                query.modifiedAt().greaterThan((Comparable)lastCalculatedAt);
            }
            List opportunityPositions = contractSegment.getExtent((ExtentCapableQuery)query);
            contributionSources.addAll(opportunityPositions);
        } else if (budget.getContractType() == 3) {
            query = (QuotePositionQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(QuotePosition.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "quote", ":*", "position", ":*"}));
            query.thereExistsBudget().equalTo(budget);
            if (lastCalculatedAt != null) {
                query.modifiedAt().greaterThan((Comparable)lastCalculatedAt);
            }
            List quotePositions = contractSegment.getExtent((ExtentCapableQuery)query);
            contributionSources.addAll(quotePositions);
        } else if (budget.getContractType() == 4) {
            query = (SalesOrderPositionQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(SalesOrderPosition.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "salesOrder", ":*", "position", ":*"}));
            query.thereExistsBudget().equalTo(budget);
            if (lastCalculatedAt != null) {
                query.modifiedAt().greaterThan((Comparable)lastCalculatedAt);
            }
            List salesOrderPositions = contractSegment.getExtent((ExtentCapableQuery)query);
            contributionSources.addAll(salesOrderPositions);
        } else if (budget.getContractType() == 5) {
            query = (InvoicePositionQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(InvoicePosition.class), (Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "invoice", ":*", "position", ":*"}));
            query.thereExistsBudget().equalTo(budget);
            if (lastCalculatedAt != null) {
                query.modifiedAt().greaterThan((Comparable)lastCalculatedAt);
            }
            List invoicePositions = contractSegment.getExtent((ExtentCapableQuery)query);
            contributionSources.addAll(invoicePositions);
        }
        org.opencrx.kernel.depot1.jmi1.Segment depotSegment = (org.opencrx.kernel.depot1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.depot1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
        for (SalesVolumeBudgetContributionSource contributionSource : contributionSources) {
            AbstractContract contract;
            CrxObject contractPosition;
            Date valueDate = null;
            Product product = null;
            String bookingText = null;
            String originId = null;
            List<String> originContextParams = null;
            if (contributionSource instanceof OpportunityPosition) {
                contractPosition = (OpportunityPosition)contributionSource;
                contract = (AbstractContract)pm.getObjectById((Object)contractPosition.refGetPath().getParent().getParent());
                valueDate = contractPosition.getModifiedAt();
                lastCalculatedAt = contractPosition.getModifiedAt();
                product = contractPosition.getProduct();
                originId = contract.getContractNumber() + "/" + contractPosition.getLineItemNumber();
                originContextParams = Arrays.asList(contract.getContractNumber(), Long.toString(contractPosition.getLineItemNumber()));
                bookingText = contract.getContractNumber() + " / " + contractPosition.getLineItemNumber() + " / " + contractPosition.getName();
            } else if (contributionSource instanceof QuotePosition) {
                contractPosition = (QuotePosition)contributionSource;
                contract = (AbstractContract)pm.getObjectById((Object)contractPosition.refGetPath().getParent().getParent());
                valueDate = contractPosition.getModifiedAt();
                lastCalculatedAt = contractPosition.getModifiedAt();
                product = contractPosition.getProduct();
                originId = contract.getContractNumber() + "/" + contractPosition.getLineItemNumber();
                originContextParams = Arrays.asList(contract.getContractNumber(), Long.toString(contractPosition.getLineItemNumber()));
                bookingText = contract.getContractNumber() + " / " + contractPosition.getLineItemNumber() + " / " + contractPosition.getName();
            } else if (contributionSource instanceof SalesOrderPosition) {
                contractPosition = (SalesOrderPosition)contributionSource;
                contract = (AbstractContract)pm.getObjectById((Object)contractPosition.refGetPath().getParent().getParent());
                valueDate = contractPosition.getModifiedAt();
                lastCalculatedAt = contractPosition.getModifiedAt();
                product = contractPosition.getProduct();
                originId = contract.getContractNumber() + "/" + contractPosition.getLineItemNumber();
                originContextParams = Arrays.asList(contract.getContractNumber(), Long.toString(contractPosition.getLineItemNumber()));
                bookingText = contract.getContractNumber() + " / " + contractPosition.getLineItemNumber() + " / " + contractPosition.getName();
            } else if (contributionSource instanceof InvoicePosition) {
                contractPosition = (InvoicePosition)contributionSource;
                contract = (AbstractContract)pm.getObjectById((Object)contractPosition.refGetPath().getParent().getParent());
                valueDate = contractPosition.getModifiedAt();
                lastCalculatedAt = contractPosition.getModifiedAt();
                product = contractPosition.getProduct();
                originId = contract.getContractNumber() + "/" + contractPosition.getLineItemNumber();
                originContextParams = Arrays.asList(contract.getContractNumber(), Long.toString(contractPosition.getLineItemNumber()));
                bookingText = contract.getContractNumber() + " / " + contractPosition.getLineItemNumber() + " / " + contractPosition.getName();
            }
            SalesVolumeBudgetHasPosition.Position budgetPositions = budget.getPosition();
            Iterator iterator = budgetPositions.iterator();
            while (iterator.hasNext()) {
                SalesContractPosition contractPosition2;
                SalesVolumeBudgetPosition budgetPosition = (SalesVolumeBudgetPosition)iterator.next();
                boolean matches = false;
                BigDecimal quantity = null;
                if (budgetPosition instanceof QuantityBasedSalesVolumeBudgetPosition) {
                    QuantityBasedSalesVolumeBudgetPosition quantityBasedBudgetPosition = (QuantityBasedSalesVolumeBudgetPosition)budgetPosition;
                    if (contributionSource instanceof SalesContractPosition) {
                        contractPosition2 = (SalesContractPosition)contributionSource;
                        quantity = contractPosition2.getQuantity();
                        matches = quantityBasedBudgetPosition.getUom() == null || quantityBasedBudgetPosition.getUom().equals(contractPosition2.getUom());
                    }
                } else if (budgetPosition instanceof ValueBasedSalesVolumeBudgetPosition) {
                    ValueBasedSalesVolumeBudgetPosition valueBasedBudgetPosition = (ValueBasedSalesVolumeBudgetPosition)budgetPosition;
                    if (contributionSource instanceof SalesContractPosition) {
                        contractPosition2 = (SalesContractPosition)contributionSource;
                        SalesContract contract2 = (SalesContract)pm.getObjectById((Object)contractPosition2.refGetPath().getParent().getParent());
                        matches = valueBasedBudgetPosition.getCurrency() == contract2.getContractCurrency();
                        switch (valueBasedBudgetPosition.getValueType()) {
                            case 0: 
                            case 1: {
                                quantity = contractPosition2.getBaseAmount();
                                break;
                            }
                            case 2: {
                                quantity = contractPosition2.getAmount();
                                break;
                            }
                            case 3: {
                                quantity = contractPosition2.getDiscountAmount();
                                break;
                            }
                            case 4: {
                                quantity = contractPosition2.getPricePerUnit();
                            }
                        }
                    }
                }
                if (matches && product != null) {
                    ProductQuery productQuery = (ProductQuery)pm.newQuery(Product.class);
                    productQuery.thereExistsProductNumber().equalTo((Object)product.getProductNumber());
                    boolean bl = matches = !budgetPosition.getFilteredProduct(productQuery).isEmpty();
                }
                if (!matches || quantity == null) continue;
                DepotPosition depotPosition = budgetPosition.getDepotPosition();
                if (budgetPosition.getDepotPosition() == null) {
                    depotPosition = Depots.getInstance().openDepotPosition(budget.getDepot(), budgetPosition.getName(), null, budget.getStartingFrom(), null, null, false);
                    budgetPosition.setDepotPosition(depotPosition);
                }
                SimpleBooking booking = null;
                SimpleBookingQuery bookingQuery = (SimpleBookingQuery)pm.newQuery(SimpleBooking.class);
                bookingQuery.thereExistsOriginContext().equalTo((Object)contributionSource);
                List bookings = depotPosition.getSimpleBooking(bookingQuery);
                if (bookings.isEmpty()) {
                    booking = (SimpleBooking)pm.newInstance(SimpleBooking.class);
                    booking.setName(bookingText);
                    if (originId != null) {
                        booking.setOriginId(originId);
                    }
                    if (originContextParams != null) {
                        booking.getOriginContextParams().addAll(originContextParams);
                    }
                    booking.setPosition(depotPosition);
                    if (contributionSource instanceof BasicObject) {
                        booking.getOriginContext().add((BasicObject)contributionSource);
                    }
                    booking.setBookingDate(new Date());
                    booking.setBookingType(Depots.BookingType.STANDARD.getValue());
                    booking.setBookingStatus(Depots.BookingStatus.PENDING.getValue());
                    depotSegment.addSimpleBooking(this.getUidAsString(), booking);
                } else {
                    booking = (SimpleBooking)bookings.iterator().next();
                }
                booking.setValueDate(valueDate);
                if (budgetPosition.getContributionFactor() != null) {
                    quantity = quantity.multiply(budgetPosition.getContributionFactor());
                    if (budgetPosition.getContributionRoundingFactor() != null) {
                        long roundedQuantity = quantity.multiply(budgetPosition.getContributionRoundingFactor()).longValue();
                        quantity = new BigDecimal(roundedQuantity).divide(budgetPosition.getContributionRoundingFactor());
                    }
                }
                booking.setQuantity(quantity);
            }
        }
        budget.setLastCalculatedAt(lastCalculatedAt == null ? new Date() : lastCalculatedAt);
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof AbstractBudget) {
            this.updateBudget((AbstractBudget)object);
        }
    }
}

