/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.oasisopen.cci2.QualifierType;
import org.oasisopen.jmi1.RefContainer;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.base.jmi1.SecureObject;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.cci2.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.marshalling.Marshaller;
import org.openmdx.base.persistence.cci.PersistenceHelper;

public class Cloneable
extends AbstractImpl {
    public static final Set<String> CLONE_EXCLUDE_ATTRIBUTES = new HashSet<String>(Arrays.asList("activityNumber", "contractNumber"));
    public static final Set<String> CLONE_EXCLUDE_COMPOSITE_REFERENCES = new HashSet<String>(Arrays.asList("view"));
    public static final int MANUAL_QUALIFIER_THRESHOLD = 10;

    public static void register() {
        Cloneable.registerImpl(new Cloneable());
    }

    public static Cloneable getInstance() throws ServiceException {
        return Cloneable.getInstance(Cloneable.class);
    }

    protected Cloneable() {
    }

    protected Set<String> getReferenceFilter(String referenceFilterAsString) {
        HashSet<String> referenceFilter;
        HashSet<String> hashSet = referenceFilter = referenceFilterAsString == null ? null : new HashSet<String>();
        if (referenceFilter != null && referenceFilterAsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(referenceFilterAsString, " ;,", false);
            while (tokenizer.hasMoreTokens()) {
                referenceFilter.add(tokenizer.nextToken());
            }
        }
        return referenceFilter;
    }

    public RefObject_1_0 cloneObject(RefObject_1_0 original, RefObject_1_0 target, String referenceName, Map<String, Marshaller> objectMarshallers, String referenceFilterAsString, User owningUser, List<PrincipalGroup> owningGroup) throws ServiceException {
        Set<String> referenceFilter = this.getReferenceFilter(referenceFilterAsString);
        RefObject_1_0 cloned = this.cloneObject(original, target, referenceName, CLONE_EXCLUDE_ATTRIBUTES, objectMarshallers, referenceFilter, owningUser, owningGroup);
        return cloned;
    }

    public RefObject_1_0 cloneObject(RefObject_1_0 object, RefObject_1_0 target, String referenceName, Set<String> excludeAttributes, Map<String, Marshaller> objectMarshallers, Set<String> referenceFilter, User owningUser, List<PrincipalGroup> owningGroup) throws ServiceException {
        CloneContext cloneContext = (CloneContext)Utils.traverseObjectTree(object, referenceFilter, new CloneCallback(excludeAttributes, objectMarshallers, owningUser, owningGroup), new CloneContext(target, referenceName));
        return cloneContext.target;
    }

    private static class CloneCallback
    implements Utils.TraverseObjectTreeCallback {
        private final Set<String> excludeAttributes;
        private final Map<String, Marshaller> objectMarshallers;
        private final User owningUser;
        private final List<PrincipalGroup> owningGroup;

        public CloneCallback(Set<String> excludeAttributes, Map<String, Marshaller> objectMarshallers, User owningUser, List<PrincipalGroup> owningGroup) {
            this.excludeAttributes = excludeAttributes;
            this.objectMarshallers = objectMarshallers;
            this.owningUser = owningUser;
            this.owningGroup = owningGroup;
        }

        @Override
        public Object visit(RefObject_1_0 object, Object context) throws ServiceException {
            CloneContext cloneContext = (CloneContext)context;
            String objectType = object.refClass().refMofId();
            RefObject_1_0 clone = null;
            clone = this.objectMarshallers != null && this.objectMarshallers.get(objectType) != null ? (RefObject_1_0)this.objectMarshallers.get(objectType).marshal((Object)object) : (RefObject_1_0)PersistenceHelper.clone((Object)object, (String[])new String[0]);
            if (clone instanceof SecureObject) {
                if (this.owningUser != null) {
                    ((SecureObject)clone).setOwningUser(this.owningUser);
                }
                if (this.owningGroup != null) {
                    ((SecureObject)clone).getOwningGroup().clear();
                    ((SecureObject)clone).getOwningGroup().addAll(this.owningGroup);
                }
            }
            RefContainer container = (RefContainer)cloneContext.target.refGetValue(cloneContext.targetReferenceName != null ? cloneContext.targetReferenceName : object.refGetPath().getParent().getLastSegment().toString());
            container.refAdd(new Object[]{QualifierType.REASSIGNABLE, Utils.getUidAsString(), clone});
            if (this.excludeAttributes != null) {
                for (String excludeAttribute : this.excludeAttributes) {
                    try {
                        clone.refSetValue(excludeAttribute, null);
                    }
                    catch (Exception exception) {}
                }
            }
            return new CloneContext(clone, null);
        }
    }

    private static class CloneContext {
        public final RefObject_1_0 target;
        public final String targetReferenceName;

        public CloneContext(RefObject_1_0 target, String targetReferenceName) {
            this.target = target;
            this.targetReferenceName = targetReferenceName;
        }
    }
}

