/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipInputStream;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.resource.ResourceException;
import javax.resource.cci.MappedRecord;
import javax.servlet.http.HttpServletRequest;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAssignment;
import org.opencrx.kernel.account1.jmi1.AssignedAccountAssignment;
import org.opencrx.kernel.account1.jmi1.ContactRelationship;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.RevenueReport;
import org.opencrx.kernel.activity1.jmi1.AbstractActivityParty;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroupAssignment;
import org.opencrx.kernel.activity1.jmi1.ActivityLinkFrom;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.AddressGroupMember;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.opencrx.kernel.activity1.jmi1.EMailRecipientGroup;
import org.opencrx.kernel.activity1.jmi1.IncidentParty;
import org.opencrx.kernel.activity1.jmi1.MailingRecipient;
import org.opencrx.kernel.activity1.jmi1.MailingRecipientGroup;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.activity1.jmi1.PhoneCallRecipient;
import org.opencrx.kernel.activity1.jmi1.PhoneCallRecipientGroup;
import org.opencrx.kernel.activity1.jmi1.TaskParty;
import org.opencrx.kernel.address1.jmi1.Addressable;
import org.opencrx.kernel.address1.jmi1.EMailAddressable;
import org.opencrx.kernel.address1.jmi1.PhoneNumberAddressable;
import org.opencrx.kernel.address1.jmi1.PostalAddressable;
import org.opencrx.kernel.address1.jmi1.RoomAddressable;
import org.opencrx.kernel.address1.jmi1.UriAddressable;
import org.opencrx.kernel.address1.jmi1.WebAddressable;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.base.cci2.HashEntryQuery;
import org.opencrx.kernel.base.jmi1.AuditEntry;
import org.opencrx.kernel.base.jmi1.Chart;
import org.opencrx.kernel.base.jmi1.HashEntry;
import org.opencrx.kernel.base.jmi1.Hashable;
import org.opencrx.kernel.base.jmi1.Note;
import org.opencrx.kernel.building1.jmi1.AbstractBuildingUnit;
import org.opencrx.kernel.building1.jmi1.InventoryItem;
import org.opencrx.kernel.code1.jmi1.CodeValueEntry;
import org.opencrx.kernel.code1.jmi1.SimpleEntry;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.AccountAddress;
import org.opencrx.kernel.contract1.jmi1.ContractRole;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.depot1.jmi1.AggregatedDepotReportItem;
import org.opencrx.kernel.depot1.jmi1.CompoundBooking;
import org.opencrx.kernel.depot1.jmi1.Depot;
import org.opencrx.kernel.depot1.jmi1.DepotContract;
import org.opencrx.kernel.depot1.jmi1.DepotEntity;
import org.opencrx.kernel.depot1.jmi1.DepotPosition;
import org.opencrx.kernel.depot1.jmi1.DepotReport;
import org.opencrx.kernel.depot1.jmi1.DepotReportItemPosition;
import org.opencrx.kernel.depot1.jmi1.SimpleBooking;
import org.opencrx.kernel.depot1.jmi1.SingleBooking;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.generic.cci2.CrxObjectHasMedia;
import org.opencrx.kernel.generic.cci2.EnableDisableCrxObjectResult;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.Description;
import org.opencrx.kernel.generic.jmi1.DocumentAttachment;
import org.opencrx.kernel.generic.jmi1.EnableDisableCrxObjectResult;
import org.opencrx.kernel.generic.jmi1.InvolvedObject;
import org.opencrx.kernel.generic.jmi1.Media;
import org.opencrx.kernel.generic.jmi1.Rating;
import org.opencrx.kernel.home1.cci2.AlertQuery;
import org.opencrx.kernel.home1.jmi1.AccessHistory;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.model1.jmi1.Element;
import org.opencrx.kernel.product1.jmi1.AbstractPriceLevel;
import org.opencrx.kernel.product1.jmi1.AbstractProduct;
import org.opencrx.kernel.product1.jmi1.PriceListEntry;
import org.opencrx.kernel.product1.jmi1.ProductBasePrice;
import org.opencrx.kernel.text.ExcelToText;
import org.opencrx.kernel.text.OpenOfficeToText;
import org.opencrx.kernel.text.PDFToText;
import org.opencrx.kernel.text.RTFToText;
import org.opencrx.kernel.text.WordToText;
import org.opencrx.kernel.text.XmlDocToText;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.opencrx.kernel.utils.TinyUrlUtils;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.workflow1.jmi1.WfProcess;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.mof.cci.ModelElement_1_0;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.query.IsInCondition;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.resource.Records;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryFilterRecord;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.rest.spi.QueryRecord;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.portal.servlet.Action;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Base
extends AbstractImpl {
    public static final String PRIVATE_SUFFIX = "~Private";
    public static final short IMPORT_EXPORT_OK = 0;
    public static final short IMPORT_EXPORT_FORMAT_NOT_SUPPORTED = 1;
    public static final short IMPORT_EXPORT_ITEM_NOT_VALID = 2;
    public static final short IMPORT_EXPORT_MISSING_DATA = 3;
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String COMMENT_SEPARATOR_BOT = "//";
    public static final String COMMENT_SEPARATOR_EOT = " //";
    public static final List<String> ASSIGN_TO_ME_ATTRIBUTES = Arrays.asList("assignedTo", "salesRep", "ratedBy");

    public static void register() {
        Base.registerImpl(new Base());
    }

    public static Base getInstance() throws ServiceException {
        return Base.getInstance(Base.class);
    }

    protected Base() {
    }

    public List<Path> sendAlert(ContextCapable target, String toUsers, String name, String description, short importance, Integer resendDelayInSeconds, ContextCapable reference) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)target);
        StringTokenizer tokenizer = new StringTokenizer(toUsers == null ? "" : toUsers, ";, ");
        ArrayList<Path> alertIdentities = new ArrayList<Path>();
        while (tokenizer.hasMoreTokens()) {
            String toUser = tokenizer.nextToken();
            UserHome userHome = UserHomes.getInstance().getUserHome(toUser, target.refGetPath(), pm);
            if (userHome == null) continue;
            Path referenceIdentity = reference == null || !JDOHelper.isPersistent((Object)reference) ? target.refGetPath() : reference.refGetPath();
            PersistenceManager pmRoot = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            ContextCapable alertReference = (ContextCapable)pmRoot.getObjectById((Object)referenceIdentity);
            AlertQuery alertQuery = (AlertQuery)pmRoot.newQuery(Alert.class);
            alertQuery.thereExistsReference().equalTo((Object)alertReference);
            alertQuery.createdAt().greaterThanOrEqualTo((Comparable)new Date(System.currentTimeMillis() - (long)(1000 * (resendDelayInSeconds == null ? 0 : resendDelayInSeconds))));
            UserHome userHomeByRoot = (UserHome)pmRoot.getObjectById((Object)userHome.refGetPath());
            List existingAlerts = userHomeByRoot.getAlert(alertQuery);
            if (!existingAlerts.isEmpty()) continue;
            Alert alert = (Alert)pmRoot.newInstance(Alert.class);
            alert.setAlertState(new Short(1));
            alert.setName(name == null || name.length() == 0 ? "--" : name);
            if (description != null) {
                alert.setDescription(description);
            }
            alert.setImportance(importance);
            alert.setReference((org.openmdx.base.cci2.ContextCapable)alertReference);
            alert.getOwningGroup().clear();
            alert.getOwningGroup().addAll(userHomeByRoot.getOwningGroup());
            alert.setAccessLevelDelete((short)1);
            alert.setAccessLevelUpdate((short)1);
            pmRoot.currentTransaction().begin();
            userHomeByRoot.addAlert(this.getUidAsString(), alert);
            pmRoot.currentTransaction().commit();
            alertIdentities.add(alert.refGetPath());
            pmRoot.close();
        }
        return alertIdentities;
    }

    public void assignToMe(RefObject_1_0 target, boolean overwrite, boolean useRunAsPrincipal) throws ServiceException {
        UserHome userHome;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)target);
        String objectClass = target.refClass().refMofId();
        Model_1_0 model = Model_1Factory.getModel();
        ModelElement_1_0 classDef = model.getElement((Object)objectClass);
        Map attributeDefs = model.getAttributeDefs(classDef, false, true);
        List principalChain = UserObjects.getPrincipalChain((PersistenceManager)pm);
        if (!principalChain.isEmpty() && (userHome = UserHomes.getInstance().getUserHome(target.refGetPath(), pm, useRunAsPrincipal)) != null && userHome.getContact() != null) {
            for (String attribute : ASSIGN_TO_ME_ATTRIBUTES) {
                if (!attributeDefs.keySet().contains(attribute) || !overwrite && target.refGetValue(attribute) != null) continue;
                target.refSetValue(attribute, (Object)userHome.getContact());
            }
        }
    }

    public String analyseReport(List<String> report) {
        HashMap<String, Short> reportAsMap = new HashMap<String, Short>();
        for (int i = 0; i < report.size(); ++i) {
            String key = report.get(i);
            Short count = (Short)reportAsMap.get(key);
            if (count == null) {
                count = new Short(0);
            }
            reportAsMap.put(key, new Short((short)(count + 1)));
        }
        return ((Object)reportAsMap).toString();
    }

    public String getAccessUrl(Object context, String contextPattern, RefObject_1_0 object) {
        return this.getAccessUrl(context, contextPattern, object, false);
    }

    public String getAccessUrl(Object context, String contextPattern, RefObject_1_0 object, boolean asTinyUrl) {
        if (context instanceof HttpServletRequest) {
            String fullUrl;
            HttpServletRequest req = (HttpServletRequest)context;
            String urlPrefix = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
            Action selectObjectAction = new Action(6, new Action.Parameter[]{new Action.Parameter("xri", object.refMofId())}, "", true);
            String url = fullUrl = urlPrefix + req.getContextPath().replace(contextPattern, "-core-") + "/" + "ObjectInspectorServlet" + "?event=" + 6 + "&parameter=" + selectObjectAction.getParameter();
            if (asTinyUrl) {
                String tinyUrl = TinyUrlUtils.getTinyUrl(fullUrl);
                url = tinyUrl != null ? tinyUrl : fullUrl;
            }
            return url;
        }
        if (context instanceof UserHome) {
            UserHome userHome = (UserHome)context;
            String urlPrefix = userHome.getWebAccessUrl();
            if (urlPrefix != null) {
                String fullUrl;
                Action selectObjectAction = new Action(6, new Action.Parameter[]{new Action.Parameter("xri", object.refMofId())}, "", true);
                String url = fullUrl = urlPrefix + (urlPrefix.endsWith("/") ? "" : "/") + "ObjectInspectorServlet" + "?event=" + 6 + "&parameter=" + selectObjectAction.getParameter();
                if (asTinyUrl) {
                    String tinyUrl = TinyUrlUtils.getTinyUrl(fullUrl);
                    url = tinyUrl != null ? tinyUrl : fullUrl;
                }
                return url;
            }
            return null;
        }
        return null;
    }

    public boolean isAccessUrl(String url) {
        return url.indexOf("ObjectInspectorServlet") > 0 || url.startsWith("http://tinyurl.com/");
    }

    public void createOrUpdateMedia(CrxObject object, String contentType, String contentName, InputStream content) throws IOException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
        CrxObjectHasMedia.Media medias = object.getMedia();
        org.opencrx.kernel.document1.cci2.Media media = null;
        Iterator iterator = medias.iterator();
        while (iterator.hasNext()) {
            Media attachment = (Media)iterator.next();
            if (contentName == null || !contentName.equals(attachment.getContentName())) continue;
            media = attachment;
            break;
        }
        if (media == null) {
            media = (Media)pm.newInstance(Media.class);
            object.addMedia(this.getUidAsString(), (Media)media);
            media.setContentName(contentName == null ? Utils.toFilename(contentType) : contentName);
        }
        media.setContentMimeType(contentType);
        media.setContent(BinaryLargeObjects.valueOf((InputStream)content));
        media.getOwningGroup().addAll(object.getOwningGroup());
    }

    public String toPlain(Object obj) {
        String s = obj == null ? "" : (obj instanceof Collection && !((Collection)obj).isEmpty() ? ((Collection)obj).iterator().next().toString() : obj.toString());
        return s;
    }

    public String getTitle(RefObject_1_0 refObj, CodeMapper codeMapper, short locale, boolean asShortTitle) throws ServiceException {
        if (refObj == null) {
            return "#NULL";
        }
        if (JDOHelper.isNew((Object)refObj) || !JDOHelper.isPersistent((Object)refObj)) {
            return this.toPlain("Untitled");
        }
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)refObj);
            String localeAsString = "en_US";
            if (codeMapper != null) {
                try {
                    localeAsString = codeMapper.getLocaleText(locale);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String language = "en";
            if (localeAsString.indexOf("_") > 0) {
                language = localeAsString.substring(0, 2);
            }
            DateFormat dateFormat = Utils.getDateFormat(language);
            DateFormat timeFormat = Utils.getTimeFormat(language);
            DecimalFormat decimalFormat = Utils.getDecimalFormat(language);
            if (refObj instanceof Account) {
                Account obj = (Account)refObj;
                return this.toPlain(obj.getFullName());
            }
            if (refObj instanceof ProductBasePrice) {
                ProductBasePrice obj = (ProductBasePrice)refObj;
                try {
                    return this.toPlain(obj.getPrice() == null ? "N/A" : decimalFormat.format(obj.getPrice().doubleValue())) + this.toPlain(" ") + this.toPlain(codeMapper == null ? Short.valueOf(obj.getPriceCurrency()) : codeMapper.getCurrencyText(obj.getPriceCurrency(), locale));
                }
                catch (Exception e) {
                    return this.toPlain(obj.getPrice() == null ? "N/A" : decimalFormat.format(obj.getPrice().doubleValue())) + this.toPlain(" N/A");
                }
            }
            if (refObj instanceof PriceListEntry) {
                PriceListEntry obj = (PriceListEntry)refObj;
                return this.toPlain(obj.getProductName());
            }
            if (refObj instanceof Activity) {
                Activity obj = (Activity)refObj;
                return this.toPlain(obj.getActivityNumber()).trim() + this.toPlain(": ") + this.toPlain(obj.getName());
            }
            if (refObj instanceof ActivityProcessState) {
                ActivityProcessState obj = (ActivityProcessState)refObj;
                return this.toPlain(obj.getName());
            }
            if (refObj instanceof ActivityFollowUp) {
                ActivityFollowUp followUp = (ActivityFollowUp)refObj;
                Activity activity = null;
                try {
                    activity = (Activity)pm.getObjectById((Object)followUp.refGetPath().getParent().getParent());
                    activity.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return activity == null ? "" : this.getTitle(activity, codeMapper, locale, asShortTitle) + this.toPlain(": ") + this.toPlain(followUp.getTitle());
            }
            if (refObj instanceof ActivityGroup) {
                ActivityGroup obj = (ActivityGroup)refObj;
                return obj == null ? this.toPlain("Untitled") : this.toPlain(obj.getName());
            }
            if (refObj instanceof ActivityGroupAssignment) {
                ActivityGroupAssignment obj = (ActivityGroupAssignment)refObj;
                return obj == null ? this.toPlain("Untitled") : this.getTitle(obj.getActivityGroup(), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof AddressGroupMember) {
                AddressGroupMember member = (AddressGroupMember)refObj;
                org.opencrx.kernel.account1.jmi1.AccountAddress address = member.getAddress();
                if (address instanceof PhoneNumber) {
                    Account account = (Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
                    return this.getTitle(address, codeMapper, locale, asShortTitle) + this.toPlain(" / ") + this.toPlain(account.getFullName());
                }
                return address == null ? this.toPlain("Untitled") : this.getTitle(address, codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof AbstractActivityParty) {
                CrxObject party = null;
                if (refObj instanceof EMailRecipient || refObj instanceof PhoneCallRecipient) {
                    AbstractActivityParty recipient;
                    org.opencrx.kernel.account1.jmi1.AccountAddress address = null;
                    if (refObj instanceof EMailRecipient) {
                        recipient = (EMailRecipient)refObj;
                        address = recipient.getParty();
                        if (address instanceof EMailAddress) {
                            String messageBody;
                            String title = this.getTitle(address, codeMapper, locale, asShortTitle);
                            if (asShortTitle) {
                                return title;
                            }
                            EMail email = (EMail)pm.getObjectById((Object)recipient.refGetPath().getParent().getParent());
                            String messageSubject = email.getMessageSubject() == null ? "" : URLEncoder.encode(email.getMessageSubject(), "UTF-8").replace("+", "%20");
                            String string = messageBody = email.getMessageBody() == null ? "" : URLEncoder.encode(email.getMessageBody(), "UTF-8").replace("+", "%20");
                            if (messageBody.length() > 1500) {
                                messageBody = messageBody.substring(0, 1500);
                            }
                            return title + (title.indexOf("@") > 0 ? "?subject=" + messageSubject + "&body=" + messageBody : "");
                        }
                    } else {
                        recipient = (PhoneCallRecipient)refObj;
                        address = recipient.getParty();
                    }
                    if (address instanceof PhoneNumber) {
                        Account account = (Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
                        return this.getTitle(address, codeMapper, locale, asShortTitle) + this.toPlain(" / ") + this.toPlain(account.getFullName());
                    }
                    return address == null ? this.toPlain("Untitled") : this.getTitle(address, codeMapper, locale, asShortTitle);
                }
                if (refObj instanceof EMailRecipientGroup) {
                    party = ((EMailRecipientGroup)refObj).getParty();
                } else if (refObj instanceof IncidentParty) {
                    party = ((IncidentParty)refObj).getParty();
                } else if (refObj instanceof MailingRecipient) {
                    party = ((MailingRecipient)refObj).getParty();
                } else if (refObj instanceof MailingRecipientGroup) {
                    party = ((MailingRecipientGroup)refObj).getParty();
                } else if (refObj instanceof MeetingParty) {
                    party = ((MeetingParty)refObj).getParty();
                } else if (refObj instanceof TaskParty) {
                    party = ((TaskParty)refObj).getParty();
                } else if (refObj instanceof PhoneCallRecipientGroup) {
                    party = ((PhoneCallRecipientGroup)refObj).getParty();
                }
                String emailHint = ((AbstractActivityParty)refObj).getEmailHint();
                return party == null ? this.toPlain("Untitled") : this.getTitle(party, codeMapper, locale, asShortTitle) + (emailHint == null ? "" : this.toPlain(" (" + emailHint + ")"));
            }
            if (refObj instanceof AccountAddress) {
                return refObj.refGetValue("address") == null ? this.toPlain("Untitled") : this.getTitle((RefObject_1_0)refObj.refGetValue("address"), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof EMailAddressable) {
                return "* " + this.toPlain(refObj.refGetValue("emailAddress"));
            }
            if (refObj instanceof SalesContractPosition) {
                return this.toPlain(refObj.refGetValue("lineItemNumber")) + " / " + this.toPlain(refObj.refGetValue("name"));
            }
            if (refObj instanceof AbstractProduct) {
                AbstractProduct product = (AbstractProduct)refObj;
                return product.getProductNumber() == null || product.getProductNumber().isEmpty() || product.getProductNumber().equals(product.getName()) ? this.toPlain(product.getName()) : this.toPlain(product.getName() + this.toPlain(" / ") + this.toPlain(product.getProductNumber()));
            }
            if (refObj instanceof PostalAddressable) {
                String address = "";
                int nLines = 0;
                List postalAddressLines = (List)refObj.refGetValue("postalAddressLine");
                for (Object l : postalAddressLines) {
                    String line = this.toPlain(l);
                    if (nLines > 0) {
                        address = address + "\n";
                    }
                    address = address + line;
                    ++nLines;
                }
                List postalStreetLines = (List)refObj.refGetValue("postalStreet");
                for (String l : postalStreetLines) {
                    String street = this.toPlain(l);
                    if (nLines > 0) {
                        address = address + "\n";
                    }
                    address = address + street;
                    ++nLines;
                }
                Number postalCountry = (Number)refObj.refGetValue("postalCountry");
                String postalCountryS = postalCountry == null ? "" : (codeMapper == null ? "" + postalCountry : this.toPlain(codeMapper.getCountryText(postalCountry.shortValue(), locale)));
                return address + "\n" + this.toPlain(refObj.refGetValue("postalCode")) + this.toPlain(" ") + this.toPlain(refObj.refGetValue("postalCity")) + "\n" + postalCountryS;
            }
            if (refObj instanceof PhoneNumberAddressable) {
                return "* " + this.toPlain(refObj.refGetValue("phoneNumberFull"));
            }
            if (refObj instanceof UriAddressable) {
                String uriReference = (String)refObj.refGetValue("uriReference");
                String uriScheme = (String)refObj.refGetValue("uriScheme");
                return uriScheme != null && uriReference != null && !uriReference.startsWith(uriScheme) ? this.toPlain(uriScheme) + "://" + this.toPlain(uriReference) : this.toPlain(uriReference);
            }
            if (refObj instanceof RoomAddressable) {
                RoomAddressable obj = (RoomAddressable)refObj;
                if (refObj instanceof Addressable) {
                    AbstractBuildingUnit building = ((Addressable)refObj).getBuilding();
                    if (building == null) {
                        return this.toPlain(obj.getRoomNumber());
                    }
                    return this.getTitle(building, codeMapper, locale, asShortTitle) + this.toPlain(" ") + this.toPlain(obj.getRoomNumber());
                }
                return this.toPlain(obj.getRoomNumber());
            }
            if (refObj instanceof Rating) {
                return this.toPlain(refObj.refGetValue("ratingLevel"));
            }
            if (refObj instanceof RevenueReport) {
                return this.toPlain(refObj.refGetValue("reportNumber"));
            }
            if (refObj instanceof WebAddressable) {
                return "* " + this.toPlain(refObj.refGetValue("webUrl"));
            }
            if (refObj instanceof CodeValueEntry) {
                return this.toPlain(refObj.refGetValue("shortText"));
            }
            if (refObj instanceof Description) {
                return this.toPlain(refObj.refGetValue("language"));
            }
            if (refObj instanceof Document) {
                Document document = (Document)refObj;
                if (document.getQualifiedName() != null) {
                    return this.toPlain(document.getQualifiedName());
                }
                if (document.getName() != null) {
                    return this.toPlain(document.getName());
                }
                return this.toPlain(document.getDocumentNumber());
            }
            if (refObj instanceof DocumentAttachment) {
                DocumentAttachment documentAttachment = (DocumentAttachment)refObj;
                if (documentAttachment.getName() == null || documentAttachment.getName().isEmpty()) {
                    if (documentAttachment.getDocument() == null) {
                        return "NA";
                    }
                    return this.getTitle(documentAttachment.getDocument(), codeMapper, locale, asShortTitle);
                }
                return this.toPlain(documentAttachment.getName());
            }
            if (refObj instanceof Member) {
                return refObj.refGetValue("account") == null ? this.toPlain("Untitled") : this.getTitle((RefObject_1_0)refObj.refGetValue("account"), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof ContactRelationship) {
                return refObj.refGetValue("toContact") == null ? this.toPlain("Untitled") : this.getTitle((RefObject_1_0)refObj.refGetValue("toContact"), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof UserHome) {
                UserHome userHome = (UserHome)refObj;
                return this.getTitle(userHome.getContact(), codeMapper, locale, asShortTitle) + this.toPlain(" (") + this.toPlain(userHome.refGetPath().getLastSegment().toString()) + this.toPlain(")");
            }
            if (refObj instanceof AccessHistory) {
                return refObj.refGetValue("reference") == null ? this.toPlain("Untitled") : this.getTitle((RefObject_1_0)refObj.refGetValue("reference"), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof WfProcessInstance) {
                WfProcessInstance wfProcessInstance = (WfProcessInstance)refObj;
                return wfProcessInstance.getName() != null ? this.toPlain(wfProcessInstance.getName()) : (wfProcessInstance.getProcess() == null ? this.toPlain("Untitled") : this.getTitle(wfProcessInstance.getProcess(), codeMapper, locale, asShortTitle) + this.toPlain(" ") + this.toPlain(refObj.refGetValue("startedOn")));
            }
            if (refObj instanceof WfProcess) {
                return this.toPlain(((WfProcess)refObj).getName());
            }
            if (refObj instanceof AuditEntry) {
                Object createdAt = refObj.refGetValue("createdAt");
                return refObj.refGetValue("createdAt") == null ? this.toPlain("Untitled") : this.toPlain(dateFormat.format(createdAt)) + this.toPlain(" ") + this.toPlain(timeFormat.format(createdAt));
            }
            if (refObj instanceof Note) {
                return this.toPlain(refObj.refGetValue("title"));
            }
            if (refObj instanceof Chart) {
                return this.toPlain(refObj.refGetValue("description"));
            }
            if (refObj instanceof Element) {
                String title = this.toPlain(refObj.refGetValue("qualifiedName"));
                if (title.indexOf(":") > 0) {
                    int pos = title.lastIndexOf(":");
                    title = title.substring(pos + 1) + this.toPlain(" (") + title.substring(0, pos) + this.toPlain(")");
                }
                return title;
            }
            if (refObj instanceof DepotEntity) {
                DepotEntity obj = (DepotEntity)refObj;
                return obj.getDepotEntityNumber() == null ? this.toPlain(obj.getName()) : this.toPlain(obj.getDepotEntityNumber());
            }
            if (refObj instanceof DepotContract) {
                DepotContract obj = (DepotContract)refObj;
                return obj.getDepotHolderNumber() == null ? this.toPlain(obj.getName()) : this.toPlain(obj.getDepotHolderNumber());
            }
            if (refObj instanceof Depot) {
                Depot obj = (Depot)refObj;
                return obj.getDepotNumber() == null ? this.toPlain(obj.getName()) : this.toPlain(obj.getDepotNumber());
            }
            if (refObj instanceof DepotPosition) {
                DepotPosition obj = (DepotPosition)refObj;
                String depotTitle = this.getTitle(obj.getDepot(), codeMapper, locale, asShortTitle);
                return depotTitle + this.toPlain(" / ") + this.toPlain(obj.getName());
            }
            if (refObj instanceof DepotReport) {
                DepotReport obj = (DepotReport)refObj;
                String depotTitle = this.getTitle(obj.getDepot(), codeMapper, locale, asShortTitle);
                return depotTitle + this.toPlain(" / ") + this.toPlain(obj.getName());
            }
            if (refObj instanceof DepotReportItemPosition) {
                DepotReportItemPosition obj = (DepotReportItemPosition)refObj;
                return this.toPlain(obj.getPositionName());
            }
            if (refObj instanceof SimpleEntry) {
                SimpleEntry obj = (SimpleEntry)refObj;
                return this.toPlain(obj.getEntryValue());
            }
            if (refObj instanceof Media) {
                Media obj = (Media)refObj;
                return this.toPlain(obj.getContentName());
            }
            if (refObj instanceof ContractRole) {
                ContractRole contractRole = (ContractRole)refObj;
                return this.getTitle(contractRole.getContract(), codeMapper, locale, asShortTitle) + this.toPlain(" / ") + this.getTitle(contractRole.getAccount(), codeMapper, locale, asShortTitle) + this.toPlain(" / ") + this.getTitle(contractRole.getContractReferenceHolder(), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof InvolvedObject) {
                InvolvedObject involved = (InvolvedObject)refObj;
                RefObject_1_0 parentInvolved = (RefObject_1_0)pm.getObjectById((Object)involved.refGetPath().getParent().getParent());
                return this.getTitle(parentInvolved, codeMapper, locale, asShortTitle) + this.toPlain(": ") + this.getTitle(involved.getInvolved(), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof AccountAssignment) {
                AccountAssignment obj = (AccountAssignment)refObj;
                return this.getTitle(obj.getAccount(), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof AssignedAccountAssignment) {
                AssignedAccountAssignment obj = (AssignedAccountAssignment)refObj;
                return this.getTitle(obj.getAccountAssignment(), codeMapper, locale, asShortTitle);
            }
            if (refObj instanceof Uom) {
                return this.toPlain(((Uom)refObj).getName());
            }
            if (refObj instanceof AbstractPriceLevel) {
                return this.toPlain(((AbstractPriceLevel)refObj).getName());
            }
            if (refObj instanceof DocumentRevision) {
                if (refObj instanceof MediaContent) {
                    return this.toPlain(((MediaContent)refObj).getContentName());
                }
                return this.toPlain(((DocumentRevision)refObj).getName());
            }
            if (refObj instanceof InventoryItem) {
                return this.toPlain(((InventoryItem)refObj).getName());
            }
            if (refObj instanceof ActivityLinkFrom) {
                ActivityLinkFrom linkFrom = (ActivityLinkFrom)refObj;
                return this.toPlain(linkFrom.getName()) + this.toPlain(" (") + this.getTitle(linkFrom.getLinkFrom(), codeMapper, locale, asShortTitle) + this.toPlain(")");
            }
            if (refObj instanceof DocumentFolder) {
                DocumentFolder folder = (DocumentFolder)refObj;
                return (folder.getParent() == null ? "" : this.getTitle(folder.getParent(), codeMapper, locale, asShortTitle)) + this.toPlain("/") + this.toPlain(folder.getName());
            }
            if (refObj instanceof AggregatedDepotReportItem) {
                return this.toPlain(((AggregatedDepotReportItem)refObj).getPositionName());
            }
            if (refObj instanceof AbstractContract) {
                return this.toPlain(((AbstractContract)refObj).getName());
            }
            if (refObj instanceof SingleBooking) {
                return this.toPlain(((SingleBooking)refObj).getName());
            }
            if (refObj instanceof SimpleBooking) {
                return this.toPlain(((SimpleBooking)refObj).getName());
            }
            if (refObj instanceof CompoundBooking) {
                return this.toPlain(((CompoundBooking)refObj).getName());
            }
            return null;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public short enableDisableCrxObject(CrxObject object, final boolean disable, final String reason, Counter counter) {
        short status = 0;
        try {
            Utils.traverseObjectTree(object, null, new Utils.TraverseObjectTreeCallback(){

                @Override
                public Object visit(RefObject_1_0 object, Object context) throws ServiceException {
                    block9: {
                        try {
                            Boolean isDisabled = (Boolean)object.refGetValue("disabled");
                            if (disable) {
                                if (Boolean.TRUE.equals(isDisabled)) break block9;
                                object.refSetValue("disabled", (Object)Boolean.TRUE);
                                try {
                                    object.refSetValue("disabledReason", (Object)reason);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (context instanceof Counter) {
                                    ((Counter)context).increment();
                                }
                                break block9;
                            }
                            if (!Boolean.TRUE.equals(isDisabled)) break block9;
                            object.refSetValue("disabled", (Object)Boolean.FALSE);
                            try {
                                object.refSetValue("disabledReason", (Object)reason);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (context instanceof Counter) {
                                ((Counter)context).increment();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return context;
                }
            }, counter);
        }
        catch (Exception e) {
            status = -1;
        }
        return status;
    }

    public EnableDisableCrxObjectResult disableCrxObject(CrxObject object, short mode, String reason) throws ServiceException {
        Counter counter = new Counter(0);
        short status = 0;
        try {
            if (mode == 0) {
                if (!Boolean.TRUE.equals(object.isDisabled())) {
                    object.setDisabled(true);
                    object.setDisabledReason(reason);
                    counter.increment();
                }
            } else {
                status = this.enableDisableCrxObject(object, true, reason, counter);
            }
        }
        catch (Exception e) {
            status = -1;
            new ServiceException(e).log();
        }
        return (EnableDisableCrxObjectResult)Structures.create(EnableDisableCrxObjectResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)EnableDisableCrxObjectResult.Member.status, (Object)status), Datatypes.member((Enum)EnableDisableCrxObjectResult.Member.count, (Object)counter.getValue())});
    }

    public EnableDisableCrxObjectResult enableCrxObject(CrxObject object, short mode, String reason) throws ServiceException {
        Counter counter = new Counter(0);
        short status = 0;
        try {
            if (mode == 0) {
                if (Boolean.TRUE.equals(object.isDisabled())) {
                    object.setDisabled(false);
                    counter.increment();
                }
            } else {
                status = this.enableDisableCrxObject(object, false, reason, counter);
            }
        }
        catch (Exception e) {
            status = -1;
            new ServiceException(e).log();
        }
        return (EnableDisableCrxObjectResult)Structures.create(EnableDisableCrxObjectResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)EnableDisableCrxObjectResult.Member.status, (Object)status), Datatypes.member((Enum)EnableDisableCrxObjectResult.Member.count, (Object)counter.getValue())});
    }

    public List<Path> getIndexableTypes() {
        ArrayList<Path> indexableTypes = new ArrayList<Path>();
        Model_1_0 model = Utils.getModel();
        try {
            for (ModelElement_1_0 element : model.getContent()) {
                Path type;
                if (!element.isClassType() || !model.isSubtypeOf((Object)element, (Object)"org:opencrx:kernel:base:Indexed") || model.isSubtypeOf((Object)element, (Object)"org:openmdx:base:Segment") || (type = model.getIdentityPattern(element)) == null) continue;
                indexableTypes.add(type);
            }
        }
        catch (ServiceException e) {
            e.log();
        }
        indexableTypes.addAll(Arrays.asList(new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityTracker/:*/followUp/:*"), new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityMilestone/:*/followUp/:*"), new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activityCategory/:*/followUp/:*"), new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/:*/segment/:*/account/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/lead/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/opportunity/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/quote/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/salesOrder/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/invoice/:*/address/:*"), new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/:*/segment/:*/account/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/lead/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/opportunity/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/quote/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/salesOrder/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/invoice/:*/note/:*"), new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/:*/segment/:*/account/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/:*/segment/:*/activity/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/lead/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/opportunity/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/quote/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/salesOrder/:*/media/:*"), new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/:*/segment/:*/invoice/:*/media/:*")));
        return indexableTypes;
    }

    protected ResultRecord newResult() throws ResourceException {
        return (ResultRecord)Records.getRecordFactory().createIndexedRecord(ResultRecord.class);
    }

    protected org.openmdx.base.rest.cci.QueryRecord newQuery(Path resourceIdentifier) {
        QueryRecord query = new QueryRecord();
        query.setResourceIdentifier(resourceIdentifier);
        return query;
    }

    protected ObjectRecord retrieveObject(RestInteractionCallback restInteractionCallback, Path resourceIdentifier, String fetchGroupName) throws ResourceException {
        ResultRecord result = this.newResult();
        org.openmdx.base.rest.cci.QueryRecord query = this.newQuery(resourceIdentifier);
        query.setFetchGroupName(fetchGroupName);
        restInteractionCallback.get(query, result);
        return result.isEmpty() ? null : (ObjectRecord)result.get(0);
    }

    protected ResultRecord retrieveObjects(RestInteractionCallback restInteractionCallback, Path resourceIdentifier, org.openmdx.base.rest.cci.QueryRecord query, String fetchGroupName) throws ResourceException {
        ResultRecord result = this.newResult();
        query.setFetchGroupName(fetchGroupName);
        restInteractionCallback.find(query, result);
        return result;
    }

    public List<String> getKeywords(MappedRecord object, Integer keywordLengthMin, Integer keywordLengthMax, Set<String> indexedAttributes, RestInteractionCallback restInteractionCallback) throws ServiceException, ResourceException {
        Object_2Facade objectFacade = Facades.asObject((MappedRecord)object);
        Path objPath = Object_2Facade.getPath((MappedRecord)object);
        ArrayList<String> keywords = new ArrayList<String>();
        for (String attribute : indexedAttributes) {
            if (!objectFacade.getValue().keySet().contains(attribute)) continue;
            for (Object value : objectFacade.attributeValuesAsList(attribute)) {
                Reader text = null;
                boolean isXml = false;
                if (value instanceof String) {
                    text = new StringReader((String)value);
                } else if (value instanceof InputStream || value instanceof byte[] || value instanceof BinaryLargeObject) {
                    if (value instanceof byte[]) {
                        value = new ByteArrayInputStream((byte[])value);
                    } else if (value instanceof BinaryLargeObject) {
                        try {
                            value = ((BinaryLargeObject)value).getContent();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String contentName = (String)objectFacade.attributeValuesAsList(attribute + "Name").get(0);
                    String contentMimeType = (String)objectFacade.attributeValuesAsList(attribute + "MimeType").get(0);
                    if (contentName != null) {
                        if ("text/rtf".equals(contentMimeType) || contentName.endsWith(".rtf")) {
                            try {
                                text = RTFToText.toTextAsReader((InputStream)value);
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Cannot extract text from a RTF document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if ("application/pdf".equals(contentMimeType) || contentName.endsWith(".pdf")) {
                            try {
                                text = new PDFToText().parse((InputStream)value);
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not extract text from PDF document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if ("application/vnd.ms-excel".equals(contentMimeType) || "application/ms-excel".equals(contentMimeType) || contentName.endsWith(".xls")) {
                            try {
                                text = new ExcelToText().parse((InputStream)value);
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not extract text from Excel document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if ("application/vnd.ms-word".equals(contentMimeType) || "application/ms-word".equals(contentMimeType) || contentName.endsWith(".doc")) {
                            try {
                                text = new WordToText().parse((InputStream)value);
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not extract text from Word document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if (contentMimeType != null && contentMimeType.startsWith("application/vnd.openxmlformats") || contentName.endsWith(".docx") || contentName.endsWith(".dotx") || contentName.endsWith(".xlsx") || contentName.endsWith(".xltx")) {
                            try {
                                text = new XmlDocToText().parse((InputStream)value);
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not extract text from XML document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if (contentName.endsWith(".odt") || contentName.endsWith(".odp") || contentName.endsWith(".ods")) {
                            try {
                                ZipInputStream document = new ZipInputStream((InputStream)value);
                                text = new OpenOfficeToText().parse(document);
                                isXml = true;
                            }
                            catch (Exception e) {
                                SysLog.warning((String)"Can not extract text from OpenOffice document", Arrays.asList(contentName, e.getMessage()));
                            }
                        } else if ("text/plain".equals(contentMimeType) || contentName.endsWith(".txt")) {
                            text = new InputStreamReader((InputStream)value);
                        } else if ("text/html".equals(contentMimeType) || "text/xml".equals(contentMimeType) || "application/xml".equals(contentMimeType) || contentName.endsWith(".xml") || contentName.endsWith(".html") || contentName.endsWith(".htm")) {
                            text = new InputStreamReader((InputStream)value);
                            isXml = true;
                        }
                    }
                }
                if (text == null) continue;
                try {
                    int ch = ((Reader)text).read();
                    while (ch != -1) {
                        if (isXml && ch == 60) {
                            while (ch != -1 && ch != 62) {
                                ch = ((Reader)text).read();
                            }
                            if (ch != -1) {
                                ch = ((Reader)text).read();
                            }
                        }
                        StringBuilder keyword = new StringBuilder();
                        boolean isKeyword = false;
                        while (ch != -1 && (!isXml || isXml && ch != 60) && Character.isLetterOrDigit((char)ch) || ch == 45 || ch == 95 || ch == 64 || ch == 46) {
                            keyword.append((char)ch);
                            ch = ((Reader)text).read();
                            isKeyword = true;
                        }
                        if (!(isKeyword || isXml && ch == 60)) {
                            ch = ((Reader)text).read();
                            continue;
                        }
                        if (keyword.length() < keywordLengthMin || keyword.length() >= keywordLengthMax) continue;
                        String normalizedKeyword = keyword.toString().toLowerCase();
                        while (normalizedKeyword.endsWith("-") || normalizedKeyword.endsWith("_") || normalizedKeyword.endsWith("@") || normalizedKeyword.endsWith(".")) {
                            normalizedKeyword = normalizedKeyword.substring(0, normalizedKeyword.length() - 1);
                        }
                        if (keywords.contains(normalizedKeyword)) continue;
                        keywords.add(normalizedKeyword);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (Utils.isInstanceOf(object, "org:opencrx:kernel:account1:Account")) {
            org.openmdx.base.rest.cci.QueryRecord query = this.newQuery(objPath.getDescendant(new String[]{"address"}));
            query.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
            query.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.FOR_ALL, "disabled", true, new Object[]{Boolean.FALSE}));
            ResultRecord addresses = this.retrieveObjects(restInteractionCallback, objPath.getDescendant(new String[]{"address"}), query, "all");
            for (Object address : addresses) {
                if (!(address instanceof MappedRecord)) continue;
                keywords.addAll(this.getKeywords((MappedRecord)address, keywordLengthMin, keywordLengthMax, indexedAttributes, restInteractionCallback));
            }
        }
        return keywords;
    }

    public boolean allowUpdateExistingIndexEntries() {
        return true;
    }

    public void updateIndexEntry(RestInteractionCallback restInteractionCallback, ObjectRecord indexEntry) throws ServiceException, ResourceException {
        ResultRecord existingIndexEntries = this.newResult();
        if (this.allowUpdateExistingIndexEntries()) {
            org.openmdx.base.rest.cci.QueryRecord query = this.newQuery(indexEntry.getResourceIdentifier().getParent());
            query.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
            query.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.THERE_EXISTS, "indexedObject", true, new Object[]{Facades.asObject((MappedRecord)indexEntry).attributeValue("indexedObject")}));
            existingIndexEntries = this.retrieveObjects(restInteractionCallback, indexEntry.getResourceIdentifier().getParent(), query, "all");
        }
        if (!existingIndexEntries.isEmpty()) {
            ObjectRecord existingIndexEntry = (ObjectRecord)existingIndexEntries.get(0);
            indexEntry.setResourceIdentifier(existingIndexEntry.getResourceIdentifier());
            restInteractionCallback.update(indexEntry, this.newResult());
        } else {
            restInteractionCallback.create(indexEntry, this.newResult());
        }
    }

    public List<String> getHashableFeatures(Hashable hashable, String name) throws ServiceException {
        if ("Default".equals(name)) {
            Model_1_0 model = Model_1Factory.getModel();
            ModelElement_1_0 classifier = model.getElement((Object)hashable.refClass().refMofId());
            Map attributeDefs = classifier.getModel().getAttributeDefs(classifier, false, true);
            ArrayList<String> hashableFeatures = new ArrayList<String>(attributeDefs.keySet());
            hashableFeatures.remove("identity");
            hashableFeatures.remove("modifiedAt");
            hashableFeatures.remove("modifiedBy");
            hashableFeatures.remove("owner");
            hashableFeatures.remove("owningGroup");
            hashableFeatures.remove("owningUser");
            return hashableFeatures;
        }
        return null;
    }

    public String getHashValue(Hashable hashable, String name, boolean deep) throws ServiceException {
        try {
            String hashValue = null;
            List<String> features = this.getHashableFeatures(hashable, name);
            if (features != null) {
                Collections.sort(features);
                MessageDigest md = MessageDigest.getInstance("MD5");
                for (String feature : features) {
                    md.update((feature + ":" + hashable.refGetValue(feature)).getBytes());
                }
                hashValue = Base64.encode((byte[])md.digest());
            }
            return hashValue;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void updateHashValue(Hashable hashable, String name, HashEntry hashEntry, String hashValue) throws ServiceException {
        if (!Utils.areEqual(hashValue, hashEntry.getHashValue())) {
            hashEntry.setHashValue(hashValue);
            hashEntry.setHashValueModifiedAt(new Date());
        }
    }

    public String updateHash(Hashable hashable, String name) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)hashable);
        String hashValue = null;
        try {
            hashValue = this.getHashValue(hashable, name, true);
            if (hashValue != null) {
                HashEntryQuery hashEntryQuery = (HashEntryQuery)pm.newQuery(HashEntry.class);
                hashEntryQuery.name().equalTo((Object)name);
                hashEntryQuery.orderByCreatedAt().ascending();
                HashEntry hashEntry = null;
                List hashEntries = hashable.getHashEntry(hashEntryQuery);
                if (!hashEntries.isEmpty()) {
                    hashEntry = (HashEntry)hashEntries.iterator().next();
                } else {
                    hashEntry = (HashEntry)pm.newInstance(HashEntry.class);
                    hashEntry.setName(name);
                    hashable.addHashEntry(this.getUidAsString(), hashEntry);
                }
                this.updateHashValue(hashable, name, hashEntry, hashValue);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return hashValue;
    }

    public static class Counter {
        private int counter;

        public Counter(int initialValue) {
            this.counter = initialValue;
        }

        public void increment() {
            ++this.counter;
        }

        public int getValue() {
            return this.counter;
        }
    }

    public static interface CodeMapper {
        public String getLocaleText(short var1);

        public String getCurrencyText(short var1, short var2);

        public String getCountryText(short var1, short var2);
    }

    public static interface RestInteractionCallback {
        public void get(org.openmdx.base.rest.cci.QueryRecord var1, ResultRecord var2) throws ResourceException;

        public void find(org.openmdx.base.rest.cci.QueryRecord var1, ResultRecord var2) throws ResourceException;

        public void create(ObjectRecord var1, ResultRecord var2) throws ResourceException;

        public void update(ObjectRecord var1, ResultRecord var2) throws ResourceException;
    }
}

