/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.admin1.aop2;

import java.io.File;
import java.util.ArrayList;
import org.opencrx.kernel.admin1.cci2.ConvertMediaXriToPathResult;
import org.opencrx.kernel.admin1.cci2.CreateAdministratorResult;
import org.opencrx.kernel.admin1.cci2.ImportLoginPrincipalsResult;
import org.opencrx.kernel.admin1.cci2.Segment;
import org.opencrx.kernel.admin1.jmi1.Admin1Package;
import org.opencrx.kernel.admin1.jmi1.ConvertMediaXriToPathParams;
import org.opencrx.kernel.admin1.jmi1.ConvertMediaXriToPathResult;
import org.opencrx.kernel.admin1.jmi1.CreateAdministratorParams;
import org.opencrx.kernel.admin1.jmi1.CreateAdministratorResult;
import org.opencrx.kernel.admin1.jmi1.ImportLoginPrincipalsParams;
import org.opencrx.kernel.admin1.jmi1.ImportLoginPrincipalsResult;
import org.opencrx.kernel.backend.Admin;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.layer.persistence.Media_2;
import org.openmdx.base.accessor.jmi.cci.JmiServiceException;
import org.openmdx.base.aop2.AbstractObject;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class SegmentImpl<S extends org.opencrx.kernel.admin1.jmi1.Segment, N extends Segment, C extends Void>
extends AbstractObject<S, N, C> {
    public SegmentImpl(S same, N next) {
        super(same, next);
    }

    public CreateAdministratorResult createAdministrator(CreateAdministratorParams params) {
        try {
            String segmentName = params.getSegmentName() != null ? params.getSegmentName() : "Standard";
            String adminPrincipalName = params.getAdminPrincipalName() != null ? params.getAdminPrincipalName() : "admin" + SecurityKeys.ID_SEPARATOR + segmentName;
            String initialPassword = params.getInitialPassword();
            String initialPasswordVerification = params.getInitialPasswordVerification();
            ArrayList<String> errors = new ArrayList<String>();
            Admin.getInstance().createAdministrator((org.opencrx.kernel.admin1.jmi1.Segment)this.sameObject(), segmentName, adminPrincipalName, initialPassword, initialPasswordVerification, errors);
            if (!errors.isEmpty()) {
                return ((Admin1Package)((org.opencrx.kernel.admin1.jmi1.Segment)this.sameObject()).refOutermostPackage().refPackage(Admin1Package.class.getName())).createCreateAdministratorResult((short)1, ((Object)errors).toString());
            }
            return (CreateAdministratorResult)Structures.create(CreateAdministratorResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CreateAdministratorResult.Member.status, (Object)0), Datatypes.member((Enum)CreateAdministratorResult.Member.statusMessage, null)});
        }
        catch (Exception e) {
            throw new JmiServiceException((Throwable)e);
        }
    }

    public ImportLoginPrincipalsResult importLoginPrincipals(ImportLoginPrincipalsParams params) {
        try {
            String statusMessage = Admin.getInstance().importLoginPrincipals((org.opencrx.kernel.admin1.jmi1.Segment)this.sameObject(), params.getItem());
            return (ImportLoginPrincipalsResult)Structures.create(ImportLoginPrincipalsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ImportLoginPrincipalsResult.Member.statusMessage, (Object)statusMessage)});
        }
        catch (ServiceException e) {
            throw new JmiServiceException((Throwable)e);
        }
    }

    public ConvertMediaXriToPathResult convertMediaXriToPath(ConvertMediaXriToPathParams in) {
        File mediaFile = null;
        try {
            Path mediaIdentity = new Path(in.getMediaXri());
            File mediadir = Media_2.getMediaDir(mediaIdentity);
            if (mediadir != null) {
                mediaFile = new File(Media_2.toContentDir(mediadir, mediaIdentity), mediaIdentity.getLastSegment().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ConvertMediaXriToPathResult)Structures.create(ConvertMediaXriToPathResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ConvertMediaXriToPathResult.Member.mediaPath, (Object)(mediaFile == null ? null : mediaFile.getAbsolutePath()))});
    }
}

