/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.webdav.DocumentProfileResource;
import org.opencrx.application.webdav.WebDavResource;
import org.opencrx.kernel.home1.cci2.DocumentProfileQuery;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;
import org.opencrx.kernel.home1.jmi1.UserHome;

class UserHomeResource
extends WebDavResource {
    public UserHomeResource(RequestContext requestContext, UserHome userHome) {
        super(requestContext, userHome);
    }

    @Override
    public UserHome getObject() {
        return (UserHome)super.getObject();
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getContact().getFullName();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        UserHome userHome = this.getObject();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)userHome);
        ArrayList<Resource> children = new ArrayList<Resource>();
        DocumentProfileQuery query = (DocumentProfileQuery)pm.newQuery(DocumentProfile.class);
        List documentProfiles = userHome.getSyncProfile(query);
        for (DocumentProfile documentProfile : documentProfiles) {
            children.add(new DocumentProfileResource((RequestContext)this.getRequestContext(), documentProfile));
        }
        return children;
    }
}

