/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.webdav.DocumentFilterFeedResource;
import org.opencrx.application.webdav.DocumentFolderFeedResource;
import org.opencrx.application.webdav.WebDavResource;
import org.opencrx.kernel.home1.cci2.DocumentFeedQuery;
import org.opencrx.kernel.home1.cci2.DocumentFilterFeedQuery;
import org.opencrx.kernel.home1.jmi1.DocumentFeed;
import org.opencrx.kernel.home1.jmi1.DocumentFilterFeed;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;

class DocumentProfileResource
extends WebDavResource {
    public DocumentProfileResource(RequestContext requestContext, DocumentProfile syncProfile) {
        super(requestContext, syncProfile);
    }

    @Override
    public DocumentProfile getObject() {
        return (DocumentProfile)super.getObject();
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getName();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        DocumentProfile syncProfile = this.getObject();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)syncProfile);
        ArrayList<Resource> children = new ArrayList<Resource>();
        DocumentFeedQuery documentFeedQuery = (DocumentFeedQuery)pm.newQuery(DocumentFeed.class);
        documentFeedQuery.thereExistsIsActive().isTrue();
        for (DocumentFeed documentFeed : syncProfile.getFeed(documentFeedQuery)) {
            children.add(new DocumentFolderFeedResource((RequestContext)this.getRequestContext(), documentFeed));
        }
        DocumentFilterFeedQuery documentFilterFeedQuery = (DocumentFilterFeedQuery)pm.newQuery(DocumentFilterFeed.class);
        documentFilterFeedQuery.thereExistsIsActive().isTrue();
        for (DocumentFilterFeed documentFilterFeed : syncProfile.getFeed(documentFilterFeedQuery)) {
            children.add(new DocumentFilterFeedResource((RequestContext)this.getRequestContext(), documentFilterFeed));
        }
        return children;
    }
}

