/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.vcard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.carddav.AccountResource;
import org.opencrx.application.uses.ezvcard.Ezvcard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.property.Photo;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.VCard;
import org.opencrx.kernel.utils.AccountQueryHelper;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;

public class VCardServlet
extends HttpServlet {
    private static final long serialVersionUID = -7557742069034207175L;
    protected static final String CONFIGURATION_ID = "VCardServlet";
    protected static final String RESOURCE_NAME_ACCOUNTS_VCF = "accounts.vcf";
    protected static final String RESOURCE_TYPE_VCF = "vcf";
    protected static final String PARAMETER_NAME_TYPE = "type";
    protected static final String PARAMETER_NAME_RESOURCE = "resource";
    protected PersistenceManagerFactory persistenceManagerFactory = null;

    public void init(ServletConfig config) throws ServletException {
        super.init();
        if (this.persistenceManagerFactory == null) {
            try {
                Utils.getModel();
                this.persistenceManagerFactory = Utils.getPersistenceManagerFactory();
            }
            catch (ServiceException e) {
                throw new ServletException("Can not get persistence manager", (Throwable)e);
            }
        }
    }

    protected PersistenceManager getPersistenceManager(HttpServletRequest req) {
        return req.getUserPrincipal() == null ? null : this.persistenceManagerFactory.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    protected PersistenceManager getRootPersistenceManager() {
        return this.persistenceManagerFactory.getPersistenceManager("admin-Root", null);
    }

    protected ComponentConfiguration getComponentConfiguration(String providerName, PersistenceManager rootPm) {
        return ComponentConfigHelper.getComponentConfiguration(CONFIGURATION_ID, providerName, rootPm, false, null);
    }

    protected AccountQueryHelper getAccountsHelper(PersistenceManager pm, String requestedAccountFilter) {
        AccountQueryHelper accountsHelper = new AccountQueryHelper(pm);
        if (requestedAccountFilter != null) {
            try {
                accountsHelper.parseQueryId((requestedAccountFilter.startsWith("/") ? "" : "/") + requestedAccountFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return accountsHelper;
    }

    protected Account findAccount(PersistenceManager pm, AccountQueryHelper accountsHelper, String uid) {
        AccountQuery query = (AccountQuery)pm.newQuery(Account.class);
        query.thereExistsExternalLink().equalTo((Object)("VCARD:" + uid));
        List accounts = accountsHelper.getAccountSegment().getAccount(query);
        if (accounts.isEmpty()) {
            query = (AccountQuery)pm.newQuery(Account.class);
            query.thereExistsExternalLink().equalTo((Object)("VCARD:" + uid.replace('.', '+')));
            accounts = accountsHelper.getAccountSegment().getAccount(query);
            if (accounts.isEmpty()) {
                return null;
            }
            return (Account)accounts.iterator().next();
        }
        return (Account)accounts.iterator().next();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = this.getPersistenceManager(req);
        PersistenceManager rootPm = this.getRootPersistenceManager();
        if (pm == null) {
            resp.setStatus(401);
            return;
        }
        String requestedAccountFilter = req.getParameter("id");
        AccountQueryHelper accountsHelper = this.getAccountsHelper(pm, requestedAccountFilter);
        ComponentConfiguration componentConfiguration = this.getComponentConfiguration(accountsHelper.getAccountSegment().refGetPath().get(2), rootPm);
        String maxAccountsValue = componentConfiguration == null ? null : ComponentConfigHelper.getComponentConfigProperty("maxAccounts", componentConfiguration).getStringValue();
        int maxAccounts = Integer.valueOf(maxAccountsValue == null ? "500" : maxAccountsValue);
        if (req.getRequestURI().endsWith("/vcard") || req.getRequestURI().endsWith("/accounts")) {
            if (RESOURCE_NAME_ACCOUNTS_VCF.equals(req.getParameter(PARAMETER_NAME_RESOURCE)) || RESOURCE_TYPE_VCF.equals(req.getParameter(PARAMETER_NAME_TYPE))) {
                try {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setStatus(200);
                    AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
                    accountQuery.forAllDisabled().isFalse();
                    accountQuery.vcard().isNonNull();
                    PrintWriter p = resp.getWriter();
                    int n = 0;
                    for (Account account : accountsHelper.getFilteredAccounts(accountQuery)) {
                        String vcard = account.getVcard();
                        if (vcard != null && vcard.indexOf("BEGIN:VCARD") >= 0) {
                            Photo photo;
                            org.opencrx.application.uses.ezvcard.VCard vCard = Ezvcard.parse(vcard).first();
                            if (vCard.getUrls().isEmpty()) {
                                String url = null;
                                try {
                                    url = Base.getInstance().getAccessUrl(req, "-carddav-", account);
                                    vCard.addUrl(url);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (vCard.getPhotos().isEmpty() && (photo = AccountResource.getPhoto(account)) != null) {
                                vCard.addPhoto(photo);
                            }
                            try {
                                Ezvcard.write(vCard).version(VCardVersion.V3_0).go(p);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (++n % 50 == 0) {
                            pm.evictAll();
                        }
                        if (n <= maxAccounts) continue;
                        break;
                    }
                    p.flush();
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    resp.setStatus(500);
                }
            } else {
                super.doGet(req, resp);
            }
        } else {
            super.doGet(req, resp);
        }
        try {
            if (pm != null) {
                pm.close();
            }
            if (rootPm != null) {
                rootPm.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        PersistenceManager pm = this.getPersistenceManager(req);
        if (pm == null) {
            resp.setStatus(401);
            return;
        }
        String filterId = req.getParameter("id");
        AccountQueryHelper accountsHelper = this.getAccountsHelper(pm, filterId);
        if (req.getRequestURI().endsWith("/vcard") || req.getRequestURI().endsWith("/accounts")) {
            if (RESOURCE_NAME_ACCOUNTS_VCF.equals(req.getParameter(PARAMETER_NAME_RESOURCE)) || RESOURCE_TYPE_VCF.equals(req.getParameter(PARAMETER_NAME_TYPE))) {
                Segment accountSegment = accountsHelper.getAccountSegment();
                resp.setStatus(200);
                resp.setCharacterEncoding("UTF-8");
                BufferedReader reader = new BufferedReader(req.getReader());
                String l = null;
                while ((l = reader.readLine()) != null) {
                    if (!l.toUpperCase().startsWith("BEGIN:VCARD")) continue;
                    StringBuilder vcard = new StringBuilder();
                    vcard.append("BEGIN:VCARD\n");
                    String uid = null;
                    String rev = null;
                    while ((l = reader.readLine()) != null) {
                        vcard.append(l).append("\n");
                        if (l.startsWith("UID:")) {
                            uid = l.substring(4);
                            continue;
                        }
                        if (l.startsWith("REV:")) {
                            rev = l.substring(4);
                            continue;
                        }
                        if (!l.startsWith("END:VCARD")) continue;
                    }
                    SysLog.trace((String)"VCARD", (Object)vcard);
                    if (uid != null && rev != null) {
                        SysLog.detail((String)"Lookup account", uid);
                        Account account = this.findAccount(pm, accountsHelper, uid);
                        if (account != null) {
                            try {
                                VCard.getInstance().putVCard(new BufferedReader(new StringReader(vcard.toString())), accountSegment);
                            }
                            catch (Exception e) {
                                ServiceException e0 = new ServiceException(e, "DefaultDomain", -19, "Unable to update vcard", new BasicException.Parameter[]{new BasicException.Parameter("VCARD", (Object)vcard)});
                                e0.log();
                                try {
                                    pm.currentTransaction().rollback();
                                }
                                catch (Exception exception) {}
                            }
                            continue;
                        }
                        SysLog.detail((String)"Skipping ", (Object)new String[]{"UID: " + uid, "REV: " + rev, "Account.number: " + (account == null ? null : account.refMofId()), "Account.modifiedAt:" + (account == null ? null : account.getModifiedAt())});
                        continue;
                    }
                    SysLog.detail((String)"Skipping", (Object)vcard);
                }
            } else {
                super.doPut(req, resp);
            }
        } else {
            super.doPut(req, resp);
        }
        try {
            pm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

