/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opencrx.application.uses.org.apache.commons.csv.CSVFormat;
import org.opencrx.application.uses.org.apache.commons.csv.CSVLexer;
import org.opencrx.application.uses.org.apache.commons.csv.CSVRecord;
import org.opencrx.application.uses.org.apache.commons.csv.ExtendedBufferedReader;
import org.opencrx.application.uses.org.apache.commons.csv.Lexer;
import org.opencrx.application.uses.org.apache.commons.csv.Token;

public class CSVParser
implements Iterable<CSVRecord> {
    private final Lexer lexer;
    private final Map<String, Integer> headerMap;
    private long recordNumber;
    private final List<String> record = new ArrayList<String>();
    private final Token reusableToken = new Token();

    public CSVParser(Reader input) throws IOException {
        this(input, CSVFormat.DEFAULT);
    }

    public CSVParser(Reader input, CSVFormat format) throws IOException {
        format.validate();
        this.lexer = new CSVLexer(format, new ExtendedBufferedReader(input));
        this.headerMap = this.initializeHeader(format);
    }

    public CSVParser(String input, CSVFormat format) throws IOException {
        this(new StringReader(input), format);
    }

    public Map<String, Integer> getHeaderMap() {
        return new LinkedHashMap<String, Integer>(this.headerMap);
    }

    public long getLineNumber() {
        return this.lexer.getLineNumber();
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    CSVRecord nextRecord() throws IOException {
        CSVRecord result = null;
        this.record.clear();
        StringBuilder sb = null;
        do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.record.add(this.reusableToken.content.toString());
                    break;
                }
                case EORECORD: {
                    this.record.add(this.reusableToken.content.toString());
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) break;
                    this.record.add(this.reusableToken.content.toString());
                    break;
                }
                case INVALID: {
                    throw new IOException("(line " + this.getLineNumber() + ") invalid parse sequence");
                }
                case COMMENT: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append("\n");
                    }
                    sb.append((CharSequence)this.reusableToken.content);
                    this.reusableToken.type = Token.Type.TOKEN;
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.record.isEmpty()) {
            ++this.recordNumber;
            String comment = sb == null ? null : sb.toString();
            result = new CSVRecord(this.record.toArray(new String[this.record.size()]), this.headerMap, comment, this.recordNumber);
        }
        return result;
    }

    public List<CSVRecord> getRecords() throws IOException {
        CSVRecord rec;
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        while ((rec = this.nextRecord()) != null) {
            records.add(rec);
        }
        return records;
    }

    private Map<String, Integer> initializeHeader(CSVFormat format) throws IOException {
        LinkedHashMap<String, Integer> hdrMap = null;
        String[] header = null;
        if (format.getHeader() == null) {
            CSVRecord rec = this.nextRecord();
            if (rec != null) {
                header = rec.values();
            }
        } else if (format.getHeader() != null) {
            header = format.getHeader();
        }
        if (header != null) {
            hdrMap = new LinkedHashMap<String, Integer>();
            for (int i = 0; i < header.length; ++i) {
                hdrMap.put(header[i], i);
            }
        }
        return hdrMap;
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return new Iterator<CSVRecord>(){
            private CSVRecord current;

            private CSVRecord getNextRecord() {
                try {
                    return CSVParser.this.nextRecord();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.current = this.getNextRecord();
                }
                return this.current != null;
            }

            @Override
            public CSVRecord next() {
                CSVRecord next = this.current;
                this.current = null;
                if (next == null && (next = this.getNextRecord()) == null) {
                    throw new NoSuchElementException("No more CSV records available");
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

